package fr.ifremer.isisfish.ui.simulator;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.simulator.SimulationPlan;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class PlanUI extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK2VS09TQRTHp5VXeYlUEBQiT3VhbsFEYwJBHoYAKYpUDbEbp71TOmTuw5m5cHVh/Ah+BN27MXHnyrhw7cKN8SsY48Kt8czccsvVS3sTZNGSmfn/zv+cmXP65jtqFRyN72HfN7hnS2oRY2NpZ+duaY+U5W0iypy60uEo+EulUbqIusxwXUg0Wcwrea4mz604luvYxD6insujTiGfMiKqhEiJRqOKshC5Qrg957seP6SGpuKor37+SL80X7xOI+S74K4bUhlrpqpn0pJHaWpK1A+R9nGOYXsXbHBq74LfHrW2wrAQd7BFnqDnqD2P2lzMASbRRPKUNUPrfVei9qn7uMTIjESXK9ygFU4sAt+CigoVVcOjhqCWxzAQjC1w9GDddbW6DbRVbJuMcImuJtKuBcfrgOkKJcwsqENbmGNLFILz1LHVeVEgDC5dogGVu2+IAyiFsQHJlZxlx1eQTMjqmdoolLnDgGSrdM5FNPWtqGqCUSGPN5CHXYnORFBqTan763UIajgr0VDksgOB3otGnSx5Ujr28XGXTHgG2UjYZS1RgKGQc6kZZ5tYzr4OPhpVTjdTrjCCeYwwUuZZtXg2mtt5cSwTXnYkpbAyE6E6M1VLdCaMDWiOLkQKC/1p1Puz3kCpImrlHizDTRT/belt2AqaeeivZlZAvft7MPvl/bd3q4cd3AuxB2KPHhlA0Fkud1xoBKpCnw7a15OU5TaxO1dEGaEfsp5OIzHGCrVtMAfx9HMzlNxYw6IKiNb2rx8+Dj7+fAqlV1Enc7C5itX5dZSRVQ5VcJjpu7cWtaPugw747FPeJOqA8WASrnq0d97EEo+VqG1C9Rd8KMNITBlCL6XMp1/ZwtvFw1KkwNrwscfr5Wh9hNqozahN9DirTarY8dXlCuKZTn0ixc2olPruc2tTw9Cf1+Jy7bKoDQ/OKtBnOsB131NfN7R39d9NjcomQPW4nFQI58T8D7DuMmFsu3YPDViDSYwFLwk6atMxGxlLAmux4SqgKeeD6xrDEn5sYDCQhXjmcBKmJL4ej/fiGSMJGO3EVpPBbIC52BSjlh+emFBsQBg/sYdkhK0GhOkE5cxw52CN0N1qo3tpDmqWzBUg/AGh3nmGvwkAAA==";
    private static final Log log = LogFactory.getLog(PlanUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton buttonSimulParamsSimulationPlansAdd;
    protected JButton buttonSimulParamsSimulationPlansClear;
    protected JButton buttonSimulParamsSimulationPlansRemove;
    protected JComboBox<String> fieldSimulParamsSimulationPlansSelect;
    protected PlanHandler handler;
    protected JList<SimulationPlan> listSimulParamsSimulationPlansList;
    protected JTable simulParamsSimulationPlans;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JButton $JButton0;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private PlanUI $Table0 = this;
    private Table $Table1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
            handler.afterInit();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public PlanUI() {
        $initialize();
    }

    public PlanUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getParentContainer(fr.ifremer.isisfish.ui.SimulationUI.class).selectParametersTab();
    }

    public void doActionPerformed__on__buttonSimulParamsSimulationPlansAdd(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addSimulationPlan();
    }

    public void doActionPerformed__on__buttonSimulParamsSimulationPlansClear(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.clearSimulationPlan();
    }

    public void doActionPerformed__on__buttonSimulParamsSimulationPlansRemove(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.removeSimulationPlan();
    }

    public void doValueChanged__on__listSimulParamsSimulationPlansList(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setSimulationPlanButtons();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getButtonSimulParamsSimulationPlansAdd() {
        return buttonSimulParamsSimulationPlansAdd;
    }

    public JButton getButtonSimulParamsSimulationPlansClear() {
        return buttonSimulParamsSimulationPlansClear;
    }

    public JButton getButtonSimulParamsSimulationPlansRemove() {
        return buttonSimulParamsSimulationPlansRemove;
    }

    public JComboBox<String> getFieldSimulParamsSimulationPlansSelect() {
        return fieldSimulParamsSimulationPlansSelect;
    }

    public PlanHandler getHandler() {
        return handler;
    }

    public JList<SimulationPlan> getListSimulParamsSimulationPlansList() {
        return listSimulParamsSimulationPlansList;
    }

    public JTable getSimulParamsSimulationPlans() {
        return simulParamsSimulationPlans;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createButtonSimulParamsSimulationPlansAdd() {
        $objectMap.put("buttonSimulParamsSimulationPlansAdd", buttonSimulParamsSimulationPlansAdd = new JButton());
        
        buttonSimulParamsSimulationPlansAdd.setName("buttonSimulParamsSimulationPlansAdd");
        buttonSimulParamsSimulationPlansAdd.setText(t("isisfish.common.add"));
        buttonSimulParamsSimulationPlansAdd.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__buttonSimulParamsSimulationPlansAdd"));
    }

    protected void createButtonSimulParamsSimulationPlansClear() {
        $objectMap.put("buttonSimulParamsSimulationPlansClear", buttonSimulParamsSimulationPlansClear = new JButton());
        
        buttonSimulParamsSimulationPlansClear.setName("buttonSimulParamsSimulationPlansClear");
        buttonSimulParamsSimulationPlansClear.setEnabled(false);
        buttonSimulParamsSimulationPlansClear.setText(t("isisfish.common.clear"));
        buttonSimulParamsSimulationPlansClear.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__buttonSimulParamsSimulationPlansClear"));
    }

    protected void createButtonSimulParamsSimulationPlansRemove() {
        $objectMap.put("buttonSimulParamsSimulationPlansRemove", buttonSimulParamsSimulationPlansRemove = new JButton());
        
        buttonSimulParamsSimulationPlansRemove.setName("buttonSimulParamsSimulationPlansRemove");
        buttonSimulParamsSimulationPlansRemove.setEnabled(false);
        buttonSimulParamsSimulationPlansRemove.setText(t("isisfish.common.remove"));
        buttonSimulParamsSimulationPlansRemove.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__buttonSimulParamsSimulationPlansRemove"));
    }

    protected void createFieldSimulParamsSimulationPlansSelect() {
        $objectMap.put("fieldSimulParamsSimulationPlansSelect", fieldSimulParamsSimulationPlansSelect = new JComboBox<String>());
        
        fieldSimulParamsSimulationPlansSelect.setName("fieldSimulParamsSimulationPlansSelect");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new PlanHandler(this));
    }

    protected void createListSimulParamsSimulationPlansList() {
        $objectMap.put("listSimulParamsSimulationPlansList", listSimulParamsSimulationPlansList = new JList<SimulationPlan>());
        
        listSimulParamsSimulationPlansList.setName("listSimulParamsSimulationPlansList");
        listSimulParamsSimulationPlansList.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__listSimulParamsSimulationPlansList"));
    }

    protected void createSimulParamsSimulationPlans() {
        $objectMap.put("simulParamsSimulationPlans", simulParamsSimulationPlans = new JTable());
        
        simulParamsSimulationPlans.setName("simulParamsSimulationPlans");
        simulParamsSimulationPlans.setName("isisfish.sens.planParameters");
        simulParamsSimulationPlans.setRowHeight(24);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add(fieldSimulParamsSimulationPlansSelect, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($Table1, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane1, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($JButton0, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(listSimulParamsSimulationPlansList);
        // inline complete setup of $Table1
        $Table1.add(buttonSimulParamsSimulationPlansAdd, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(buttonSimulParamsSimulationPlansRemove, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(buttonSimulParamsSimulationPlansClear, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(simulParamsSimulationPlans);
        
        // apply 5 property setters
        fieldSimulParamsSimulationPlansSelect.setRenderer(new fr.ifremer.isisfish.ui.models.simulationplan.SimulationPlanComboRenderer());
        $JScrollPane0.setMinimumSize(new Dimension(0,0));
        $JScrollPane0.setPreferredSize(new Dimension(0,0));
        listSimulParamsSimulationPlansList.setCellRenderer(new fr.ifremer.isisfish.ui.models.simulationplan.SimulationPlanListRenderer());
        listSimulParamsSimulationPlansList.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createHandler();
        createFieldSimulParamsSimulationPlansSelect();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createListSimulParamsSimulationPlansList();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        $Table1.setName("isisfish.sens.title");
        createButtonSimulParamsSimulationPlansAdd();
        createButtonSimulParamsSimulationPlansRemove();
        createButtonSimulParamsSimulationPlansClear();
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createSimulParamsSimulationPlans();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(t("isisfish.sens.backParameter"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $Table0
        setName("$Table0");
        
        $completeSetup();
    }

}