package fr.ifremer.isisfish.ui.sensitivity;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.export.SensitivityExport;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class SensitivityChooserUI extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWWQW8bRRTHJ6ZO4rSlTawkbZNCoAG1UrtuAqJSE5WmKVGauqWKQapqIXXsGdtTjXeWmdlk00PVbwAHPgDcuSBx44Q4cObABfEVEOLAteqbWWfXa282qzqHsTPz3u/935uZN/7xH1RUEr33DAeBI31Xsy51djYeP/688Yw29V2qmpJ5WkgU/o0VUKGOTpJoXml0qV417pWee2VTdD3hUrfPe62KppQ+4FR1KNUaXUx6NJWq1KLltcDz5SE1EpVG/f6/fwvfkpc/FBAKPFA3B6ksHecVZ3KiigqMaDQDkfZwhWO3DTIkc9ug97SZ2+RYqYe4S79GL9BEFY17WAJMo/fzp2wZ1j/wNJpY/gI3OL2u0Y2WdFhL0i6FT8VUi6mO4zNHUVcxzfaYPnBq8ffNjhCKyi/veZ6ljQOrg13CqdRo/Y1Y26F7DJxc3qniBuWgbsakHzhqH6rhhLPGqBTZvtNilJM+6IaL+QHErlEOJ0ej2QQBKtQQd0SQhJxe3qk1peD8EXZNTeYTPvFS0uuiYl2fp4R+hCXuDmq39TaesxFgroWbsEWbWBIGrkAwQfigp51Mhj6s0Ir5f9oMC9HawhA1mcB80nx6yNwsXDDD0lC81SherKV3lFY0Opc486H6KO0jqr0SSfowzgCyZ9w49hX3s8ATUsM9n04eCaa0cbsyqMdKvZwEn8GEhJw7vtbC1aicgIWzxtiJfGbgOIs92u9mVlYHrJqcYtnTeKRVIvPVlMwvKHtqKRlO3FhcM8ONdNxHES6u9DS1vvY8qmgn7N6uedCkFhIbBu3Pidtf3J/G6qgofZiGHa4Pd8xdWAp75bmBXmmAdvXVXPnPX/7+eeuwQc5D7NlU077+Do3Lk8KDvsJM6DNhd/Q145UH2Furo1JYLNv8F1OE1XrLIA7i2WPjGHdnG6sOIIoTf/3629zTP95ChS00xQUmW/Yq3EMl3ZFQBcFJ4H162yo6tT8J41mjTaMTmgbQWmbWmcuZS5ewhnbd8DW9FUAZFlPKEGlplH7/v1z76fZhKcZA2vkjzeNyFJ+g8TCafS16D0Hq63DSU9QnIm74aU/AmPk86/Wa7l07bqflWuwKYnrS2+sEa7zUYC70iTYkajyqNgPz7aEFlnMAJ+HpIlRSaSxqb84pSbG/TVm7Y+///XTQ+RygcY4PhK8z5CzmoTSEJJlJvZuDMtWCrnTN7lZGVnlI5Y6Q7DnQMN/grO124WfBSEgzvTMyYTejQJdyEb7K0JCPkJXFBzlKe6pJOd89/hRfHbkixxPgFQjbIBPuA7ipI8ImqGueCZJRoZWRa5yP8F0G4eORNeQjZGn4ZGQN+QjfZGzpzZFvzC0gvAbeoiA7fg0AAA==";
    private static final Log log = LogFactory.getLog(SensitivityChooserUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addExportButton;
    protected JList<String> availableSensitivityExports;
    protected JButton clearExportsButton;
    protected JTable exportParamsTable;
    protected JTable factorCardinality;
    protected JPanel factorCardinalityPanel;
    protected JScrollPane factorCardinalityScrollPane;
    protected JComboBox<String> fieldSensitivityAnalysisSelect;
    protected SensitivityChooserHandler handler;
    protected JButton removeExportButton;
    protected JList<SensitivityExport> selectedSensitivityExports;
    protected JTable simulSensitivityAnalysisParam;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private JScrollPane $JScrollPane2;
    private JScrollPane $JScrollPane3;
    private SensitivityChooserUI $Table0 = this;
    private Table $Table1;
    private Table $Table2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
            handler.afterInit();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SensitivityChooserUI() {
        $initialize();
    }

    public SensitivityChooserUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addExportButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addExports();
    }

    public void doActionPerformed__on__clearExportsButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.clearExports();
    }

    public void doActionPerformed__on__fieldSensitivityAnalysisSelect(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.sensitivityAnalysisChanged();
    }

    public void doActionPerformed__on__removeExportButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.removeExports();
    }

    public void doValueChanged__on__availableSensitivityExports(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.availableSensitivityExportSelection();
    }

    public void doValueChanged__on__selectedSensitivityExports(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.selectedSensitivityExportSelection();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddExportButton() {
        return addExportButton;
    }

    public JList<String> getAvailableSensitivityExports() {
        return availableSensitivityExports;
    }

    public JButton getClearExportsButton() {
        return clearExportsButton;
    }

    public JTable getExportParamsTable() {
        return exportParamsTable;
    }

    public JTable getFactorCardinality() {
        return factorCardinality;
    }

    public JPanel getFactorCardinalityPanel() {
        return factorCardinalityPanel;
    }

    public JScrollPane getFactorCardinalityScrollPane() {
        return factorCardinalityScrollPane;
    }

    public JComboBox<String> getFieldSensitivityAnalysisSelect() {
        return fieldSensitivityAnalysisSelect;
    }

    public SensitivityChooserHandler getHandler() {
        return handler;
    }

    public JButton getRemoveExportButton() {
        return removeExportButton;
    }

    public JList<SensitivityExport> getSelectedSensitivityExports() {
        return selectedSensitivityExports;
    }

    public JTable getSimulSensitivityAnalysisParam() {
        return simulSensitivityAnalysisParam;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected JScrollPane get$JScrollPane2() {
        return $JScrollPane2;
    }

    protected JScrollPane get$JScrollPane3() {
        return $JScrollPane3;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToFactorCardinalityPanel() {
        if (!allComponentsCreated) {
            return;
        }
        factorCardinalityPanel.add($JLabel1, "factorCardinalitySupported");
        factorCardinalityPanel.add(factorCardinalityScrollPane, "factorCardinalityNotSupported");
    }

    protected void addChildrenToFactorCardinalityScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        factorCardinalityScrollPane.getViewport().add(factorCardinality);
    }

    protected void createAddExportButton() {
        $objectMap.put("addExportButton", addExportButton = new JButton());
        
        addExportButton.setName("addExportButton");
        addExportButton.setEnabled(false);
        addExportButton.setText(t("isisfish.common.add"));
        addExportButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addExportButton"));
    }

    protected void createAvailableSensitivityExports() {
        $objectMap.put("availableSensitivityExports", availableSensitivityExports = new JList<String>());
        
        availableSensitivityExports.setName("availableSensitivityExports");
        availableSensitivityExports.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__availableSensitivityExports"));
    }

    protected void createClearExportsButton() {
        $objectMap.put("clearExportsButton", clearExportsButton = new JButton());
        
        clearExportsButton.setName("clearExportsButton");
        clearExportsButton.setEnabled(false);
        clearExportsButton.setText(t("isisfish.common.clear"));
        clearExportsButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__clearExportsButton"));
    }

    protected void createExportParamsTable() {
        $objectMap.put("exportParamsTable", exportParamsTable = new JTable());
        
        exportParamsTable.setName("exportParamsTable");
        exportParamsTable.setRowHeight(24);
    }

    protected void createFactorCardinality() {
        $objectMap.put("factorCardinality", factorCardinality = new JTable());
        
        factorCardinality.setName("factorCardinality");
        factorCardinality.setRowHeight(24);
    }

    protected void createFactorCardinalityPanel() {
        $objectMap.put("factorCardinalityPanel", factorCardinalityPanel = new JPanel());
        
        factorCardinalityPanel.setName("factorCardinalityPanel");
        factorCardinalityPanel.setLayout(new java.awt.CardLayout());
    }

    protected void createFactorCardinalityScrollPane() {
        $objectMap.put("factorCardinalityScrollPane", factorCardinalityScrollPane = new JScrollPane());
        
        factorCardinalityScrollPane.setName("factorCardinalityScrollPane");
    }

    protected void createFieldSensitivityAnalysisSelect() {
        $objectMap.put("fieldSensitivityAnalysisSelect", fieldSensitivityAnalysisSelect = new JComboBox<String>());
        
        fieldSensitivityAnalysisSelect.setName("fieldSensitivityAnalysisSelect");
        fieldSensitivityAnalysisSelect.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fieldSensitivityAnalysisSelect"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new SensitivityChooserHandler(this));
    }

    protected void createRemoveExportButton() {
        $objectMap.put("removeExportButton", removeExportButton = new JButton());
        
        removeExportButton.setName("removeExportButton");
        removeExportButton.setEnabled(false);
        removeExportButton.setText(t("isisfish.common.remove"));
        removeExportButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeExportButton"));
    }

    protected void createSelectedSensitivityExports() {
        $objectMap.put("selectedSensitivityExports", selectedSensitivityExports = new JList<SensitivityExport>());
        
        selectedSensitivityExports.setName("selectedSensitivityExports");
        selectedSensitivityExports.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__selectedSensitivityExports"));
    }

    protected void createSimulSensitivityAnalysisParam() {
        $objectMap.put("simulSensitivityAnalysisParam", simulSensitivityAnalysisParam = new JTable());
        
        simulSensitivityAnalysisParam.setName("simulSensitivityAnalysisParam");
        simulSensitivityAnalysisParam.setRowHeight(24);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(fieldSensitivityAnalysisSelect, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(factorCardinalityPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($JLabel2, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($Table1, new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane3, new GridBagConstraints(0, 5, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(simulSensitivityAnalysisParam);
        addChildrenToFactorCardinalityPanel();
        addChildrenToFactorCardinalityScrollPane();
        // inline complete setup of $Table1
        $Table1.add($JScrollPane1, new GridBagConstraints(0, 0, 1, 1, 0.5, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($Table2, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane2, new GridBagConstraints(2, 0, 1, 1, 0.5, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(availableSensitivityExports);
        // inline complete setup of $Table2
        $Table2.add(addExportButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(removeExportButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(clearExportsButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane2
        $JScrollPane2.getViewport().add(selectedSensitivityExports);
        // inline complete setup of $JScrollPane3
        $JScrollPane3.getViewport().add(exportParamsTable);
        
        // apply 9 property setters
        fieldSensitivityAnalysisSelect.setModel(handler.getSensitivityAnalysisModel());
        fieldSensitivityAnalysisSelect.setRenderer(new fr.ifremer.isisfish.ui.models.sensitivityanalysis.SensitivityAnalysisComboRenderer());
        $JLabel1.setBorder(BorderFactory.createEtchedBorder());
        factorCardinality.setModel(new fr.ifremer.isisfish.ui.sensitivity.model.FactorCardinalityTableModel());
        availableSensitivityExports.setCellRenderer(new fr.ifremer.isisfish.ui.models.sensitivityexport.SensitivityExportNameListRenderer());
        availableSensitivityExports.setModel(handler.getAvailableExportListModel());
        availableSensitivityExports.setSelectionMode(javax.swing.ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        selectedSensitivityExports.setSelectionMode(javax.swing.ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createHandler();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("isisfish.sensitivity.select"));
        createFieldSensitivityAnalysisSelect();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createSimulSensitivityAnalysisParam();
        createFactorCardinalityPanel();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        if ($JLabel1.getFont() != null) {
            $JLabel1.setFont($JLabel1.getFont().deriveFont($JLabel1.getFont().getStyle() | Font.ITALIC));
        }
        $JLabel1.setHorizontalAlignment(0);
        $JLabel1.setText(t("isisfish.sensitivity.methodfactorsupported"));
        createFactorCardinalityScrollPane();
        createFactorCardinality();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t("isisfish.sensitivity.export"));
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createAvailableSensitivityExports();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        createAddExportButton();
        createRemoveExportButton();
        createClearExportsButton();
        // inline creation of $JScrollPane2
        $objectMap.put("$JScrollPane2", $JScrollPane2 = new JScrollPane());
        
        $JScrollPane2.setName("$JScrollPane2");
        createSelectedSensitivityExports();
        // inline creation of $JScrollPane3
        $objectMap.put("$JScrollPane3", $JScrollPane3 = new JScrollPane());
        
        $JScrollPane3.setName("$JScrollPane3");
        createExportParamsTable();
        // inline creation of $Table0
        setName("$Table0");
        
        $completeSetup();
    }

}