package fr.ifremer.isisfish.ui.input.zone;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.bbn.openmap.InformationDelegator;
import fr.ifremer.isisfish.entities.Cell;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.map.IsisMapBean;
import fr.ifremer.isisfish.ui.input.InputContentUI;
import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class ZoneBasicsUI extends InputContentUI<Zone> implements JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_ZONE_MAP = "zoneMap";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CANCEL_ENABLED = "cancel.enabled";
    public static final String BINDING_CREATE_ENABLED = "create.enabled";
    public static final String BINDING_DELETE_ENABLED = "delete.enabled";
    public static final String BINDING_FIELD_ZONE_COMMENT_ENABLED = "fieldZoneComment.enabled";
    public static final String BINDING_FIELD_ZONE_COMMENT_TEXT = "fieldZoneComment.text";
    public static final String BINDING_FIELD_ZONE_NAME_ENABLED = "fieldZoneName.enabled";
    public static final String BINDING_FIELD_ZONE_NAME_TEXT = "fieldZoneName.text";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";
    public static final String BINDING_ZONE_CELLS_ENABLED = "zoneCells.enabled";
    public static final String BINDING_ZONE_MAP_FISHERY_REGION = "zoneMap.fisheryRegion";
    public static final String BINDING_ZONE_MAP_SELECTED_CELLS = "zoneMap.selectedCells";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL1_ENABLED = "$JLabel1.enabled";
    private static final String BINDING_$JLABEL2_ENABLED = "$JLabel2.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1WTW/cRBiebJNst2kgNEqa0iLSdkEIhDflQwgl9CMpUTfaQOmmqOpeGNuzu1PNzpiZcer0gPgJ/AS4c0Hixglx4MyBC+IvIMSBK+Kd8a4dJ45jZPZge+d9n2ee9/XMM/72DzSjJLr6BEeRI0Ou6Yg4O3cePfrYfUI8fZcoT9JAC4ni31QN1Xpozk/GlUbXex0Db43hrS0xCgQn/BB6vYPOKX3AiBoSojV6KYvwlGp1k/B6FIRywpqIymP9+q8/a1/5X35TQygKQN0ylLJ6GiqtZLqDatTX6ALMtI9bDPMByJCUD0DvvBnbYlipj/CIfI6+QPUOmg2wBDKNrpUv2XJYfBRotNBs8yDUW4JrSH/YXtPI6UuH9iUZEbgrqvpUDZ2QOtQkOs+A13kMl02sqKcetoPAss1qNO0SzDW6mocHcqopURaaQupDzH1GpEZv/5dZ78WolKexjxn1MdSp0RuZjicBRz2FTjpdc/10MnhYvPAPoPemzdE4d+c+5oSlOeebO92AUW2GoVHLmdwkYpKX0gqbe9hlJn0loytG2ZjJXEkAZ5s7HewStnZUjB01SZeT3Pk+Jcw3fTGL4qiiPRLpbZOQBU0muGH+r2ZjcyowbFuEMdhJF7MFelIwNqkwxTSepYgXsoqp0ibp1WNzv5Uz93zz0BRrZvC1bMJCUi2s75Fd90vHCr4jCTb5TvpmFd6H3ixmUjdDrQXP8s96mHtxi989GgFWTfIiPmEkN3JmhAPzeDH7euumW7sYtt71vBUPIKcNfyBjE3aTAW2kb2eMbfO+0KjpiZHjutwRAeEWB8NyhDUV/C6oGpgFPiaQ6HJm9YHDOanDpRY01UMzMoRhWK6946b4AEKxHa4csUNDaKP/LC/++sPv329PPPBFmHspN/WQhYM3BRLKkMYiNHo+NsBQU9aCctd7qKGgIC/29ys5wrrjMIiD+ewqdAzcuYfVEChm6r/9+NPyZ7+cQbVtdI4J7G9jk99GDT2U0AXB/Ci4ddsqOv/0LFwXjDbQ4tN96hPZEZ7tLOzKDcoZ5WQVazBnN9TkZgQduZLTkUSW2/j578Xud7cnXZkClZdOTE87M/MYzcaz2bNhbPu5Z8FcoEjoi9Te8wx/ytwvBWNLa9vrbl7ZF2Cl7YnQG34YBWC2E5u6H4Xm9oktwTx1SzPOCUlhz9omVqSqE24EwVH53AbYOF51KfdhW9/Mp3y5BOW0Bu8okHU6hxm2zuPmM1wrxTCozFCk4ZXyGk7oQzmGIg2vV2Z4s3IV5RiKNNyo/DbLMRRpeKdyH8oxFGl4r7KGcgxFGt6vrKEcQ5GG9coaTmeArw2GD0SoC3R8UIJl3nxpEHnwgAzGXnwC2a0yZPHJTHz7Bfj/kIGqXeGTU8j+BUn1yZ4sDgAA";
    private static final Log log = LogFactory.getLog(ZoneBasicsUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Zone bean;
    protected JButton cancel;
    protected JButton create;
    protected JButton delete;
    protected JTextArea fieldZoneComment;
    @ValidatorField( validatorId = "validator",  propertyName = "name",  editorName = "fieldZoneName")
    protected JTextField fieldZoneName;
    protected ZoneBasicsHandler handler;
    protected JPanel map;
    protected JButton save;
    @ValidatorField( validatorId = "validator",  propertyName = "cell",  editorName = "spZoneCells")
    protected JScrollPane spZoneCells;
    @Validator( validatorId = "validator")
    protected SwingValidator<Zone> validator;
    protected List<String> validatorIds = new ArrayList<String>();
    protected JList<Cell> zoneCells;
    protected IsisMapBean zoneMap;
    protected InformationDelegator zoneMapInfo;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ZoneBasicsUI $InputContentUI0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JScrollPane $JScrollPane0;
    private JSplitPane $JSplitPane0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
            handler.afterInit();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ZoneBasicsUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ZoneBasicsUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ZoneBasicsUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public ZoneBasicsUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ZoneBasicsUI() {
        $initialize();
    }

    public ZoneBasicsUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public ZoneBasicsUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public ZoneBasicsUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().cancel();
    }

    public void doActionPerformed__on__create(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().create(Zone.class);
    }

    public void doActionPerformed__on__delete(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().delete();
    }

    public void doActionPerformed__on__save(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().save();validator.setChanged(false);
    }

    public void doKeyReleased__on__fieldZoneComment(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setComment(fieldZoneComment.getText());
    }

    public void doKeyReleased__on__fieldZoneName(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setName(fieldZoneName.getText());
    }

    public void doValueChanged__on__zoneCells(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.zoneCellsChange(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Zone getBean() {
        return bean;
    }

    public JButton getCancel() {
        return cancel;
    }

    public JButton getCreate() {
        return create;
    }

    public JButton getDelete() {
        return delete;
    }

    public JTextArea getFieldZoneComment() {
        return fieldZoneComment;
    }

    public JTextField getFieldZoneName() {
        return fieldZoneName;
    }

    public ZoneBasicsHandler getHandler() {
        return handler;
    }

    public JPanel getMap() {
        return map;
    }

    public JButton getSave() {
        return save;
    }

    public JScrollPane getSpZoneCells() {
        return spZoneCells;
    }

    public SwingValidator<Zone> getValidator() {
        return validator;
    }

    public JList<Cell> getZoneCells() {
        return zoneCells;
    }

    public IsisMapBean getZoneMap() {
        return zoneMap;
    }

    public InformationDelegator getZoneMapInfo() {
        return zoneMapInfo;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Zone bean) {
        Zone oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setZoneMap(IsisMapBean zoneMap) {
        IsisMapBean oldValue = this.zoneMap;
        this.zoneMap = zoneMap;
        firePropertyChange(PROPERTY_ZONE_MAP, oldValue, zoneMap);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JSplitPane get$JSplitPane0() {
        return $JSplitPane0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($JSplitPane0);
    }

    protected void addChildrenToMap() {
        if (!allComponentsCreated) {
            return;
        }
        map.add(SwingUtil.boxComponentWithJxLayer(zoneMap), BorderLayout.CENTER);
        map.add(zoneMapInfo, BorderLayout.SOUTH);
    }

    protected void addChildrenToSpZoneCells() {
        if (!allComponentsCreated) {
            return;
        }
        spZoneCells.getViewport().add(SwingUtil.boxComponentWithJxLayer(zoneCells));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("isisfish.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createCreate() {
        $objectMap.put("create", create = new JButton());
        
        create.setName("create");
        create.setText(t("isisfish.common.new"));
        create.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__create"));
    }

    protected void createDelete() {
        $objectMap.put("delete", delete = new JButton());
        
        delete.setName("delete");
        delete.setText(t("isisfish.common.remove"));
        delete.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__delete"));
    }

    protected void createFieldZoneComment() {
        $objectMap.put("fieldZoneComment", fieldZoneComment = new JTextArea());
        
        fieldZoneComment.setName("fieldZoneComment");
        fieldZoneComment.setColumns(15);
        fieldZoneComment.setLineWrap(true);
        fieldZoneComment.setWrapStyleWord(true);
        fieldZoneComment.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldZoneComment"));
    }

    protected void createFieldZoneName() {
        $objectMap.put("fieldZoneName", fieldZoneName = new JTextField());
        
        fieldZoneName.setName("fieldZoneName");
        fieldZoneName.setColumns(15);
        fieldZoneName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldZoneName"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new ZoneBasicsHandler(this));
    }

    protected void createMap() {
        $objectMap.put("map", map = new JPanel());
        
        map.setName("map");
        map.setLayout(new BorderLayout());
    }

    protected void createSave() {
        $objectMap.put("save", save = new JButton());
        
        save.setName("save");
        save.setText(t("isisfish.common.save"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createSpZoneCells() {
        $objectMap.put("spZoneCells", spZoneCells = new JScrollPane());
        
        spZoneCells.setName("spZoneCells");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(Zone.class, null));
    }

    protected void createZoneCells() {
        $objectMap.put("zoneCells", zoneCells = new JList<Cell>());
        
        zoneCells.setName("zoneCells");
        zoneCells.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__zoneCells"));
    }

    protected void createZoneMap() {
        $objectMap.put("zoneMap", zoneMap = new fr.ifremer.isisfish.map.IsisMapBean());
        
        zoneMap.setName("zoneMap");
    }

    protected void createZoneMapInfo() {
        $objectMap.put("zoneMapInfo", zoneMapInfo = new InformationDelegator());
        
        zoneMapInfo.setName("zoneMapInfo");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToValidator();
        addChildrenToBody();
        // inline complete setup of $JSplitPane0
        $JSplitPane0.add($Table0, JSplitPane.LEFT);
        $JSplitPane0.add(map, JSplitPane.RIGHT);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(SwingUtil.boxComponentWithJxLayer(fieldZoneName)), new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(spZoneCells), new GridBagConstraints(0, 3, 2, 1, 1.0, 0.7, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel2, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 6, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 6, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(create), new GridBagConstraints(0, 7, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(delete), new GridBagConstraints(1, 7, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToSpZoneCells();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(SwingUtil.boxComponentWithJxLayer(fieldZoneComment));
        addChildrenToMap();
        
        // apply 15 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 2 property setters
        zoneMap.setSelectionMode(fr.ifremer.isisfish.map.CellSelectionLayer.MULT_SELECTION);
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createHandler();
        createValidator();
        // inline creation of $JSplitPane0
        $objectMap.put("$JSplitPane0", $JSplitPane0 = new JSplitPane());
        
        $JSplitPane0.setName("$JSplitPane0");
        $JSplitPane0.setDividerLocation(200);
        $JSplitPane0.setOneTouchExpandable(true);
        $JSplitPane0.setOrientation(1);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("isisfish.zone.name"));
        createFieldZoneName();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("isisfish.zone.cells"));
        createSpZoneCells();
        createZoneCells();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t("isisfish.zone.comments"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFieldZoneComment();
        createSave();
        createCancel();
        createCreate();
        createDelete();
        createMap();
        createZoneMap();
        createZoneMapInfo();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 15 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 15 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_ZONE_NAME_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldZoneName.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_ZONE_NAME_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldZoneName, jaxx.runtime.SwingUtil.getStringValue(getBean().getName()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL1_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel1.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ZONE_CELLS_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                zoneCells.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL2_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel2.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_ZONE_COMMENT_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldZoneComment.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_ZONE_COMMENT_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldZoneComment, jaxx.runtime.SwingUtil.getStringValue(getBean().getComment()));
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("valid", this);
                }
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    save.setEnabled(validator.isValid() && validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("valid", this);
                }
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CANCEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    cancel.setEnabled(validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CREATE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    create.setEnabled(!validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DELETE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
                addPropertyChangeListener("bean", this);
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    delete.setEnabled(!validator.isChanged() && getBean() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
                removePropertyChangeListener("bean", this);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ZONE_MAP_FISHERY_REGION, true ,"fisheryRegion") {
        
            @Override
            public void processDataBinding() {
                zoneMap.setFisheryRegion(getFisheryRegion());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ZONE_MAP_SELECTED_CELLS, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("bean", this);
                if (bean != null) {
                    bean.addPropertyChangeListener("cell", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    zoneMap.setSelectedCells(getBean()==null?null:bean.getCell());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("bean", this);
                if (bean != null) {
                    bean.removePropertyChangeListener("cell", this);
                }
            }
        });
    }

}