package fr.ifremer.isisfish.ui.input.setofvessels;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.SetOfVessels;
import fr.ifremer.isisfish.ui.input.InputContentUI;
import java.awt.LayoutManager;
import javax.swing.JTabbedPane;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class SetOfVesselsUI extends InputContentUI<fr.ifremer.isisfish.entities.SetOfVessels> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EFFORT_DESCRIPTION_UI_ACTIVE = "effortDescriptionUI.active";
    public static final String BINDING_EFFORT_DESCRIPTION_UI_BEAN = "effortDescriptionUI.bean";
    public static final String BINDING_EFFORT_DESCRIPTION_UI_SENSITIVITY = "effortDescriptionUI.sensitivity";
    public static final String BINDING_EFFORT_PARAMETERS_UI_ACTIVE = "effortParametersUI.active";
    public static final String BINDING_EFFORT_PARAMETERS_UI_BEAN = "effortParametersUI.bean";
    public static final String BINDING_EFFORT_PARAMETERS_UI_SENSITIVITY = "effortParametersUI.sensitivity";
    public static final String BINDING_SET_OF_VESSELS_BASICS_UI_ACTIVE = "setOfVesselsBasicsUI.active";
    public static final String BINDING_SET_OF_VESSELS_BASICS_UI_BEAN = "setOfVesselsBasicsUI.bean";
    public static final String BINDING_SET_OF_VESSELS_BASICS_UI_SENSITIVITY = "setOfVesselsBasicsUI.sensitivity";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUTVMTQRDtRAKGqCAIgmKJwsWDG/GjtCqKKIqGikIZsShzcZKdJUNtZseZ2bBcLH+CP0HvXqzy5sny4NmDF8u/YFkevFr2bL5lxUhy2E2m+71+/TLdr79BQkk4tUmCwJI+16xCreUb6+srxU1a0reoKkkmtCeh9onFIV6AlN08VxpmCjkDT9fh6UWvIjxOeRs6k4NBpbddqsqUag0nOhElpdL5ZjgTCF82WJuiolhf/vgef2E/fxUHCASqS2Er0/9CtTrpy0Gc2RpGsFKVpF3CN1CGZHwD9R40Z4suUeo+qdCn8AwGctAviEQyDae7bznkCPGB0DA8m+XC14se15i+lj2n4YojLeZIWqH4Vkw5TJUtn1nMJFqKas+pUqWoq6w81SvOo9qPtawQIW+/hr4iJVzDmSgmLMM0o53gFnSgTLjtUqnh2t503K3h28V49ja6agwMLLWFflrLq4RTt5UzpNoYHpKihqMd6XhUpLYBGcBIE3ekHXeTKFZCHzTM7016g8CQjzVrjFLH8WTzr2QeNyX+w53bO/GdFUZqFVaJxKulqQx7uNNDgXamzlLJWbQyyx0PL9qxjtGoOV2Pip2AOXMwExE43whION7BiGNstca4NWexAiSkj8caJgo7J/8BhmozP/HHzBvCMPprfPTzu69vlxqDnsTaY5GpbXsKB1BIT+DVZqb0UG3Kfc3c9D0iMgVkoS4uuXCJTUUIy9fDKA7rHTZwy8Ctu0SVkSIx8OX9h/Enn/ZBfAkGXY/YS8TkZyGpyxJd8Fw7ENcXQkUHtvbjc9ho09CPeayKHh26ahNNpouM2/hvzAdowlSECU0lxeTHn6P5NwsNI2IobPKv6S0zEo+hn3GXcRruvPo6i9xxKaGob3uttRW1yGLmPSnqt+Ns+JyL6jTcTCZ6MfDN61Io2ny73DVHSlGucIdVmd7uicocX9iFYaorhkzPDAs9M+zWxcmeu+iOYbcuDMNvMpG+h1wIAAA=";
    private static final Log log = LogFactory.getLog(SetOfVesselsUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected SetOfVessels bean;
    protected EffortDescriptionUI effortDescriptionUI;
    protected EffortDescriptionParametersUI effortParametersUI;
    protected SetOfVesselsHandler handler;
    protected SetOfVesselsBasicsUI setOfVesselsBasicsUI;
    protected JTabbedPane setOfVesselsTab;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private SetOfVesselsUI $InputContentUI0 = this;
    private TabInfo $TabInfo0;
    private TabInfo $TabInfo1;
    private TabInfo $TabInfo2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
            handler.afterInit();
        }
    
        @Override
        public void setLayer(boolean active) {
            super.setLayer(active);
            setOfVesselsBasicsUI.setLayer(active);
            effortDescriptionUI.setLayer(active);
            effortParametersUI.setLayer(active);
        }
        
        @Override
        public void resetChangeModel() {
            setOfVesselsBasicsUI.resetChangeModel();
            effortDescriptionUI.resetChangeModel();
            effortParametersUI.resetChangeModel();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SetOfVesselsUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SetOfVesselsUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public SetOfVesselsUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SetOfVesselsUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SetOfVesselsUI() {
        $initialize();
    }

    public SetOfVesselsUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public SetOfVesselsUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SetOfVesselsUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public SetOfVessels getBean() {
        return bean;
    }

    public EffortDescriptionUI getEffortDescriptionUI() {
        return effortDescriptionUI;
    }

    public EffortDescriptionParametersUI getEffortParametersUI() {
        return effortParametersUI;
    }

    public SetOfVesselsHandler getHandler() {
        return handler;
    }

    public SetOfVesselsBasicsUI getSetOfVesselsBasicsUI() {
        return setOfVesselsBasicsUI;
    }

    public JTabbedPane getSetOfVesselsTab() {
        return setOfVesselsTab;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(SetOfVessels bean) {
        SetOfVessels oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    protected TabInfo get$TabInfo2() {
        return $TabInfo2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(setOfVesselsTab);
    }

    protected void addChildrenToSetOfVesselsTab() {
        if (!allComponentsCreated) {
            return;
        }
        setOfVesselsTab.add(setOfVesselsBasicsUI);
        setOfVesselsTab.add(effortDescriptionUI);
        setOfVesselsTab.add(effortParametersUI);
        $TabInfo0.addPropertyChangeListener(new TabInfoPropertyChangeListener(setOfVesselsTab, 0));
        setOfVesselsTab.setTitleAt(0, t("isisfish.setOfVessels.title"));
        $TabInfo1.addPropertyChangeListener(new TabInfoPropertyChangeListener(setOfVesselsTab, 1));
        setOfVesselsTab.setTitleAt(1, t("isisfish.effortDescription.title"));
        $TabInfo2.addPropertyChangeListener(new TabInfoPropertyChangeListener(setOfVesselsTab, 2));
        setOfVesselsTab.setTitleAt(2, t("isisfish.effortDescription.parametersTitle"));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createEffortDescriptionUI() {
        $objectMap.put("effortDescriptionUI", effortDescriptionUI = new EffortDescriptionUI(this));
        
        effortDescriptionUI.setName("effortDescriptionUI");
    }

    protected void createEffortParametersUI() {
        $objectMap.put("effortParametersUI", effortParametersUI = new EffortDescriptionParametersUI(this));
        
        effortParametersUI.setName("effortParametersUI");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new SetOfVesselsHandler(this));
    }

    protected void createSetOfVesselsBasicsUI() {
        $objectMap.put("setOfVesselsBasicsUI", setOfVesselsBasicsUI = new SetOfVesselsBasicsUI(this));
        
        setOfVesselsBasicsUI.setName("setOfVesselsBasicsUI");
    }

    protected void createSetOfVesselsTab() {
        $objectMap.put("setOfVesselsTab", setOfVesselsTab = new JTabbedPane());
        
        setOfVesselsTab.setName("setOfVesselsTab");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToBody();
        addChildrenToSetOfVesselsTab();
        
        // apply 9 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createHandler();
        createSetOfVesselsTab();
        createSetOfVesselsBasicsUI();
        createEffortDescriptionUI();
        createEffortParametersUI();
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new TabInfo());
        
        $TabInfo0.setTitle(t("isisfish.setOfVessels.title"));
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new TabInfo());
        
        $TabInfo1.setTitle(t("isisfish.effortDescription.title"));
        // inline creation of $TabInfo2
        $objectMap.put("$TabInfo2", $TabInfo2 = new TabInfo());
        
        $TabInfo2.setTitle(t("isisfish.effortDescription.parametersTitle"));
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 9 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 9 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SET_OF_VESSELS_BASICS_UI_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                setOfVesselsBasicsUI.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SET_OF_VESSELS_BASICS_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                setOfVesselsBasicsUI.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SET_OF_VESSELS_BASICS_UI_SENSITIVITY, true ,"sensitivity") {
        
            @Override
            public void processDataBinding() {
                setOfVesselsBasicsUI.setSensitivity(isSensitivity());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EFFORT_DESCRIPTION_UI_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                effortDescriptionUI.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EFFORT_DESCRIPTION_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                effortDescriptionUI.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EFFORT_DESCRIPTION_UI_SENSITIVITY, true ,"sensitivity") {
        
            @Override
            public void processDataBinding() {
                effortDescriptionUI.setSensitivity(isSensitivity());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EFFORT_PARAMETERS_UI_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                effortParametersUI.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EFFORT_PARAMETERS_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                effortParametersUI.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EFFORT_PARAMETERS_UI_SENSITIVITY, true ,"sensitivity") {
        
            @Override
            public void processDataBinding() {
                effortParametersUI.setSensitivity(isSensitivity());
            }
        });
    }

}