package fr.ifremer.isisfish.ui.input.population;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.ui.input.InputContentUI;
import fr.ifremer.isisfish.ui.input.equation.InputOneEquationUI;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.gui.MatrixPanelEditor;
import org.nuiton.math.matrix.gui.MatrixPanelEvent;
import org.nuiton.math.matrix.gui.MatrixPanelListener;
import static org.nuiton.i18n.I18n.t;

public class PopulationCapturabilityUI extends InputContentUI<Population> implements JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CANCEL_ENABLED = "cancel.enabled";
    public static final String BINDING_CAPTURABILITY_EQUATION_ACTIVE = "capturabilityEquation.active";
    public static final String BINDING_CAPTURABILITY_EQUATION_BEAN = "capturabilityEquation.bean";
    public static final String BINDING_FIELD_POPULATION_CAPTURABILITY_COMMENT_ENABLED = "fieldPopulationCapturabilityComment.enabled";
    public static final String BINDING_FIELD_POPULATION_CAPTURABILITY_COMMENT_TEXT = "fieldPopulationCapturabilityComment.text";
    public static final String BINDING_FIELD_POPULATION_CAPTURABILITY_ENABLED = "fieldPopulationCapturability.enabled";
    public static final String BINDING_FIELD_POPULATION_CAPTURABILITY_MATRIX = "fieldPopulationCapturability.matrix";
    public static final String BINDING_FIELD_USE_CAPTURABILITY_EQUATION_ENABLED = "fieldUseCapturabilityEquation.enabled";
    public static final String BINDING_FIELD_USE_CAPTURABILITY_EQUATION_SELECTED = "fieldUseCapturabilityEquation.selected";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL1_ENABLED = "$JLabel1.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVQW8bRRSemNhJ2pQWoqRBTUTaWqpE0bqAkJBS0SZuotpyaYQbVOEL492xPWU8O52ZTdc9IH4CPwHuXJB644R64MyBC+pfqBAHrlXfzNq73rLdrlgf1uuZ9773vW/efP75OaoqiS4+wGHoyIBrOiZOe+/+/bv9B8TVt4hyJRXalyj6LFRQpYdOe/G60uhyr2PSG9P0RtMfC58TPpe920GnlJ4wokaEaI220xmuUo1uvL0bikDOUGNSWag//vN35Qfv+58qCIUC2J2DVnbelJV0sthBFepp9C5UOsENhvkQaEjKh8D3jFlrMqzUF3hMHqLv0FIH1QSWAKbRpeItWwybHwqNztVbXAS66XMN4cetaxrtDaRDB5KMCXwrqgZUjZyAOtQEOsIXAcOa+tw5il+bWOhA4j5lVE+OW0LYAjWNFvsEc42uZEFCPaopUXM4SeLSCHOPEanRYUk6tyOgBHrlBDPqYdBEo6up04k3HPUIVHe65vnVbHG+K9+bwDmZIwmnse0jzAmba6B+D/cZAT03UzWiaLtnItfjhOV6u4P7hF17FdiumqDNOHZ7QAnzjhVJdXrwMLDta7SeAmiOiPvtvh+mMVZH0BawsLzN2vn0/pat8RpRNfrQl0OHB1SD8mOsR+YhaegM4Wju2FcLfOBBhDSQF2PkdTeb9We5J02mcY4d2LuczBKPW2n4mZAfmd/b6abO1NtdV/qMGXKg9PmUUMlWOutynhRw18b2DqZFv0dCvScJNhBXk8lR+IRotJYK3Q80qJguWXMxd6Nz+WS6I9GF1CSBSzmJSyU2stBDVRnAMoxe77/G9iVsRZa2+YqlGUC7+2Jj7c9fnz05nPnYBtRezwyds2HwFyF9AVeWmtJnIxMLNGWNO1js9tCKIgw83Hr0Vgax7nQbyEG9d0y6Y9Kd21iNAKK69NdvTze++eMtVDlEp5iPvUNs4ltoRY8kqOAzLxQ3blpGq4+WjQEbbnAXCTeTDtb69nW4yninT7kH0n8eggpbGSrEVPorv/+71v3l5kyJBWD23mvDEzWqX6Ma5YxyYj19ateZHn5aKBJ4fmLLWUa9YL63xNRedu3zRlarixrmDhzkelR9B2u4iv1AE+jVJDVtE+btoCCmWd4zj/1shPcLsFqOjp54pXDMsr3r7f/PpMbwxA90Do9LpRWpF+ER2WVZFLgA9ITkoFwpMjPmT7okxqrBOIru/yTnjIpgVV2GHz8uSejswJdjcKgm1mToy3Kc3jR5xRDyZuaD0hyKIeRxaBTnUAohj8PHpXUohpDH4dPSHAzCS1Oq/13LDAAA";
    private static final Log log = LogFactory.getLog(PopulationCapturabilityUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Population bean;
    protected JButton cancel;
    protected InputOneEquationUI capturabilityEquation;
    protected MatrixPanelEditor fieldPopulationCapturability;
    protected JTextArea fieldPopulationCapturabilityComment;
    protected JCheckBox fieldUseCapturabilityEquation;
    protected PopulationCapturabilityHandler handler;
    protected JPanel hidablePanel;
    protected JButton save;
    @Validator( validatorId = "validator")
    protected SwingValidator<Population> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private PopulationCapturabilityUI $InputContentUI0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JScrollPane $JScrollPane0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
            handler.afterInit();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public PopulationCapturabilityUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationCapturabilityUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public PopulationCapturabilityUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public PopulationCapturabilityUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationCapturabilityUI() {
        $initialize();
    }

    public PopulationCapturabilityUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public PopulationCapturabilityUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public PopulationCapturabilityUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().cancel();
    }

    public void doActionPerformed__on__fieldUseCapturabilityEquation(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.useEquationChanged();
    }

    public void doActionPerformed__on__save(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().save();validator.setChanged(false);
    }

    public void doKeyReleased__on__fieldPopulationCapturabilityComment(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setCapturabilityComment(fieldPopulationCapturabilityComment.getText());
    }

    public void doMatrixChanged__on__fieldPopulationCapturability(MatrixPanelEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.populationCapturabilityMatrixChanged(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Population getBean() {
        return bean;
    }

    public JButton getCancel() {
        return cancel;
    }

    public InputOneEquationUI getCapturabilityEquation() {
        return capturabilityEquation;
    }

    public MatrixPanelEditor getFieldPopulationCapturability() {
        return fieldPopulationCapturability;
    }

    public JTextArea getFieldPopulationCapturabilityComment() {
        return fieldPopulationCapturabilityComment;
    }

    public JCheckBox getFieldUseCapturabilityEquation() {
        return fieldUseCapturabilityEquation;
    }

    public PopulationCapturabilityHandler getHandler() {
        return handler;
    }

    public JPanel getHidablePanel() {
        return hidablePanel;
    }

    public JButton getSave() {
        return save;
    }

    public SwingValidator<Population> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Population bean) {
        Population oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0);
    }

    protected void addChildrenToHidablePanel() {
        if (!allComponentsCreated) {
            return;
        }
        hidablePanel.add(SwingUtil.boxComponentWithJxLayer(fieldPopulationCapturability), "fieldUseMatrix");
        hidablePanel.add(SwingUtil.boxComponentWithJxLayer(capturabilityEquation), "fieldUseEquation");
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("isisfish.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createCapturabilityEquation() {
        $objectMap.put("capturabilityEquation", capturabilityEquation = new InputOneEquationUI(this));
        
        capturabilityEquation.setName("capturabilityEquation");
        capturabilityEquation.setBeanProperty("CapturabilityEquation");
        capturabilityEquation.setFormuleCategory("Capturability");
        capturabilityEquation.setText(t("isisfish.common.capturability"));
        capturabilityEquation.putClientProperty("sensitivityBean", Population.class);
        capturabilityEquation.putClientProperty("sensitivityMethod", "CapturabilityEquation");
    }

    protected void createFieldPopulationCapturability() {
        $objectMap.put("fieldPopulationCapturability", fieldPopulationCapturability = new MatrixPanelEditor());
        
        fieldPopulationCapturability.setName("fieldPopulationCapturability");
        fieldPopulationCapturability.addMatrixPanelListener(JAXXUtil.getEventListener(MatrixPanelListener.class, "matrixChanged", this, "doMatrixChanged__on__fieldPopulationCapturability"));
        fieldPopulationCapturability.putClientProperty("sensitivityBean", Population.class);
        fieldPopulationCapturability.putClientProperty("sensitivityMethod", "Capturability");
    }

    protected void createFieldPopulationCapturabilityComment() {
        $objectMap.put("fieldPopulationCapturabilityComment", fieldPopulationCapturabilityComment = new JTextArea());
        
        fieldPopulationCapturabilityComment.setName("fieldPopulationCapturabilityComment");
        fieldPopulationCapturabilityComment.setColumns(15);
        fieldPopulationCapturabilityComment.setLineWrap(true);
        fieldPopulationCapturabilityComment.setWrapStyleWord(true);
        fieldPopulationCapturabilityComment.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldPopulationCapturabilityComment"));
    }

    protected void createFieldUseCapturabilityEquation() {
        $objectMap.put("fieldUseCapturabilityEquation", fieldUseCapturabilityEquation = new JCheckBox());
        
        fieldUseCapturabilityEquation.setName("fieldUseCapturabilityEquation");
        fieldUseCapturabilityEquation.setText(t("isisfish.populationCapturability.useCapturabilityEquation"));
        fieldUseCapturabilityEquation.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fieldUseCapturabilityEquation"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new PopulationCapturabilityHandler(this));
    }

    protected void createHidablePanel() {
        $objectMap.put("hidablePanel", hidablePanel = new JPanel());
        
        hidablePanel.setName("hidablePanel");
        hidablePanel.setLayout(new java.awt.CardLayout());
    }

    protected void createSave() {
        $objectMap.put("save", save = new JButton());
        
        save.setName("save");
        save.setText(t("isisfish.common.save"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(Population.class, "capturability"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToValidator();
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(fieldUseCapturabilityEquation), new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(hidablePanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 5, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 5, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToHidablePanel();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(SwingUtil.boxComponentWithJxLayer(fieldPopulationCapturabilityComment));
        
        // apply 13 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 2 property setters
        capturabilityEquation.setClazz(fr.ifremer.isisfish.equation.PopulationCapturabilityEquation.class);
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createHandler();
        createValidator();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("isisfish.populationCapturability.selectCoefficient"));
        createFieldUseCapturabilityEquation();
        createHidablePanel();
        createFieldPopulationCapturability();
        createCapturabilityEquation();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("isisfish.populationCapturability.comments"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFieldPopulationCapturabilityComment();
        createSave();
        createCancel();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 13 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 13 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_USE_CAPTURABILITY_EQUATION_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldUseCapturabilityEquation.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_USE_CAPTURABILITY_EQUATION_SELECTED, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    fieldUseCapturabilityEquation.setSelected(getBean().isCapturabilityEquationUsed());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_CAPTURABILITY_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationCapturability.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_CAPTURABILITY_MATRIX, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null && getBean().getCapturability() != null) {
                    fieldPopulationCapturability.setMatrix(getBean().getCapturability() == null ? null : getBean().getCapturability().copy());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CAPTURABILITY_EQUATION_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                capturabilityEquation.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CAPTURABILITY_EQUATION_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                capturabilityEquation.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL1_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel1.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_CAPTURABILITY_COMMENT_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationCapturabilityComment.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_CAPTURABILITY_COMMENT_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldPopulationCapturabilityComment, jaxx.runtime.SwingUtil.getStringValue(getBean().getCapturabilityComment()));
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    save.setEnabled(validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CANCEL_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("valid", this);
                }
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    cancel.setEnabled(validator.isValid() && validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("valid", this);
                }
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
    }

}