/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.web.actions.auth;

import fr.ifremer.coser.web.CoserWebConfig;
import fr.ifremer.coser.web.actions.common.AbstractCoserAction;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.interceptor.SessionAware;
import org.nuiton.util.StringUtil;

@Result(type="redirect", location="/admin/index")
public class PerformLoginAction
extends AbstractCoserAction
implements SessionAware {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(PerformLoginAction.class);
    protected String login;
    protected String password;
    protected transient Map<String, Object> session;

    public void setLogin(String login) {
        this.login = login;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setSession(Map<String, Object> session) {
        this.session = session;
    }

    public String execute() throws Exception {
        String result;
        CoserWebConfig config = this.getService().getConfig();
        if (config.getAdminLogin().equals(this.login) && this.equalsSHA1Password(config, this.password)) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Successfull login: " + this.login));
            }
            this.session.put("login", this.login);
            result = "success";
        } else {
            this.addActionError("Invalid login/password");
            result = "input";
        }
        return result;
    }

    protected boolean equalsSHA1Password(CoserWebConfig config, String password) {
        String sha1Password;
        String configSha1Password = config.getAdminPassword();
        boolean result = configSha1Password.equals(sha1Password = StringUtil.encodeSHA1((String)password));
        if (!result) {
            configSha1Password = StringUtil.encodeSHA1((String)configSha1Password);
            result = configSha1Password.equals(sha1Password);
        }
        return result;
    }
}

