/*
 * #%L
 * $Id: DeleteProjectsAction.java 1084 2012-11-16 15:25:34Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/coser/tags/coser-1.4.2/coser-web/src/main/java/fr/ifremer/coser/web/actions/admin/DeleteProjectsAction.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package fr.ifremer.coser.web.actions.admin;

import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.InterceptorRefs;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;

import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.services.WebService;
import fr.ifremer.coser.web.CoserWebException;
import fr.ifremer.coser.web.ServiceFactory;
import fr.ifremer.coser.web.actions.common.CoserAction;

/**
 * Project list action.
 * 
 * @author chatellier
 * @version $Revision: 1084 $
 * 
 * Last update : $Date: 2012-11-16 16:25:34 +0100 (Fri, 16 Nov 2012) $
 * By : $Author: echatellier $
 */
@ParentPackage("admin")
@InterceptorRefs({
    @InterceptorRef("loginInterceptor"),
    @InterceptorRef("defaultStack")
})
@Result(name="success", type="redirect", location="list-projects")
public class DeleteProjectsAction extends CoserAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = 6024588562104111883L;

    private static final Log log = LogFactory.getLog(DeleteProjectsAction.class);

    /**
     * Contient les identifiants des zones dont on souhaites supprimer le
     * resultat conrespondant dans le stockage indicateur.
     */
    protected List<String> indicatorsZonesId;
    
    /**
     * Contient les identifiants des zones dont on souhaites supprimer le
     * resultat conrespondant dans le stockage cartes.
     */
    protected List<String> mapsZonesId;

    public void setIndicatorsZonesId(List<String> indicatorsZonesId) {
        this.indicatorsZonesId = indicatorsZonesId;
    }
    
    public void setMapsZonesId(List<String> mapsZonesId) {
        this.mapsZonesId = mapsZonesId;
    }

    public String execute() {
        WebService webService = ServiceFactory.getWebService();

        try {
            if (log.isDebugEnabled()) {
                log.debug("Delete indicators zone : " + indicatorsZonesId);
            }
            if (CollectionUtils.isNotEmpty(indicatorsZonesId)) {
                webService.deleteIndicatorsResult(indicatorsZonesId);
            }

            if (log.isDebugEnabled()) {
                log.debug("Delete maps zone : " + mapsZonesId);
            }
            if (CollectionUtils.isNotEmpty(mapsZonesId)) {
                webService.deleteMapsResult(mapsZonesId);
            }
        } catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get data from web service", ex);
        }

        return SUCCESS;
    }
}
