/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.web.actions.map;

import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.services.WebService;
import fr.ifremer.coser.web.CoserWebException;
import fr.ifremer.coser.web.ServiceFactory;
import fr.ifremer.coser.web.actions.common.CoserAction;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

public class MapDataAction
extends CoserAction {
    private static final long serialVersionUID = 1663244944108703571L;
    protected String survey;
    protected String species;

    public String getSurvey() {
        return this.survey;
    }

    public void setSurvey(String survey) {
        this.survey = survey;
    }

    public String getSpecies() {
        return this.species;
    }

    public void setSpecies(String species) {
        this.species = species;
    }

    @Action(results={@Result(type="stream", params={"contentType", "image/png", "inputName", "inputStream"})})
    public String execute() {
        return "success";
    }

    public InputStream getInputStream() {
        WebService webService = ServiceFactory.getWebService();
        FileInputStream input = null;
        try {
            File mapImage = webService.getMapFile(this.survey, this.species);
            input = new FileInputStream(mapImage);
        }
        catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get map file", (Throwable)ex);
        }
        catch (FileNotFoundException ex) {
            throw new CoserWebException("Can't get map file", (Throwable)ex);
        }
        return input;
    }
}

