/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.web.actions.com;

import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.services.WebService;
import fr.ifremer.coser.web.CoserWebException;
import fr.ifremer.coser.web.ServiceFactory;
import fr.ifremer.coser.web.actions.common.CoserAction;
import java.util.Locale;

public class GraphAction
extends CoserAction {
    private static final long serialVersionUID = 3385467755357775199L;
    protected String facade;
    protected String zone;
    protected String indicator;

    public String getFacade() {
        return this.facade;
    }

    public void setFacade(String facade) {
        this.facade = facade;
    }

    public String getZone() {
        return this.zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public String getIndicator() {
        return this.indicator;
    }

    public void setIndicator(String indicator) {
        this.indicator = indicator;
    }

    public String getFacadeDisplayName() {
        WebService webService = ServiceFactory.getWebService();
        String displayName = null;
        try {
            displayName = (String)webService.getFacades().get(this.facade);
        }
        catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get facade display name", (Throwable)ex);
        }
        return displayName;
    }

    public String getZoneDisplayName() {
        WebService webService = ServiceFactory.getWebService();
        String displayName = null;
        try {
            displayName = (String)webService.getZoneForFacade(this.facade, false).get(this.zone);
        }
        catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get zone display name", (Throwable)ex);
        }
        return displayName;
    }

    public String getIndicatorDisplayName() {
        Locale locale = this.getLocale();
        String localeCode = locale.getLanguage();
        WebService webService = ServiceFactory.getWebService();
        String displayName = null;
        try {
            displayName = (String)webService.getIndicators(this.zone, null, localeCode).get(this.indicator);
        }
        catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get species display name", (Throwable)ex);
        }
        return displayName;
    }

    public String execute() {
        return "success";
    }
}

