/*
 * #%L
 * $Id: ServiceFactory.java 578 2011-01-25 21:45:27Z chatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/coser/tags/coser-1.0.8/coser-web/src/main/java/fr/ifremer/coser/web/ServiceFactory.java $
 * %%
 * Copyright (C) 2010 - 2011 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package fr.ifremer.coser.web;

import java.util.Locale;

import org.nuiton.i18n.I18n;
import org.nuiton.util.ArgumentsParserException;

import fr.ifremer.coser.services.WebService;

/**
 * Coser service singleton factory.
 * 
 * @author chatellier
 * @version $Revision: 578 $
 * 
 * Last update : $Date: 2011-01-25 22:45:27 +0100 (mar., 25 janv. 2011) $
 * By : $Author: chatellier $
 */
public class ServiceFactory {

    protected static CoserWebConfig coserConfig;

    protected static WebService webService;

    static {
        // on a pas trop de locale là :(
        I18n.init(null, (Locale)null);
    }

    /**
     * Get application config configuration.
     * 
     * @return configuration
     */
    public static synchronized CoserWebConfig getCoserConfig() {
        if (coserConfig == null) {
            coserConfig = new CoserWebConfig();
            try {
                coserConfig.parse(new String[0]);
            } catch (ArgumentsParserException ex) {
                throw new CoserWebException("Can't read configuration", ex);
            }
        }
        return coserConfig;
    }

    /**
     * Get web service.
     * 
     * @return web service
     */
    public static synchronized WebService getWebService() {
        if (webService == null) {
            webService = new WebService(getCoserConfig());
        }
        return webService;
    }
}
