/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.services;

import fr.ifremer.coser.CoserBusinessConfig;
import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.bean.AbstractDataContainer;
import fr.ifremer.coser.bean.Project;
import fr.ifremer.coser.command.Command;
import java.util.ListIterator;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommandService {
    private static final Log log = LogFactory.getLog(CommandService.class);
    protected CoserBusinessConfig config;

    public CommandService(CoserBusinessConfig config) {
        this.config = config;
    }

    public String getUniqueCommandUUID() {
        return UUID.randomUUID().toString();
    }

    public void doAction(Command command, Project project, AbstractDataContainer container) throws CoserBusinessException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Do action " + command));
        }
        if (command.getCommandUUID() == null) {
            command.setCommandUUID(this.getUniqueCommandUUID());
        }
        command.doCommand(project, container);
        container.addHistoryCommand(command);
    }

    public void undoAction(Project project, AbstractDataContainer container) throws CoserBusinessException {
        ListIterator<Command> itCommand = container.getHistoryCommands().listIterator(container.getHistoryCommands().size());
        String lastUUID = null;
        while (itCommand.hasPrevious()) {
            Command command = itCommand.previous();
            if (lastUUID != null && !lastUUID.equals(command.getCommandUUID())) break;
            command.undoCommand(project, container);
            lastUUID = command.getCommandUUID();
            itCommand.remove();
        }
    }

    public void undoAction(Project project, AbstractDataContainer container, int commandsCount) throws CoserBusinessException {
        for (int i = 0; i < commandsCount; ++i) {
            Command command = container.getHistoryCommands().get(container.getHistoryCommands().size() - 1);
            command.undoCommand(project, container);
            container.removeHistoryCommand(command);
        }
    }
}

