/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.result.repository.echobase.command;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import fr.ifremer.coser.bean.SpeciesMap;
import fr.ifremer.coser.result.repository.echobase.EchoBasePredicates;
import fr.ifremer.coser.result.repository.echobase.command.AbstractEchoBaseCommand;
import fr.ifremer.coser.result.repository.legacy.LegacyPredicates;
import fr.ifremer.coser.result.request.ExtractRawDataAndResultsRequest;
import fr.ifremer.coser.result.result.ExtractRawDataAndResultsResult;
import fr.ifremer.coser.storage.DataStorage;
import fr.ifremer.coser.storage.DataStorageWalker;
import fr.ifremer.coser.storage.DataStorages;
import fr.ifremer.coser.util.DataType;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.chart.JFreeChart;

public class ExtractRawDataAndResultsCommand
extends AbstractEchoBaseCommand<ExtractRawDataAndResultsRequest> {
    private static final Log log = LogFactory.getLog(ExtractRawDataAndResultsCommand.class);

    @Override
    public boolean accept(ExtractRawDataAndResultsRequest request) {
        boolean result;
        boolean bl = result = this.repository.matchExtractTypeList(request) && this.repository.matchZone(request);
        if (result && this.repository.isIndicatorsResult()) {
            Predicate predicate;
            if (request.getExtractTypeList().contains((Object)DataType.POPULATION) && CollectionUtils.isNotEmpty(request.getPopulationIndicatorList())) {
                predicate = Predicates.and(EchoBasePredicates.populationIndicatorPredicate(request.getPopulationIndicatorList()), EchoBasePredicates.populationSpeciesPredicate(request.getSpeciesList()));
                result = this.repository.matchPopulation((Predicate<String[]>)predicate);
            }
            if (!result && request.getExtractTypeList().contains((Object)DataType.COMMUNITY) && CollectionUtils.isNotEmpty(request.getCommunityIndicatorList())) {
                predicate = Predicates.and(EchoBasePredicates.communityIndicatorPredicate(request.getCommunityIndicatorList()), EchoBasePredicates.communitySpeciesPredicate(request.getSpeciesList()));
                result = this.repository.matchCommunity((Predicate<String[]>)predicate);
            }
        }
        return result;
    }

    public ExtractRawDataAndResultsResult execute(ExtractRawDataAndResultsRequest request) {
        MultiKeyMap<String, Pair<File, String>> map;
        List<DataType> extractTypeList = request.getExtractTypeList();
        List<String> speciesList = request.getSpeciesList();
        List<String> communityIndicatorList = request.getCommunityIndicatorList();
        List<String> populationIndicatorList = request.getPopulationIndicatorList();
        File extractDirectory = request.getExtractDirectory();
        if (extractTypeList.contains((Object)DataType.SOURCE) && this.repository.isDataResult()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Extracting sources");
            }
            File srcDir = new File(extractDirectory, "sources");
            this.extractRawData(srcDir);
        }
        MultiKeyMap<String, File> pdfMaps = null;
        if (extractTypeList.contains((Object)DataType.MAP) && this.repository.isMapsResult()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Extracting maps");
            }
            pdfMaps = this.extractMaps(speciesList);
        }
        MultiKeyMap pdfCharts = new MultiKeyMap();
        if (CollectionUtils.isNotEmpty(communityIndicatorList) && this.repository.isIndicatorsResult()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Extracting community charts");
            }
            map = this.extractCommunityResults(communityIndicatorList, this.repository.getZone(), 650, 430);
            pdfCharts.putAll(map);
        }
        if (CollectionUtils.isNotEmpty(populationIndicatorList) && this.repository.isIndicatorsResult()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Extracting population charts");
            }
            map = this.extractPopulationResults(speciesList, populationIndicatorList, this.repository.getZone(), 650, 430);
            pdfCharts.putAll(map);
        }
        ExtractRawDataAndResultsResult result = this.newExtractRawDataAndResultsResult(pdfMaps, (MultiKeyMap<String, Pair<File, String>>)pdfCharts);
        return result;
    }

    protected MultiKeyMap<String, File> extractMaps(List<String> speciesList) {
        MultiKeyMap pdfMaps = new MultiKeyMap();
        SpeciesMap speciesMap = this.repository.getSpeciesMap();
        String zone = this.repository.getZone();
        for (String species : speciesList) {
            File mapFile = this.repository.getMapSpeciesFile(species);
            String speciesName = speciesMap.getSpeciesName(species);
            pdfMaps.put((Object)zone, (Object)speciesName, (Object)mapFile);
        }
        return pdfMaps;
    }

    public MultiKeyMap<String, Pair<File, String>> extractCommunityResults(List<String> selectedIndicators, String zone, int width, int height) {
        ArrayList indicators = Lists.newArrayList(this.getCommunityIndicators());
        indicators.retainAll(selectedIndicators);
        final HashMap indicatorLists = new HashMap();
        this.walkOnCommunity(LegacyPredicates.communityIndicatorPredicate(indicators), new DataStorageWalker(){

            @Override
            public void onRow(String ... row) {
                String indicatorCode = row[1];
                String localList = (String)indicatorLists.get(indicatorCode);
                if (StringUtils.isBlank((CharSequence)localList)) {
                    String indicatorList = row[2];
                    indicatorLists.put(indicatorCode, indicatorList);
                }
            }
        });
        MultiKeyMap result = new MultiKeyMap();
        for (String indicator : indicators) {
            String speciesList = (String)indicatorLists.get(indicator);
            Predicate predicate = Predicates.and(LegacyPredicates.communityIndicatorPredicate(indicator), LegacyPredicates.communitySpeciesListPredicate(speciesList));
            JFreeChart chart = this.generateCommunityChart(zone, indicator, speciesList);
            if (chart == null) continue;
            File chartFile = this.getCharts().generateChartFile("coser-community-chart-", chart, width, height);
            DataStorage storage = this.extractCommunity((Predicate<String[]>)predicate);
            String rawDataText = DataStorages.toString(storage);
            result.put((Object)zone, (Object)indicator, (Object)Pair.of((Object)chartFile, (Object)rawDataText));
        }
        return result;
    }

    public MultiKeyMap<String, Pair<File, String>> extractPopulationResults(List<String> selectedSpecies, List<String> selectedIndicators, String zone, int width, int height) {
        ArrayList speciesList = Lists.newArrayList(this.getPopulationSpecies());
        speciesList.retainAll(selectedSpecies);
        MultiKeyMap result = new MultiKeyMap();
        for (String species : speciesList) {
            ArrayList indicators = Lists.newArrayList(this.getPopulationIndicators(species));
            indicators.retainAll(selectedIndicators);
            for (String indicator : indicators) {
                Predicate predicate = Predicates.and(LegacyPredicates.populationIndicatorPredicate(indicator), LegacyPredicates.populationSpeciesPredicate(species));
                JFreeChart chart = this.generatePopulationChart(zone, indicator, species);
                if (chart == null) continue;
                File chartFile = this.getCharts().generateChartFile("coser-population-chart-", chart, width, height);
                DataStorage storage = this.extractPopulation((Predicate<String[]>)predicate);
                String rawDataText = DataStorages.toString(storage);
                result.put((Object)zone, (Object)(indicator + "-" + species), (Object)Pair.of((Object)chartFile, (Object)rawDataText));
            }
        }
        return result;
    }
}

