/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.result.repository.echobase.command;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Sets;
import fr.ifremer.coser.CoserBusinessConfig;
import fr.ifremer.coser.CoserTechnicalException;
import fr.ifremer.coser.bean.IndicatorMap;
import fr.ifremer.coser.bean.ZoneMap;
import fr.ifremer.coser.result.CoserCommand;
import fr.ifremer.coser.result.CoserRequest;
import fr.ifremer.coser.result.CoserRequestContext;
import fr.ifremer.coser.result.repository.echobase.EchoBasePredicates;
import fr.ifremer.coser.result.repository.echobase.EchoBaseResultRepository;
import fr.ifremer.coser.result.result.ExtractRawDataAndResultsResult;
import fr.ifremer.coser.result.result.FileResult;
import fr.ifremer.coser.result.result.MapResult;
import fr.ifremer.coser.result.result.VoidResult;
import fr.ifremer.coser.result.util.Charts;
import fr.ifremer.coser.result.util.Reports;
import fr.ifremer.coser.storage.DataStorage;
import fr.ifremer.coser.storage.DataStorageWalker;
import fr.ifremer.coser.storage.DataStorages;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jfree.chart.JFreeChart;
import org.nuiton.i18n.I18n;

public abstract class AbstractEchoBaseCommand<R extends CoserRequest>
implements CoserCommand<EchoBaseResultRepository, R> {
    protected CoserRequestContext context;
    protected EchoBaseResultRepository repository;

    @Override
    public void setRequestContext(CoserRequestContext context) {
        this.context = context;
    }

    @Override
    public void setRepository(EchoBaseResultRepository repository) {
        this.repository = repository;
    }

    public IndicatorMap getIndicatorsMap() {
        return this.context.getIndicatorMap();
    }

    public ZoneMap getZonesMap() {
        return this.context.getZoneMap();
    }

    public Reports getReports() {
        return this.context.getReports();
    }

    public Charts getCharts() {
        return this.context.getCharts();
    }

    public Locale getLocale() {
        return this.context.getLocale();
    }

    public CoserBusinessConfig getConfig() {
        return this.context.getConfig();
    }

    public void extractRawData(File targetDirectory) {
        try {
            FileUtils.forceMkdir((File)targetDirectory);
        }
        catch (IOException e) {
            throw new CoserTechnicalException("Could not create directory: " + targetDirectory, e);
        }
        try {
            File sourceDirectory = this.repository.getProject().getRawDataDirectory();
            FileUtils.copyDirectory((File)sourceDirectory, (File)targetDirectory);
        }
        catch (IOException e) {
            throw new CoserTechnicalException("Could not extract raw data", e);
        }
    }

    protected MapResult newMapResult(Map<String, String> map) {
        MapResult result = new MapResult(this.repository.getId(), map);
        return result;
    }

    protected FileResult newFileResult(File file) {
        FileResult result = new FileResult(this.repository.getId(), file);
        return result;
    }

    protected VoidResult newVoidResult() {
        VoidResult result = new VoidResult(this.repository.getId());
        return result;
    }

    protected ExtractRawDataAndResultsResult newExtractRawDataAndResultsResult(MultiKeyMap<String, File> pdfMaps, MultiKeyMap<String, Pair<File, String>> pdfCharts) {
        ExtractRawDataAndResultsResult result = new ExtractRawDataAndResultsResult(this.repository.getId(), pdfMaps, pdfCharts);
        return result;
    }

    protected Set<String> getPopulationSpecies() {
        final HashSet result = Sets.newHashSet();
        DataStorageWalker walker = new DataStorageWalker(){

            @Override
            public void onRow(String ... tuple) {
                String speciesCode = tuple[2];
                result.add(speciesCode);
            }
        };
        this.walkOnPopulation(walker);
        return result;
    }

    protected Map<String, String> getPopulationSpeciesMap() {
        final HashSet speciesList = Sets.newHashSet();
        DataStorageWalker walker = new DataStorageWalker(){

            @Override
            public void onRow(String ... tuple) {
                String speciesCode = tuple[2];
                speciesList.add(speciesCode);
            }
        };
        this.walkOnPopulation(walker);
        Map<String, String> result = this.repository.getSpeciesMap().getSpeciesSubMap(speciesList);
        return result;
    }

    protected Map<String, String> getCommunitySpeciesMap() {
        final HashSet speciesList = Sets.newHashSet();
        DataStorageWalker walker = new DataStorageWalker(){

            @Override
            public void onRow(String ... tuple) {
                String speciesCode = tuple[2];
                speciesList.add(speciesCode);
            }
        };
        this.walkOnCommunity(walker);
        Map<String, String> result = this.repository.getSpeciesMap().getSpeciesSubMap(speciesList);
        return result;
    }

    protected Map<String, String> getCommunitySpeciesMap(String indicator) {
        final HashSet speciesList = Sets.newHashSet();
        DataStorageWalker walker = new DataStorageWalker(){

            @Override
            public void onRow(String ... tuple) {
                String speciesCode = tuple[2];
                speciesList.add(speciesCode);
            }
        };
        this.walkOnCommunity(EchoBasePredicates.communityIndicatorPredicate(indicator), walker);
        Map<String, String> result = this.repository.getSpeciesMap().getSpeciesSubMap(speciesList);
        return result;
    }

    protected Map<String, String> getMapSpeciesMap() {
        Map<String, String> result = this.repository.getMapSpecies();
        return result;
    }

    protected Set<String> getCommunityIndicators() {
        final HashSet result = Sets.newHashSet();
        DataStorageWalker walker = new DataStorageWalker(){

            @Override
            public void onRow(String ... tuple) {
                String indicatorCode = tuple[1];
                result.add(indicatorCode);
            }
        };
        this.walkOnCommunity(walker);
        return result;
    }

    protected Set<String> getPopulationIndicators() {
        final HashSet result = Sets.newHashSet();
        DataStorageWalker walker = new DataStorageWalker(){

            @Override
            public void onRow(String ... tuple) {
                String indicatorCode = tuple[1];
                result.add(indicatorCode);
            }
        };
        this.walkOnPopulation(walker);
        return result;
    }

    protected Set<String> getPopulationIndicators(String species) {
        Preconditions.checkNotNull((Object)species);
        final HashSet result = Sets.newHashSet();
        DataStorageWalker walker = new DataStorageWalker(){

            @Override
            public void onRow(String ... tuple) {
                String indicatorCode = tuple[1];
                result.add(indicatorCode);
            }
        };
        this.walkOnPopulation(EchoBasePredicates.populationSpeciesPredicate(species), walker);
        return result;
    }

    protected void walkOnCommunity(DataStorageWalker walker) {
        Preconditions.checkNotNull((Object)walker);
        DataStorage storage = this.repository.getCommunityIndicatorStorage();
        DataStorages.walk(storage, walker);
    }

    protected void walkOnCommunity(Predicate<String[]> predicate, DataStorageWalker walker) {
        Preconditions.checkNotNull((Object)walker);
        Preconditions.checkNotNull(predicate);
        DataStorage storage = this.repository.getCommunityIndicatorStorage();
        DataStorages.walk(storage, predicate, walker);
    }

    protected void walkOnPopulation(DataStorageWalker walker) {
        Preconditions.checkNotNull((Object)walker);
        DataStorage storage = this.repository.getPopulationIndicatorStorage();
        DataStorages.walk(storage, walker);
    }

    protected void walkOnPopulation(Predicate<String[]> predicate, DataStorageWalker walker) {
        Preconditions.checkNotNull((Object)walker);
        Preconditions.checkNotNull(predicate);
        DataStorage storage = this.repository.getPopulationIndicatorStorage();
        DataStorages.walk(storage, predicate, walker);
    }

    protected DataStorage extractCommunity(Predicate<String[]> predicate) {
        Preconditions.checkNotNull(predicate);
        String headerList = I18n.l((Locale)this.getLocale(), (String)"coser.business.echobase.community.header", (Object[])new Object[0]);
        String[] header = headerList.split("\\s*,\\s*");
        DataStorage source = this.repository.getCommunityIndicatorStorage();
        DataStorage result = DataStorages.sub(source, predicate, header);
        return result;
    }

    protected DataStorage extractPopulation(Predicate<String[]> predicate) {
        Preconditions.checkNotNull(predicate);
        String headerList = I18n.l((Locale)this.getLocale(), (String)"coser.business.echobase.population.header", (Object[])new Object[0]);
        String[] header = headerList.split("\\s*,\\s*");
        DataStorage source = this.repository.getPopulationIndicatorStorage();
        DataStorage result = DataStorages.sub(source, predicate, header);
        return result;
    }

    protected JFreeChart generateCommunityChart(String zone, String indicator, String species) {
        Predicate predicate = Predicates.and(EchoBasePredicates.communityIndicatorPredicate(indicator), EchoBasePredicates.communitySpeciesPredicate(species));
        Charts.ExtractGraphDataWalker walker = new Charts.ExtractGraphDataWalker(){

            @Override
            protected String getYearData(String ... tuple) {
                return tuple[4];
            }

            @Override
            protected String getEstimationData(String ... tuple) {
                return tuple[5];
            }

            @Override
            protected String getEcartData(String ... tuple) {
                return tuple[6];
            }
        };
        this.walkOnCommunity((Predicate<String[]>)predicate, walker);
        Locale locale = this.getLocale();
        String zoneDisplayName = this.getZonesMap().getZoneFullName(zone);
        String indicatorName = this.getIndicatorsMap().getIndicatorValue(locale, indicator);
        String speciesListName = this.repository.getSpeciesMap().getSpeciesName(species);
        String chartTitle = zoneDisplayName + " - " + indicatorName + " - " + speciesListName;
        JFreeChart chart = this.getCharts().generateCommunityChart(locale, walker, this.getIndicatorsMap(), indicator, chartTitle);
        return chart;
    }

    protected JFreeChart generatePopulationChart(String zone, String species, String indicator) {
        Predicate predicate = Predicates.and(EchoBasePredicates.populationSpeciesPredicate(species), EchoBasePredicates.populationIndicatorPredicate(indicator));
        Charts.ExtractGraphDataWalker walker = new Charts.ExtractGraphDataWalker(){

            @Override
            protected String getYearData(String ... tuple) {
                return tuple[4];
            }

            @Override
            protected String getEstimationData(String ... tuple) {
                return tuple[5];
            }

            @Override
            protected String getEcartData(String ... tuple) {
                return tuple[6];
            }
        };
        this.walkOnPopulation((Predicate<String[]>)predicate, walker);
        Locale locale = this.getLocale();
        String zoneDisplayName = this.getZonesMap().getZoneFullName(zone);
        String indicatorName = this.getIndicatorsMap().getIndicatorValue(locale, indicator);
        String speciesName = this.repository.getSpeciesMap().getReportDisplayName(species);
        String chartTitle = zoneDisplayName + " - " + indicatorName + " - " + speciesName;
        JFreeChart chart = this.getCharts().generatePopulationChart(locale, walker, this.getIndicatorsMap(), indicator, chartTitle);
        return chart;
    }
}

