/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.result.repository.echobase;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.List;

public class EchoBasePredicates {
    protected EchoBasePredicates() {
    }

    public static Predicate<String[]> communityIndicatorPredicate(String indicator) {
        return new CommunityIndicatorPredicate(Lists.newArrayList((Object[])new String[]{indicator}));
    }

    public static Predicate<String[]> communityIndicatorPredicate(List<String> indicator) {
        return new CommunityIndicatorPredicate(indicator);
    }

    public static Predicate<String[]> communitySpeciesPredicate(String species) {
        return new CommunitySpeciesPredicate(Lists.newArrayList((Object[])new String[]{species}));
    }

    public static Predicate<String[]> communitySpeciesPredicate(List<String> species) {
        return new CommunitySpeciesPredicate(species);
    }

    public static Predicate<String[]> populationSpeciesPredicate(String species) {
        return new PopulationSpeciesPredicate(Lists.newArrayList((Object[])new String[]{species}));
    }

    public static Predicate<String[]> populationSpeciesPredicate(List<String> species) {
        return new PopulationSpeciesPredicate(species);
    }

    public static Predicate<String[]> populationIndicatorPredicate(String indicator) {
        return new PopulationIndicatorPredicate(Lists.newArrayList((Object[])new String[]{indicator}));
    }

    public static Predicate<String[]> populationIndicatorPredicate(List<String> indicator) {
        return new PopulationIndicatorPredicate(indicator);
    }

    protected static class PopulationIndicatorPredicate
    implements Predicate<String[]> {
        private final List<String> indicator;

        PopulationIndicatorPredicate(List<String> indicator) {
            Preconditions.checkNotNull(indicator, (Object)"Indicators can not be null");
            this.indicator = indicator;
        }

        public boolean apply(String[] input) {
            String indicatorCode = input[1];
            boolean result = this.indicator.contains(indicatorCode);
            return result;
        }
    }

    protected static class PopulationSpeciesPredicate
    implements Predicate<String[]> {
        private final List<String> species;

        PopulationSpeciesPredicate(List<String> species) {
            Preconditions.checkNotNull(species, (Object)"Species can not be null");
            this.species = species;
        }

        public boolean apply(String[] input) {
            String speciesCode = input[2];
            boolean result = this.species.contains(speciesCode);
            return result;
        }
    }

    protected static class CommunityIndicatorPredicate
    implements Predicate<String[]> {
        private final List<String> indicator;

        CommunityIndicatorPredicate(List<String> indicator) {
            Preconditions.checkNotNull(indicator, (Object)"Indicators can not be null");
            this.indicator = indicator;
        }

        public boolean apply(String[] input) {
            String indicatorCode = input[1];
            boolean result = this.indicator.contains(indicatorCode);
            return result;
        }
    }

    protected static class CommunitySpeciesPredicate
    implements Predicate<String[]> {
        private final List<String> species;

        CommunitySpeciesPredicate(List<String> species) {
            Preconditions.checkNotNull(species, (Object)"Species can not be null");
            this.species = species;
        }

        public boolean apply(String[] input) {
            String speciesCode = input[2];
            boolean result = this.species.contains(speciesCode);
            return result;
        }
    }
}

