/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.command;

import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.CoserConstants;
import fr.ifremer.coser.CoserUtils;
import fr.ifremer.coser.bean.AbstractDataContainer;
import fr.ifremer.coser.bean.Project;
import fr.ifremer.coser.command.CategoryLineCommand;
import fr.ifremer.coser.data.AbstractDataEntity;
import fr.ifremer.coser.data.Catch;
import fr.ifremer.coser.data.Haul;
import fr.ifremer.coser.data.Length;
import fr.ifremer.coser.data.Strata;
import fr.ifremer.coser.storage.DataStorage;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.i18n.I18n;

public class ModifyFieldCommand
extends CategoryLineCommand {
    protected String fieldName;
    protected String currentValue;
    protected String newValue;

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public Object getCurrentValue() {
        return this.currentValue;
    }

    public void setCurrentValue(String currentValue) {
        this.currentValue = currentValue;
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public void setNewValue(String newValue) {
        this.newValue = newValue;
    }

    @Override
    public void doCommand(Project project, AbstractDataContainer container) throws CoserBusinessException {
        AbstractDataEntity beanData = null;
        DataStorage dataStorage = null;
        switch (this.category) {
            case CATCH: {
                beanData = new Catch();
                dataStorage = container.getCatch();
                break;
            }
            case HAUL: {
                beanData = new Haul();
                dataStorage = container.getHaul();
                break;
            }
            case LENGTH: {
                beanData = new Length();
                dataStorage = container.getLength();
                break;
            }
            case STRATA: {
                beanData = new Strata();
                dataStorage = container.getStrata();
            }
        }
        int lineIndex = dataStorage.indexOf(this.lineNumber);
        String[] data = dataStorage.get(lineIndex);
        beanData.setData(data);
        try {
            String beanFieldName = Introspector.decapitalize(this.fieldName);
            String stringFieldProperty = beanFieldName + "AsString";
            String dataValue = (String)PropertyUtils.getProperty((Object)beanData, (String)stringFieldProperty);
            if (!dataValue.equals(this.currentValue)) {
                throw new CoserBusinessException(I18n.t((String)"Can't replace data value. Expected %s but was %s", (Object[])new Object[]{this.currentValue, dataValue}));
            }
            PropertyUtils.setProperty((Object)beanData, (String)stringFieldProperty, (Object)this.newValue);
            dataStorage.set(lineIndex, beanData.getData());
        }
        catch (Exception ex) {
            throw new CoserBusinessException("Can't replace data field value", ex);
        }
    }

    @Override
    public void undoCommand(Project project, AbstractDataContainer container) throws CoserBusinessException {
        AbstractDataEntity beanData = null;
        DataStorage dataStorage = null;
        switch (this.category) {
            case CATCH: {
                beanData = new Catch();
                dataStorage = container.getCatch();
                break;
            }
            case HAUL: {
                beanData = new Haul();
                dataStorage = container.getHaul();
                break;
            }
            case LENGTH: {
                beanData = new Length();
                dataStorage = container.getLength();
                break;
            }
            case STRATA: {
                beanData = new Strata();
                dataStorage = container.getStrata();
            }
        }
        int lineIndex = dataStorage.indexOf(this.lineNumber);
        String[] data = dataStorage.get(lineIndex);
        beanData.setData(data);
        try {
            String beanFieldName = Introspector.decapitalize(this.fieldName);
            String stringFieldProperty = beanFieldName + "AsString";
            String dataValue = (String)PropertyUtils.getProperty((Object)beanData, (String)stringFieldProperty);
            if (!dataValue.equals(this.newValue)) {
                throw new CoserBusinessException(I18n.t((String)"Can't replace data value. Expected %s but was %s", (Object[])new Object[]{this.newValue, dataValue}));
            }
            PropertyUtils.setProperty((Object)beanData, (String)stringFieldProperty, (Object)this.currentValue);
            dataStorage.set(lineIndex, beanData.getData());
        }
        catch (Exception ex) {
            throw new CoserBusinessException("Can't replace data field value", ex);
        }
    }

    @Override
    public String toStringRepresentation() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("category=" + this.category.toString());
        args.add("lineNumber=" + this.lineNumber);
        args.add("fieldName=" + this.fieldName);
        args.add("currentValue=" + this.currentValue);
        args.add("newValue=" + this.newValue);
        return CoserUtils.convertBracketString(args);
    }

    @Override
    public void fromStringRepresentation(String representation) {
        List<String> args = CoserUtils.convertBracketToList(representation);
        for (String arg : args) {
            int indexOfEqual = arg.indexOf(61);
            String argAttribute = arg.substring(0, indexOfEqual);
            String value = arg.substring(indexOfEqual + 1);
            if (argAttribute.equals("category")) {
                this.category = CoserConstants.Category.valueOf(value);
                continue;
            }
            if (argAttribute.equals("lineNumber")) {
                this.lineNumber = value;
                continue;
            }
            if (argAttribute.equals("fieldName")) {
                this.fieldName = value;
                continue;
            }
            if (argAttribute.equals("currentValue")) {
                this.currentValue = value;
                continue;
            }
            if (!argAttribute.equals("newValue")) continue;
            this.newValue = value;
        }
    }

    @Override
    public String getLogString(Project project, AbstractDataContainer container) {
        String realFieldName = this.getRealFieldName(container);
        return I18n.t((String)"coser.business.command.modifyfield.log", (Object[])new Object[]{I18n.t((String)this.category.getTranslationKey(), (Object[])new Object[0]), this.lineNumber, realFieldName, this.currentValue, this.newValue});
    }

    @Override
    public String getDescription(Project project, AbstractDataContainer container) {
        String realFieldName = this.getRealFieldName(container);
        String desc = I18n.t((String)"coser.business.command.modifyfield.desc", (Object[])new Object[]{I18n.t((String)this.category.getTranslationKey(), (Object[])new Object[0]), this.lineNumber, realFieldName, this.currentValue, this.newValue});
        if (StringUtils.isNotBlank((CharSequence)this.comment)) {
            desc = desc + " (" + this.comment + ")";
        }
        return desc;
    }

    protected String getRealFieldName(AbstractDataContainer container) {
        Object[] headers = null;
        DataStorage dataStorage = null;
        switch (this.category) {
            case CATCH: {
                headers = Catch.EN_HEADERS;
                dataStorage = container.getCatch();
                break;
            }
            case HAUL: {
                headers = Haul.EN_HEADERS;
                dataStorage = container.getHaul();
                break;
            }
            case LENGTH: {
                headers = Length.EN_HEADERS;
                dataStorage = container.getLength();
                break;
            }
            case STRATA: {
                headers = Strata.EN_HEADERS;
                dataStorage = container.getStrata();
            }
        }
        int index = ArrayUtils.indexOf((Object[])headers, (Object)this.fieldName);
        String realFieldName = dataStorage.get(0)[index + 1];
        return realFieldName;
    }

    public String toString() {
        return "Modify field " + this.fieldName + " on line " + this.lineNumber;
    }
}

