/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.bean;

import com.google.common.collect.Maps;
import fr.ifremer.coser.storage.DataStorage;
import fr.ifremer.coser.storage.DataStorages;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

public class SpeciesMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final DataStorage storage;
    protected Map<String, String> speciesMap;

    public SpeciesMap(File speciesFile) {
        this.storage = DataStorages.load(speciesFile);
    }

    public DataStorage getStorage() {
        return this.storage;
    }

    public Iterator<String[]> iterator(boolean skipFirstLine) {
        Iterator<String[]> iterator = this.storage.iterator(skipFirstLine);
        return iterator;
    }

    public Map<String, String> getSpeciesMap() {
        if (this.speciesMap == null) {
            this.speciesMap = Maps.newTreeMap();
            Iterator<String[]> iterator = this.iterator(true);
            while (iterator.hasNext()) {
                String[] tuple = iterator.next();
                String speciesCode = tuple[3];
                String speciesLabel = tuple[4] + " " + tuple[5];
                this.speciesMap.put(speciesCode, speciesLabel);
            }
            this.speciesMap = Collections.unmodifiableMap(this.speciesMap);
        }
        return this.speciesMap;
    }

    public String getSpeciesName(String species) {
        return this.getSpeciesMap().get(species);
    }

    public Map<String, String> getSpeciesSubMap(Collection<String> speciesList) {
        TreeMap result = Maps.newTreeMap();
        if (speciesList != null) {
            Map<String, String> map = this.getSpeciesMap();
            for (String species : speciesList) {
                String speciesLabel = map.get(species);
                if (!StringUtils.isNotEmpty((CharSequence)speciesLabel)) continue;
                result.put(species, speciesLabel);
            }
        }
        return result;
    }

    public String getReportDisplayName(String species) {
        String displayName = null;
        Iterator<String[]> iterator = this.iterator(true);
        while (iterator.hasNext()) {
            String[] tuple = iterator.next();
            String speciesCode = tuple[3];
            if (!speciesCode.equals(species)) continue;
            displayName = tuple[4] + " " + tuple[5];
            break;
        }
        return displayName;
    }
}

