/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.bean;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.ifremer.coser.storage.DataStorage;
import fr.ifremer.coser.storage.DataStorageWalker;
import fr.ifremer.coser.storage.DataStorages;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndicatorMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(IndicatorMap.class);
    protected static final String KEY_FRENCH = Locale.FRENCH.getLanguage();
    protected static final String KEY_ENGLISH = Locale.ENGLISH.getLanguage();
    protected static final String KEY_SPANISH = "es";
    protected static final String KEY_UNIT = "unit";
    protected static final Set<String> SAFE_KEYS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{KEY_FRENCH, KEY_ENGLISH, "unit", "es"}));
    protected final MultiKeyMap<String, String> map;
    protected final Set<String> ids;

    public IndicatorMap(File indicatorsFile) {
        Preconditions.checkNotNull((Object)indicatorsFile);
        Preconditions.checkArgument((boolean)indicatorsFile.exists(), (Object)("Indicator file: " + indicatorsFile + " does not exist."));
        if (log.isInfoEnabled()) {
            log.info((Object)("Loading Indicator file: " + indicatorsFile));
        }
        this.map = new MultiKeyMap();
        final HashSet indicatorIs = Sets.newHashSet();
        DataStorage storage = DataStorages.load(indicatorsFile);
        DataStorages.walk(storage, new DataStorageWalker(){

            @Override
            public void onRow(String ... row) {
                String indicatorCode = row[0];
                indicatorIs.add(indicatorCode);
                IndicatorMap.this.map.put((Object)indicatorCode, (Object)KEY_FRENCH, (Object)row[1]);
                IndicatorMap.this.map.put((Object)indicatorCode, (Object)KEY_ENGLISH, (Object)row[2]);
                IndicatorMap.this.map.put((Object)indicatorCode, (Object)IndicatorMap.KEY_SPANISH, (Object)row[3]);
                IndicatorMap.this.map.put((Object)indicatorCode, (Object)IndicatorMap.KEY_UNIT, (Object)row[4]);
            }
        });
        this.ids = Collections.unmodifiableSet(indicatorIs);
    }

    public Set<String> getIds() {
        return this.ids;
    }

    public String getIndicatorValue(Locale locale, String indicator) {
        Preconditions.checkNotNull((Object)locale);
        Preconditions.checkNotNull((Object)indicator);
        String localeCode = this.getSafeLocaleKey(locale.getLanguage());
        String translation = this.getIndicatorValue(localeCode, indicator);
        return translation;
    }

    public String getIndicatorUnit(String indicator) {
        Preconditions.checkNotNull((Object)indicator);
        return this.getIndicatorValue(KEY_UNIT, indicator);
    }

    public Map<String, String> getIndicatorsValues(Locale locale, Collection<String> indicatorList) {
        TreeMap result = Maps.newTreeMap();
        if (indicatorList != null) {
            String localeCode = this.getSafeLocaleKey(locale.getLanguage());
            for (String indicator : indicatorList) {
                String indicatorLabel = this.getIndicatorValue(localeCode, indicator);
                result.put(indicator, indicatorLabel);
            }
        }
        return result;
    }

    protected String getIndicatorValue(String localeCode, String indicator) {
        Preconditions.checkNotNull((Object)localeCode);
        Preconditions.checkNotNull((Object)indicator);
        Preconditions.checkArgument((boolean)SAFE_KEYS.contains(localeCode));
        String translation = (String)this.map.get((Object)indicator, (Object)localeCode);
        if (translation == null) {
            translation = "##" + indicator + "##" + localeCode;
        }
        return translation;
    }

    protected String getSafeLocaleKey(String localeCode) {
        if (!SAFE_KEYS.contains(localeCode)) {
            localeCode = KEY_ENGLISH;
        }
        return localeCode;
    }
}

