/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser;

import org.nuiton.i18n.I18n;

public class CoserConstants {
    public static final char CSV_SEPARATOR_CHAR = ';';
    public static final char CSV_RESULT_SEPARATOR_CHAR = '\t';
    public static final String CSV_FILE_ENCODING = "UTF-8";
    public static final String VALIDATION_NA = "NA";
    public static final String STORAGE_ORIGINAL_DIRECTORY = "original";
    public static final String STORAGE_CONTROL_DIRECTORY = "control";
    public static final String STORAGE_SELECTION_DIRECTORY = "selections";
    public static final String STORAGE_SELECTION_FILES = "others";
    public static final String STORAGE_RESULTS_DIRECTORY = "results";
    public static final String STORAGE_MAPS_DIRECTORY = "maps";
    public static final String STORAGE_RESULT_FILES = "others";
    public static final String STORAGE_CONTROL_SUFFIX = "_co";
    public static final String STORAGE_DELECTED_SUFFIX = "_del";
    public static final String STORAGE_SELECTION_SUFFIX = "_se";

    public static enum ValidationLevel {
        INFO("info"),
        WARNING("warning"),
        ERROR("error"),
        FATAL("fatal");

        protected String xworkContext;

        private ValidationLevel(String xworkContext) {
            this.xworkContext = xworkContext;
        }

        public String getXWorkContext() {
            return this.xworkContext;
        }
    }

    public static enum Category {
        CATCH(I18n.n((String)"coser.business.category.catch", (Object[])new Object[0]), "catch.csv", true),
        STRATA(I18n.n((String)"coser.business.category.strata", (Object[])new Object[0]), "strata.csv", true),
        HAUL(I18n.n((String)"coser.business.category.haul", (Object[])new Object[0]), "haul.csv", true),
        LENGTH(I18n.n((String)"coser.business.category.length", (Object[])new Object[0]), "length.csv", true),
        REFTAX_SPECIES(I18n.n((String)"coser.business.category.reftax.species", (Object[])new Object[0]), "reftaxSpecies.csv", false),
        TYPE_ESPECES(I18n.n((String)"coser.business.category.typeEspece", (Object[])new Object[0]), "codeTypeEspeces.csv", false);

        protected String translationKey;
        protected String storageFileName;
        protected boolean dataCategory;

        private Category(String translationKey, String storageFileName, boolean dataCategory) {
            this.translationKey = translationKey;
            this.storageFileName = storageFileName;
            this.dataCategory = dataCategory;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        public String getStorageFileName() {
            if (this.dataCategory) {
                throw new IllegalStateException("Can't use storageFileName for data category !");
            }
            return this.storageFileName;
        }

        public boolean isDataCategory() {
            return this.dataCategory;
        }
    }
}

