/*
 * #%L
 * Coselmar :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Ifremer, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
var coselmarServices = angular.module('coselmarServices', ['ngResource']);

coselmarServices.factory('documentService', ['$resource', function($resource){
	return new Document($resource);
}]);

function Document(resource){

	this.resource = resource;

	this.createDocument = function(metadata, file, scope){

		var formData = new FormData();
		formData.append("uploadFile", file);
		formData.append("document", JSON.stringify(metadata));
		// Save the document
//		var docResource = resource('http://localhost:8081/services/v1/documents', null, {
		var docResource = resource('v1/documents', null, {
			'upload': {
			  method:'POST',
			  transformRequest: angular.identity,
			  headers:{
				'Content-Type':undefined
			  }
			}
		});
		docResource.upload(formData, function(response){
			//manage result
		});
	}

	this.getDocument = function(id, scope){
		// Load the document
//		var docResource = resource('http://localhost:8081/services/v1/documents/:documentId', {documentId:'@documentId'});
		var docResource = resource('v1/documents/:documentId', {documentId:'@documentId'});
		docResource.get({documentId:id}, function(document){
		console.log(document);
			scope.document = document;
		});
	}

	this.deleteDocument = function(id, scope, successFunction){

		// Load the document
//		var docResource = resource('http://localhost:8081/services/v1/documents/:documentId', {documentId:'@id'});
		var docResource = resource('v1/documents/:documentId', {documentId:'@documentId'});
		docResource.delete({documentId:id}, successFunction);
	}

	this.getDocumentFile = function(id, scope){
		// Load the document
		var docResource = resource('http://localhost:8081/services/v1/documents/:documentId/file', {documentId:'@documentId'});
//		var docResource = resource('v1/documents/:documentId/file', {documentId:'@documentId'});
		docResource.get({documentId:id}, function(file){
			// redirect to document page ?
		});
	}

	this.getDocuments = function(scope){
		// Load all documents
		console.log("loading all documents");

//		var docResource = resource('http://localhost:8081/services/v1/documents', {searchKeywords : scope.searchKeywords});
		var docResource = resource('v1/documents', {searchKeywords : scope.searchKeywords});
		docResource.query(function(documents){
			scope.documents = documents;
		}, function(errorResult) {
			// let's log errors
			if(errorResult.status === 404) {
				console.log("Service unreachable dis donc !");
			} else {
				console.log("WTF ?!?");
			}
		});
	}
};