/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: VradiDataProvider.java 1715 2010-10-27 19:21:28Z tchemit $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.4.0/vradi-swing/src/main/java/com/jurismarches/vradi/ui/tree/VradiDataProvider.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.tree;

import jaxx.runtime.swing.nav.NavDataProvider;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyProxy;

import com.jurismarches.vradi.services.VradiDataService;
import com.jurismarches.vradi.services.VradiService;

/**
 * Provider de données pour les noeuds des arbres.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.4
 */
public class VradiDataProvider implements NavDataProvider {

    /** Logger */
    static private final Log log = LogFactory.getLog(VradiDataProvider.class);

    /** Wikitty proxy. */
    protected WikittyProxy proxy;

    /** Vradi data service. */
    protected VradiDataService dataService;

    public VradiDataProvider() {
        this.proxy = VradiService.getWikittyProxy();
        this.dataService = VradiService.getVradiDataService();
    }

    /**
     * Get wikitty proxy.
     * 
     * @return
     */
    public WikittyProxy getWikittyProxy() {
        return proxy;
    }

    /**
     * Get vradi data service.
     * 
     * @return
     */
    public VradiDataService getVradiDataService() {
        return dataService;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}
