/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.offer.editors;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.entities.FieldTypeEnum;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.editors.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class CurrencyEditor extends com.jurismarches.vradi.ui.offer.editors.VradiEditor<String, CurrencyEditorModel> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_MODEL = "model";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CURRENCY_COMBO_BOX_SELECTED_ITEM = "currencyComboBox.selectedItem";
    public static final String BINDING_EDITOR_MODEL = "editor.model";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK2Vz08TQRTHXysFyg/5FQhGSEBRb1sverAEkGojpCChxhB7cdod6JDdnXF+wNaD8U/wT9C7FxNvnowHzx68GP8FYzx4Nb7Z7Q/QqoS1h91m5r3P+743782+/AIZJWF+n4ShI02gmU+d9Zs7O3er+7Smb1FVk0xoLiH+pdKQrsCg215XGi5WStY913TPFbgveECDI975Egwo3fCoqlOqNcwe96gplSu3t/OhMLJFbYvqRn3+7Wv6mfv0RRogFKjOpjL3L69OJj0lSDNXwzhGOiA5jwR7KEOyYA/1Dtu1gkeU2iQ+fQRPoK8EvYJIhGm4cPKUI0bkHwoNwwv3JXHZbZehzVUN12vcd/aNZMonslanyjmw+45hDt/dpdKhkaVyCkZi6Foj9hQiQvZqyPjcpZ6G/OlAG9a7QxuOrQo80FGe47YKoaMOsSjO+hYJjhr3xsYaLh+reWwc7zmbxq9SGceybiNt79FaUwgWr8pXeahh8li01nrTTcL5Y2GwaZxO03RONVWBjDS4rGG68nufbeNW3GHTv3SYBUa7P6YmPr75/LrYaqsxjD3Z1fTIVOBxC8kFlZrZ0CNxTxnNvNwGEfkKZBX1cKSikZnpIqzc3EZxGG/MujvW3blDVB0Rmb5Pb99NPfxwBtJFGPA4cYvE2q9BVtclVoF7biiWVyJFQ4f9+By12vCcPNLgBk/z7KJLNJmrssDFCi+FWISZLkVoK6lm33+fKL9aaRUihcLO/dG8U4zMA+hlgccCGk1Yc3i6TtSgUNS4vDMk3cYmZd+jotl5s9FzvlumWWI03+LCCGuyEBr7uhQpt/+uRKCJE4B6qpQECRmDPgmZb/wye0wTo1jwn1DxfZEQko0g9xoiqZr+5sw08KpZjFtmjmi8g6tG06XTc0dwHA6jRljFxudJjzJrcdtUUZ00X6NoEWc3KacPOWW2lywvu3ztL4SpExFuJCYsJyJgUfEz4lJJZULOUHxDU3dNU/8frJ9a+VvBOQkAAA==";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.offer.editors.CurrencyEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JComboBox currencyComboBox;
    protected jaxx.runtime.swing.editor.NumberEditor editor;
    protected com.jurismarches.vradi.ui.offer.editors.CurrencyEditorModel model;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private CurrencyEditor $VradiEditor0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void init() {
        super.init();
        editor.init();
    }
    
    @Override
    void registerValidator() {
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CurrencyEditor() {
        super();
        $initialize();
    }

    public CurrencyEditor(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__currencyComboBox(java.awt.event.ActionEvent event) {
        if(currencyComboBox.getSelectedItem() != null)                    {model.setCurrency(currencyComboBox.getSelectedItem().toString());};
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JComboBox getCurrencyComboBox() {
        return currencyComboBox;
    }

    public jaxx.runtime.swing.editor.NumberEditor getEditor() {
        return editor;
    }

    public com.jurismarches.vradi.ui.offer.editors.CurrencyEditorModel getModel() {
        return model;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setModel(com.jurismarches.vradi.ui.offer.editors.CurrencyEditorModel newValue) {
        com.jurismarches.vradi.ui.offer.editors.CurrencyEditorModel oldValue = this.model;
        this.model = newValue;
        firePropertyChange(PROPERTY_MODEL, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditorContent() {
        if (!allComponentsCreated) {
            return;
        }
        editorContent.add(editor, BorderLayout.WEST);
        editorContent.add(currencyComboBox, BorderLayout.CENTER);
    }

    protected void createCurrencyComboBox() {
        $objectMap.put("currencyComboBox", currencyComboBox = new javax.swing.JComboBox());
        
        currencyComboBox.setName("currencyComboBox");
        currencyComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__currencyComboBox"));
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new jaxx.runtime.swing.editor.NumberEditor());
        
        editor.setName("editor");
        editor.setProperty("amount");
    }

    @Override
    protected void createEditorContent() {
        super.createEditorContent();
        editorContent.setName("editorContent");
        ((javax.swing.JPanel) editorContent).setLayout(new BorderLayout());
    }

    protected void createModel() {
        $objectMap.put("model", model = new CurrencyEditorModel());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToEditorContent();
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 14 property setters
        editor.setAutoPopup(true);
        editor.setBean(model);
        editor.setMaximumSize(new Dimension(Integer.MAX_VALUE,28));
        editor.setMinimumSize(new Dimension(0,28));
        editor.setModelType(Float.class);
        editor.setShowPopupButton(true);
        editor.setShowReset(true);
        editor.setUseFloat(true);
        editor.setUseSign(false);
        currencyComboBox.setMaximumSize(new Dimension(Integer.MAX_VALUE,28));
        currencyComboBox.setMinimumSize(new Dimension(0,28));
        currencyComboBox.setModel(new DefaultComboBoxModel(FieldTypeEnum.Currency.values()));
        currencyComboBox.setRenderer(UIHelper.getTranslationListCellRenderer());
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$VradiEditor0", this);
        createModel();
        createEditor();
        createCurrencyComboBox();
        // inline creation of $VradiEditor0
        setName("$VradiEditor0");
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("amount", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editor.setModel(model.getAmount());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("amount", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CURRENCY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("currency", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    currencyComboBox.setSelectedItem(FieldTypeEnum.getCurrency(model.getCurrency()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("currency", this);
                }
            }
        });
    }

}