/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.offer;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.*;
import com.jurismarches.vradi.ui.offer.editors.*;
import com.jurismarches.vradi.ui.offer.widgets.AttachmentFileHandler;
import com.jurismarches.vradi.ui.offer.widgets.EmbeddedFileHandler;
import com.jurismarches.vradi.ui.offer.widgets.MultipleSelectionPane;
import com.jurismarches.vradi.ui.offer.widgets.RelatedFormHandler;
import com.jurismarches.vradi.ui.offer.widgets.ReplaceFormHandler;
import com.jurismarches.vradi.ui.renderers.ThesaurusHighlighter;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.OneClicListSelectionModel;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class OfferEditUI extends javax.swing.JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_DATA = "data";
    public static final String PROPERTY_VALIDE = "valide";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ATTACHMENT_FILE_PANE_BEAN = "attachmentFilePane.bean";
    public static final String BINDING_COUNTRY_EDITOR_VALUE = "countryEditor.value";
    public static final String BINDING_DATE_PEREMEPTION_EDITOR_VALUE = "datePeremeptionEditor.value";
    public static final String BINDING_DATE_PUB_EDITOR_VALUE = "datePubEditor.value";
    public static final String BINDING_DEPARTMENT_EDITOR_VALUE = "departmentEditor.value";
    public static final String BINDING_DESCRIPTION_EDITOR_VALUE = "descriptionEditor.value";
    public static final String BINDING_EMBEDDED_FILE_PANE_BEAN = "embeddedFilePane.bean";
    public static final String BINDING_ENTITY_EDITOR_VALUE = "entityEditor.value";
    public static final String BINDING_ID_EDITOR_VALUE = "idEditor.value";
    public static final String BINDING_OBJET_EDITOR_VALUE = "objetEditor.value";
    public static final String BINDING_PROPOSITION_LIST_SELECTION_MODEL = "propositionList.selectionModel";
    public static final String BINDING_RELATED_FORM_PANE_BEAN = "relatedFormPane.bean";
    public static final String BINDING_REPLACE_FORM_PANE_BEAN = "replaceFormPane.bean";
    public static final String BINDING_SOURCE_TEXT_EDITOR_VALUE = "sourceTextEditor.value";
    public static final String BINDING_SOURCE_URLEDITOR_VALUE = "sourceURLEditor.value";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.offer.OfferEditUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table actionPanel;
    protected javax.swing.JButton annuler;
    protected com.jurismarches.vradi.ui.offer.widgets.MultipleSelectionPane< File > attachmentFilePane;
    protected javax.swing.JPanel content;
    protected com.jurismarches.vradi.ui.offer.editors.StringEditor countryEditor;
    protected com.jurismarches.vradi.entities.Form data;
    protected com.jurismarches.vradi.ui.offer.editors.DateTimeEditor datePeremeptionEditor;
    protected com.jurismarches.vradi.ui.offer.editors.DateTimeEditor datePubEditor;
    protected com.jurismarches.vradi.ui.offer.editors.StringEditor departmentEditor;
    protected com.jurismarches.vradi.ui.offer.editors.TextEditor descriptionEditor;
    protected com.jurismarches.vradi.ui.offer.widgets.MultipleSelectionPane< File > embeddedFilePane;
    protected com.jurismarches.vradi.ui.offer.editors.StringEditor entityEditor;
    protected jaxx.runtime.validator.swing.SwingValidatorMessageTableModel errorEditorTable;
    protected javax.swing.JButton findQueriesButton;
    protected jaxx.runtime.swing.Table formContentPane;
    protected javax.swing.JPanel formPane;
    protected javax.swing.JScrollPane formScrollPane;
    protected javax.swing.JSplitPane formSplitPane;
    protected com.jurismarches.vradi.ui.offer.editors.IdEditor idEditor;
    protected jaxx.runtime.swing.HBox lastModified;
    protected com.jurismarches.vradi.ui.offer.editors.StringEditor objetEditor;
    protected javax.swing.JSplitPane offerEdit;
    protected OfferEditUI offerEditUI = this;
    protected javax.swing.JList propositionList;
    protected javax.swing.DefaultListModel propositionListModel;
    protected com.jurismarches.vradi.ui.offer.widgets.MultipleSelectionPane< FormLink > relatedFormPane;
    protected com.jurismarches.vradi.ui.offer.widgets.MultipleSelectionPane< FormLink > replaceFormPane;
    protected com.jurismarches.vradi.ui.offer.editors.StringEditor sourceTextEditor;
    protected com.jurismarches.vradi.ui.offer.editors.UrlEditor sourceURLEditor;
    protected javax.swing.JPanel statusButtonPanel;
    protected javax.swing.JPanel thesaurus;
    protected java.lang.Boolean valide;
    protected javax.swing.JButton viewPDF;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JSplitPane $JSplitPane0;
    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JSplitPane $JSplitPane1;
    private jaxx.runtime.swing.Table $Table1;
    private jaxx.runtime.swing.Table $Table2;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.JLabel $JLabel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public OfferEditHandler getHandler() {
        return getContextValue(OfferEditHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
        if(data != null && data.getCreationDate() != null) {
            String creationDateText = String.format(_("vradi.entity.creation.date"),
                    data.getCreationDate());
            lastModified.add(new JLabel(creationDateText));
    
            if (data.getExtensionNames().contains(ModificationTag.EXT_MODIFICATIONTAG)) {
                // get modification info
                ModificationTag formTag = VradiService.getWikittyProxy().cast(data, ModificationTag.class);
                Object date = formTag.getLastModified();
                Object user = formTag.getLastModifier();
                if (date != null && user != null) {
                    String lastModifiedText = String.format(_("vradi.entity.lastModified.date.user"), date, user);
                    lastModified.add(new JLabel(lastModifiedText));
                }
            }
        }
        setContextValue(errorEditorTable, "errorEditorTable");
        formScrollPane.getVerticalScrollBar().setBlockIncrement(100);
        formScrollPane.getVerticalScrollBar().setUnitIncrement(50);
        formSplitPane.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                resize();
            }
        });
    }
    
    public void resize(){
        Dimension dimension = formContentPane.getSize();
        dimension.setSize(formSplitPane.getDividerLocation() - 20, formContentPane.getHeight());
        formContentPane.setPreferredSize(dimension);
        formContentPane.revalidate();
    }
    
    public void updateThesaurusSize(){
        double total = getSize().getWidth();
        Component[] thesPanels = thesaurus.getComponents();
        double width = total / thesPanels.length;
        for (Component c : thesPanels){
            ThesaurusUI thesaurus = (ThesaurusUI)c;
            Dimension d = thesaurus.getSize();
            if (log.isDebugEnabled()){
                log.debug("Resizing total width : " + total + " thesaurus width : " + width);
            }
            d.setSize(width, d.getHeight());
            thesaurus.setPreferredSize(d);
        }
        validate();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public OfferEditUI() {
        $initialize();
    }

    public OfferEditUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__findQueriesButton(java.awt.event.ActionEvent event) {
        getHandler().findQueries(this);
    }

    public void doActionPerformed__on__viewPDF(java.awt.event.ActionEvent event) {
        getHandler().viewInPDF(this);
    }

    public void doComponentResized__on__formScrollPane(java.awt.event.ComponentEvent event) {
        resize();
    }

    public void doTableChanged__on__errorEditorTable(javax.swing.event.TableModelEvent event) {
        setValide(errorEditorTable.getRowCount()==0);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.swing.Table getActionPanel() {
        return actionPanel;
    }

    public javax.swing.JButton getAnnuler() {
        return annuler;
    }

    public com.jurismarches.vradi.ui.offer.widgets.MultipleSelectionPane< File > getAttachmentFilePane() {
        return attachmentFilePane;
    }

    public javax.swing.JPanel getContent() {
        return content;
    }

    public com.jurismarches.vradi.ui.offer.editors.StringEditor getCountryEditor() {
        return countryEditor;
    }

    public com.jurismarches.vradi.entities.Form getData() {
        return data;
    }

    public com.jurismarches.vradi.ui.offer.editors.DateTimeEditor getDatePeremeptionEditor() {
        return datePeremeptionEditor;
    }

    public com.jurismarches.vradi.ui.offer.editors.DateTimeEditor getDatePubEditor() {
        return datePubEditor;
    }

    public com.jurismarches.vradi.ui.offer.editors.StringEditor getDepartmentEditor() {
        return departmentEditor;
    }

    public com.jurismarches.vradi.ui.offer.editors.TextEditor getDescriptionEditor() {
        return descriptionEditor;
    }

    public com.jurismarches.vradi.ui.offer.widgets.MultipleSelectionPane< File > getEmbeddedFilePane() {
        return embeddedFilePane;
    }

    public com.jurismarches.vradi.ui.offer.editors.StringEditor getEntityEditor() {
        return entityEditor;
    }

    public jaxx.runtime.validator.swing.SwingValidatorMessageTableModel getErrorEditorTable() {
        return errorEditorTable;
    }

    public javax.swing.JButton getFindQueriesButton() {
        return findQueriesButton;
    }

    public jaxx.runtime.swing.Table getFormContentPane() {
        return formContentPane;
    }

    public javax.swing.JPanel getFormPane() {
        return formPane;
    }

    public javax.swing.JScrollPane getFormScrollPane() {
        return formScrollPane;
    }

    public javax.swing.JSplitPane getFormSplitPane() {
        return formSplitPane;
    }

    public com.jurismarches.vradi.ui.offer.editors.IdEditor getIdEditor() {
        return idEditor;
    }

    public jaxx.runtime.swing.HBox getLastModified() {
        return lastModified;
    }

    public com.jurismarches.vradi.ui.offer.editors.StringEditor getObjetEditor() {
        return objetEditor;
    }

    public javax.swing.JSplitPane getOfferEdit() {
        return offerEdit;
    }

    public javax.swing.JList getPropositionList() {
        return propositionList;
    }

    public javax.swing.DefaultListModel getPropositionListModel() {
        return propositionListModel;
    }

    public com.jurismarches.vradi.ui.offer.widgets.MultipleSelectionPane< FormLink > getRelatedFormPane() {
        return relatedFormPane;
    }

    public com.jurismarches.vradi.ui.offer.widgets.MultipleSelectionPane< FormLink > getReplaceFormPane() {
        return replaceFormPane;
    }

    public com.jurismarches.vradi.ui.offer.editors.StringEditor getSourceTextEditor() {
        return sourceTextEditor;
    }

    public com.jurismarches.vradi.ui.offer.editors.UrlEditor getSourceURLEditor() {
        return sourceURLEditor;
    }

    public javax.swing.JPanel getStatusButtonPanel() {
        return statusButtonPanel;
    }

    public javax.swing.JPanel getThesaurus() {
        return thesaurus;
    }

    public java.lang.Boolean getValide() {
        return valide;
    }

    public javax.swing.JButton getViewPDF() {
        return viewPDF;
    }

    public java.lang.Boolean isValide() {
        return valide !=null && valide;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setData(com.jurismarches.vradi.entities.Form newValue) {
        com.jurismarches.vradi.entities.Form oldValue = this.data;
        this.data = newValue;
        firePropertyChange(PROPERTY_DATA, oldValue, newValue);
    }

    public void setValide(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.valide;
        this.valide = newValue;
        firePropertyChange(PROPERTY_VALIDE, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JSplitPane get$JSplitPane0() {
        return $JSplitPane0;
    }

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JSplitPane get$JSplitPane1() {
        return $JSplitPane1;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected jaxx.runtime.swing.Table get$Table2() {
        return $Table2;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToActionPanel() {
        if (!allComponentsCreated) {
            return;
        }
        actionPanel.add(statusButtonPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        actionPanel.add(lastModified, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        actionPanel.add(annuler, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        actionPanel.add(findQueriesButton, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        actionPanel.add(viewPDF, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToFormContentPane() {
        if (!allComponentsCreated) {
            return;
        }
        formContentPane.add(objetEditor, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        formContentPane.add(idEditor, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        formContentPane.add(entityEditor, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        formContentPane.add(countryEditor, new GridBagConstraints(0, 2, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        formContentPane.add(departmentEditor, new GridBagConstraints(1, 2, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        formContentPane.add(datePubEditor, new GridBagConstraints(0, 3, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        formContentPane.add(datePeremeptionEditor, new GridBagConstraints(1, 3, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        formContentPane.add(sourceTextEditor, new GridBagConstraints(0, 4, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        formContentPane.add(sourceURLEditor, new GridBagConstraints(1, 4, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        formContentPane.add(content, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        formContentPane.add(descriptionEditor, new GridBagConstraints(0, 6, 2, 1, 1.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToFormPane() {
        if (!allComponentsCreated) {
            return;
        }
        formPane.add(formScrollPane, BorderLayout.CENTER);
    }

    protected void addChildrenToFormScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        formScrollPane.getViewport().add(formContentPane);
    }

    protected void addChildrenToFormSplitPane() {
        if (!allComponentsCreated) {
            return;
        }
        formSplitPane.add(formPane, JSplitPane.LEFT);
        formSplitPane.add($JSplitPane0, JSplitPane.RIGHT);
    }

    protected void addChildrenToOfferEdit() {
        if (!allComponentsCreated) {
            return;
        }
        offerEdit.add(formSplitPane, JSplitPane.LEFT);
        offerEdit.add(thesaurus, JSplitPane.RIGHT);
    }

    protected void addChildrenToOfferEditUI() {
        if (!allComponentsCreated) {
            return;
        }
        add(offerEdit, BorderLayout.CENTER);
        add(actionPanel, BorderLayout.SOUTH);
    }

    protected void addChildrenToStatusButtonPanel() {
        if (!allComponentsCreated) {
            return;
        }
        statusButtonPanel.add($JLabel1);
    }

    protected void createActionPanel() {
        $objectMap.put("actionPanel", actionPanel = new jaxx.runtime.swing.Table());
        
        actionPanel.setName("actionPanel");
    }

    protected void createAnnuler() {
        $objectMap.put("annuler", annuler = new javax.swing.JButton());
        
        annuler.setName("annuler");
        annuler.setText(_("vradi.action.cancel"));
    }

    protected void createAttachmentFilePane() {
        $objectMap.put("attachmentFilePane", attachmentFilePane = new com.jurismarches.vradi.ui.offer.widgets.MultipleSelectionPane< File >());
        
        attachmentFilePane.setName("attachmentFilePane");
    }

    protected void createContent() {
        $objectMap.put("content", content = new javax.swing.JPanel());
        
        content.setName("content");
        content.setLayout(new BoxLayout(content, BoxLayout.Y_AXIS));
        content.setVisible(false);
    }

    protected void createCountryEditor() {
        $objectMap.put("countryEditor", countryEditor = new com.jurismarches.vradi.ui.offer.editors.StringEditor());
        
        countryEditor.setName("countryEditor");
    }

    protected void createData() {
        $objectMap.put("data", data = getContextValue(Form.class));
    }

    protected void createDatePeremeptionEditor() {
        $objectMap.put("datePeremeptionEditor", datePeremeptionEditor = new com.jurismarches.vradi.ui.offer.editors.DateTimeEditor());
        
        datePeremeptionEditor.setName("datePeremeptionEditor");
    }

    protected void createDatePubEditor() {
        $objectMap.put("datePubEditor", datePubEditor = new com.jurismarches.vradi.ui.offer.editors.DateTimeEditor());
        
        datePubEditor.setName("datePubEditor");
    }

    protected void createDepartmentEditor() {
        $objectMap.put("departmentEditor", departmentEditor = new com.jurismarches.vradi.ui.offer.editors.StringEditor());
        
        departmentEditor.setName("departmentEditor");
    }

    protected void createDescriptionEditor() {
        $objectMap.put("descriptionEditor", descriptionEditor = new com.jurismarches.vradi.ui.offer.editors.TextEditor());
        
        descriptionEditor.setName("descriptionEditor");
    }

    protected void createEmbeddedFilePane() {
        $objectMap.put("embeddedFilePane", embeddedFilePane = new com.jurismarches.vradi.ui.offer.widgets.MultipleSelectionPane< File >());
        
        embeddedFilePane.setName("embeddedFilePane");
    }

    protected void createEntityEditor() {
        $objectMap.put("entityEditor", entityEditor = new com.jurismarches.vradi.ui.offer.editors.StringEditor());
        
        entityEditor.setName("entityEditor");
    }

    protected void createErrorEditorTable() {
        $objectMap.put("errorEditorTable", errorEditorTable = new jaxx.runtime.validator.swing.SwingValidatorMessageTableModel());
        
        errorEditorTable.addTableModelListener(JAXXUtil.getEventListener(TableModelListener.class, "tableChanged", this, "doTableChanged__on__errorEditorTable"));
    }

    protected void createFindQueriesButton() {
        $objectMap.put("findQueriesButton", findQueriesButton = new javax.swing.JButton());
        
        findQueriesButton.setName("findQueriesButton");
        findQueriesButton.setText(_("vradi.offerEdit.affectedQueries"));
        findQueriesButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__findQueriesButton"));
    }

    protected void createFormContentPane() {
        $objectMap.put("formContentPane", formContentPane = new jaxx.runtime.swing.Table());
        
        formContentPane.setName("formContentPane");
    }

    protected void createFormPane() {
        $objectMap.put("formPane", formPane = new javax.swing.JPanel());
        
        formPane.setName("formPane");
        formPane.setLayout(new BorderLayout());
    }

    protected void createFormScrollPane() {
        $objectMap.put("formScrollPane", formScrollPane = new javax.swing.JScrollPane());
        
        formScrollPane.setName("formScrollPane");
        formScrollPane.addComponentListener(JAXXUtil.getEventListener(ComponentListener.class, "componentResized", this, "doComponentResized__on__formScrollPane"));
    }

    protected void createFormSplitPane() {
        $objectMap.put("formSplitPane", formSplitPane = new javax.swing.JSplitPane());
        
        formSplitPane.setName("formSplitPane");
        formSplitPane.setContinuousLayout(true);
        formSplitPane.setDividerLocation(750);
        formSplitPane.setOneTouchExpandable(true);
        formSplitPane.setResizeWeight(0.8);
        formSplitPane.setDividerSize(12);
    }

    protected void createIdEditor() {
        $objectMap.put("idEditor", idEditor = new com.jurismarches.vradi.ui.offer.editors.IdEditor());
        
        idEditor.setName("idEditor");
    }

    protected void createLastModified() {
        $objectMap.put("lastModified", lastModified = new jaxx.runtime.swing.HBox());
        
        lastModified.setName("lastModified");
        lastModified.setHorizontalAlignment(4);
    }

    protected void createObjetEditor() {
        $objectMap.put("objetEditor", objetEditor = new com.jurismarches.vradi.ui.offer.editors.StringEditor());
        
        objetEditor.setName("objetEditor");
    }

    protected void createOfferEdit() {
        $objectMap.put("offerEdit", offerEdit = new javax.swing.JSplitPane());
        
        offerEdit.setName("offerEdit");
        offerEdit.setOneTouchExpandable(true);
        offerEdit.setResizeWeight(0.3);
        offerEdit.setContinuousLayout(true);
        offerEdit.setDividerSize(12);
    }

    protected void createPropositionList() {
        $objectMap.put("propositionList", propositionList = new javax.swing.JList());
        
        propositionList.setName("propositionList");
    }

    protected void createPropositionListModel() {
        $objectMap.put("propositionListModel", propositionListModel = new javax.swing.DefaultListModel());
    }

    protected void createRelatedFormPane() {
        $objectMap.put("relatedFormPane", relatedFormPane = new com.jurismarches.vradi.ui.offer.widgets.MultipleSelectionPane< FormLink >());
        
        relatedFormPane.setName("relatedFormPane");
    }

    protected void createReplaceFormPane() {
        $objectMap.put("replaceFormPane", replaceFormPane = new com.jurismarches.vradi.ui.offer.widgets.MultipleSelectionPane< FormLink >());
        
        replaceFormPane.setName("replaceFormPane");
    }

    protected void createSourceTextEditor() {
        $objectMap.put("sourceTextEditor", sourceTextEditor = new com.jurismarches.vradi.ui.offer.editors.StringEditor());
        
        sourceTextEditor.setName("sourceTextEditor");
    }

    protected void createSourceURLEditor() {
        $objectMap.put("sourceURLEditor", sourceURLEditor = new com.jurismarches.vradi.ui.offer.editors.UrlEditor());
        
        sourceURLEditor.setName("sourceURLEditor");
    }

    protected void createStatusButtonPanel() {
        $objectMap.put("statusButtonPanel", statusButtonPanel = new javax.swing.JPanel());
        
        statusButtonPanel.setName("statusButtonPanel");
        statusButtonPanel.setLayout(new FlowLayout(FlowLayout.LEADING));
    }

    protected void createThesaurus() {
        $objectMap.put("thesaurus", thesaurus = new javax.swing.JPanel());
        
        thesaurus.setName("thesaurus");
        thesaurus.setLayout(new BoxLayout(thesaurus, BoxLayout.X_AXIS));
    }

    protected void createValide() {
        $objectMap.put("valide", valide = true);
    }

    protected void createViewPDF() {
        $objectMap.put("viewPDF", viewPDF = new javax.swing.JButton());
        
        viewPDF.setName("viewPDF");
        viewPDF.setText(_("vradi.offerEdit.view.pdf"));
        viewPDF.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__viewPDF"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToOfferEditUI();
        addChildrenToOfferEdit();
        addChildrenToFormSplitPane();
        addChildrenToFormPane();
        addChildrenToFormScrollPane();
        addChildrenToFormContentPane();
        // inline complete setup of $JSplitPane0
        $JSplitPane0.add($Table0, JSplitPane.LEFT);
        $JSplitPane0.add($JSplitPane1, JSplitPane.RIGHT);
        // inline complete setup of $Table0
        $Table0.add(relatedFormPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(replaceFormPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        // inline complete setup of $JSplitPane1
        $JSplitPane1.add($Table1, JSplitPane.LEFT);
        $JSplitPane1.add($Table2, JSplitPane.RIGHT);
        // inline complete setup of $Table1
        $Table1.add(attachmentFilePane, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table1.add(embeddedFilePane, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        // inline complete setup of $Table2
        $Table2.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table2.add($JScrollPane0, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(propositionList);
        addChildrenToActionPanel();
        addChildrenToStatusButtonPanel();
        
        // apply 15 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 58 property setters
        offerEdit.setOrientation(JSplitPane.VERTICAL_SPLIT);
        formPane.setMinimumSize(new Dimension(0,0));
        formPane.setPreferredSize(new Dimension(0,0));
        formScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        formContentPane.setPreferredSize(new Dimension(0,0));
        objetEditor.setExtensionFieldName(Form.FIELD_INFOGENE_OBJET);
        objetEditor.setExtensionName(Form.EXT_INFOGENE);
        objetEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.STRING.getFieldType()));
        objetEditor.setFieldName(Form.FIELD_INFOGENE_OBJET);
        idEditor.setExtensionFieldName(Form.FIELD_INFOGENE_ID);
        idEditor.setExtensionName(Form.EXT_INFOGENE);
        idEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.STRING.getFieldType()));
        idEditor.setFieldName(Form.FIELD_INFOGENE_ID);
        entityEditor.setExtensionFieldName(Form.FIELD_INFOGENE_ENTITY);
        entityEditor.setExtensionName(Form.EXT_INFOGENE);
        entityEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.STRING.getFieldType()));
        entityEditor.setFieldName(Form.FIELD_INFOGENE_ENTITY);
        countryEditor.setExtensionFieldName(Form.FIELD_INFOGENE_COUNTRY);
        countryEditor.setExtensionName(Form.EXT_INFOGENE);
        countryEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.STRING.getFieldType()));
        countryEditor.setFieldName(Form.FIELD_INFOGENE_COUNTRY);
        departmentEditor.setExtensionFieldName(Form.FIELD_INFOGENE_DEPARTMENT);
        departmentEditor.setExtensionName(Form.EXT_INFOGENE);
        departmentEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.STRING.getFieldType()));
        departmentEditor.setFieldName(Form.FIELD_INFOGENE_DEPARTMENT);
        datePubEditor.setExtensionFieldName(Form.FIELD_FORM_DATEPUB);
        datePubEditor.setExtensionName(Form.EXT_FORM);
        datePubEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.DATE_TIME.getFieldType()));
        datePubEditor.setFieldName(Form.FIELD_FORM_DATEPUB);
        datePeremeptionEditor.setExtensionFieldName(Form.FIELD_FORM_DATEPEREMPTION);
        datePeremeptionEditor.setExtensionName(Form.EXT_FORM);
        datePeremeptionEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.DATE_TIME.getFieldType()));
        datePeremeptionEditor.setFieldName(Form.FIELD_FORM_DATEPEREMPTION);
        sourceTextEditor.setExtensionFieldName(Form.FIELD_INFOGENE_SOURCETEXT);
        sourceTextEditor.setExtensionName(Form.EXT_INFOGENE);
        sourceTextEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.STRING.getFieldType()));
        sourceTextEditor.setFieldName(Form.FIELD_INFOGENE_SOURCETEXT);
        sourceURLEditor.setExtensionFieldName(Form.FIELD_INFOGENE_SOURCEURL);
        sourceURLEditor.setExtensionName(Form.EXT_INFOGENE);
        sourceURLEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.URL.getFieldType()));
        sourceURLEditor.setFieldName(Form.FIELD_INFOGENE_SOURCEURL);
        descriptionEditor.setExtensionFieldName(Form.FIELD_INFOGENE_DESCRIPTION);
        descriptionEditor.setExtensionName(Form.EXT_INFOGENE);
        descriptionEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.TEXT.getFieldType()));
        descriptionEditor.setFieldName(Form.FIELD_INFOGENE_DESCRIPTION);
        $JSplitPane0.setOrientation(JSplitPane.VERTICAL_SPLIT);
        relatedFormPane.setHandler(new RelatedFormHandler(relatedFormPane));
        replaceFormPane.setHandler(new ReplaceFormHandler(replaceFormPane));
        $JSplitPane1.setOrientation(JSplitPane.VERTICAL_SPLIT);
        attachmentFilePane.setHandler(new AttachmentFileHandler(attachmentFilePane));
        embeddedFilePane.setHandler(new EmbeddedFileHandler(embeddedFilePane));
        propositionList.setCellRenderer(new ThesaurusHighlighter(ThesaurusHighlighter.HighlighterType.PROPOSITION));
        propositionList.setModel(getPropositionListModel());
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("offerEditUI", this);
        createData();
        createPropositionListModel();
        createValide();
        createErrorEditorTable();
        createOfferEdit();
        createFormSplitPane();
        createFormPane();
        createFormScrollPane();
        createFormContentPane();
        createObjetEditor();
        createIdEditor();
        createEntityEditor();
        createCountryEditor();
        createDepartmentEditor();
        createDatePubEditor();
        createDatePeremeptionEditor();
        createSourceTextEditor();
        createSourceURLEditor();
        createContent();
        createDescriptionEditor();
        // inline creation of $JSplitPane0
        $objectMap.put("$JSplitPane0", $JSplitPane0 = new javax.swing.JSplitPane());
        
        $JSplitPane0.setName("$JSplitPane0");
        $JSplitPane0.setOneTouchExpandable(true);
        $JSplitPane0.setResizeWeight(0.8);
        $JSplitPane0.setContinuousLayout(true);
        $JSplitPane0.setDividerSize(12);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        createRelatedFormPane();
        createReplaceFormPane();
        // inline creation of $JSplitPane1
        $objectMap.put("$JSplitPane1", $JSplitPane1 = new javax.swing.JSplitPane());
        
        $JSplitPane1.setName("$JSplitPane1");
        $JSplitPane1.setOneTouchExpandable(true);
        $JSplitPane1.setResizeWeight(0.8);
        $JSplitPane1.setContinuousLayout(true);
        $JSplitPane1.setDividerSize(12);
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new jaxx.runtime.swing.Table());
        
        $Table1.setName("$Table1");
        createAttachmentFilePane();
        createEmbeddedFilePane();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new jaxx.runtime.swing.Table());
        
        $Table2.setName("$Table2");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.edit.proposition"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createPropositionList();
        createThesaurus();
        createActionPanel();
        createStatusButtonPanel();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.status.validate"));
        createLastModified();
        createAnnuler();
        createFindQueriesButton();
        createViewPDF();
        // inline creation of offerEditUI
        setName("offerEditUI");
        setLayout(new BorderLayout());
        
        // registers 15 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 15 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_OBJET_EDITOR_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (data != null) {
                    data.addPropertyChangeListener("objet", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (data != null) {
                    objetEditor.setValue(data.getObjet());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (data != null) {
                    data.removePropertyChangeListener("objet", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ID_EDITOR_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (data != null) {
                    data.addPropertyChangeListener("id", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (data != null) {
                    idEditor.setValue(data.getId());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (data != null) {
                    data.removePropertyChangeListener("id", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ENTITY_EDITOR_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (data != null) {
                    data.addPropertyChangeListener("entity", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (data != null) {
                    entityEditor.setValue(data.getEntity());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (data != null) {
                    data.removePropertyChangeListener("entity", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COUNTRY_EDITOR_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (data != null) {
                    data.addPropertyChangeListener("country", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (data != null) {
                    countryEditor.setValue(data.getCountry());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (data != null) {
                    data.removePropertyChangeListener("country", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DEPARTMENT_EDITOR_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (data != null) {
                    data.addPropertyChangeListener("department", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (data != null) {
                    departmentEditor.setValue(data.getDepartment());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (data != null) {
                    data.removePropertyChangeListener("department", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DATE_PUB_EDITOR_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (data != null) {
                    data.addPropertyChangeListener("datePub", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (data != null) {
                    datePubEditor.setValue(data.getDatePub());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (data != null) {
                    data.removePropertyChangeListener("datePub", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DATE_PEREMEPTION_EDITOR_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (data != null) {
                    data.addPropertyChangeListener("datePeremption", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (data != null) {
                    datePeremeptionEditor.setValue(data.getDatePeremption());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (data != null) {
                    data.removePropertyChangeListener("datePeremption", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SOURCE_TEXT_EDITOR_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (data != null) {
                    data.addPropertyChangeListener("sourceText", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (data != null) {
                    sourceTextEditor.setValue(data.getSourceText());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (data != null) {
                    data.removePropertyChangeListener("sourceText", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SOURCE_URLEDITOR_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (data != null) {
                    data.addPropertyChangeListener("sourceURL", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (data != null) {
                    sourceURLEditor.setValue(data.getSourceURL());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (data != null) {
                    data.removePropertyChangeListener("sourceURL", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DESCRIPTION_EDITOR_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (data != null) {
                    data.addPropertyChangeListener("description", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (data != null) {
                    descriptionEditor.setValue(data.getDescription());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (data != null) {
                    data.removePropertyChangeListener("description", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RELATED_FORM_PANE_BEAN, true ,"data") {
        
            @Override
            public void processDataBinding() {
                relatedFormPane.setBean(getData());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REPLACE_FORM_PANE_BEAN, true ,"data") {
        
            @Override
            public void processDataBinding() {
                replaceFormPane.setBean(getData());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ATTACHMENT_FILE_PANE_BEAN, true ,"data") {
        
            @Override
            public void processDataBinding() {
                attachmentFilePane.setBean(getData());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EMBEDDED_FILE_PANE_BEAN, true ,"data") {
        
            @Override
            public void processDataBinding() {
                embeddedFilePane.setBean(getData());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROPOSITION_LIST_SELECTION_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (propositionList != null) {
                    propositionList.addPropertyChangeListener("selectionModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (propositionList != null) {
                    propositionList.setSelectionModel(new OneClicListSelectionModel(propositionList.getSelectionModel(), propositionListModel));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (propositionList != null) {
                    propositionList.removePropertyChangeListener("selectionModel", this);
                }
            }
        });
    }

}