/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: EmailEntityModel.java 1789 2010-11-16 15:18:03Z sletellier $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.4.0/vradi-swing/src/main/java/com/jurismarches/vradi/ui/email/models/EmailEntityModel.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.email.models;

import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.Session;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.email.renderers.EmailFormsListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceEvent;
import org.nuiton.wikitty.WikittyServiceListener;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author letellier
 */
public abstract class EmailEntityModel<E extends BusinessEntity> extends DefaultListModel implements WikittyServiceListener {

    /**
     * Logger
     */
    private static final Log log = LogFactory.getLog(EmailEntityModel.class);

    protected EmailFormsListCellRenderer renderer;
    protected Map<String, E> datas;
    protected Session session;
    protected Form form;

    public EmailEntityModel(EmailFormsListCellRenderer renderer, Session session, Form form){
        this.renderer = renderer;
        datas = new HashMap<String, E>();
        this.session = session;
        this.form = form;

        updateModel(session, form);

        // register each tree on wikitty service
        VradiService.getWikittyService().addWikittyServiceListener(this, WikittyService.ServiceListenerType.REMOTE);
    }

    @Override
    public int getSize() {
        return datas.size();
    }

    public abstract void updateModel(Session session, Form form);

    @Override
    public Object getElementAt(int index) {
        List<String> keys = new ArrayList<String>(datas.keySet());
        return datas.get(keys.get(index));
    }

    protected void updateDatas(List<E> datas){
        if (datas == null) {
            return;
        }
//        datas.clear();
        for (E data : datas) {
            if (data != null) {
                this.datas.put(data.getWikittyId(), data);
            }
        }
        fireContentsChanged(this, 0, getSize());
    }

    protected void refresh() {
        if (log.isDebugEnabled()) {
            log.debug("Refresh datas");
        }

        SwingUtilities.invokeLater(new Thread() {

            @Override
            public void run() {
                session = VradiService.getWikittyProxy().restore(Session.class, session.getWikittyId());
                renderer.updateDatas(session, form.getWikittyId());
                updateModel(session, form);
            }
        });
    }

    @Override
    public void putWikitty(WikittyServiceEvent event) {

        // map between id and extensions "name" (not extension ids)
        Map<String, Set<String>> idAndExtensions = event.getIdExtensions();
        if (idAndExtensions != null) {
            boolean mustBeRefresh = false;
            for (String wikittyId : event.getIds()) {
                Set<String> wikittyExtensions = idAndExtensions.get(wikittyId);
                if (wikittyExtensions.contains(Sending.EXT_SENDING)) {

                    if (log.isDebugEnabled()) {
                        log.debug("Receive wikitty service put event : " + event);
                    }

                    Session restoredSession = VradiService.getVradiDataService().getSessionBySending(wikittyId);
                    if (restoredSession.equals(session)) {
                        mustBeRefresh = true;
                    }
                }
            }
            if (mustBeRefresh) {
                refresh();
            }
        }
    }

    @Override
    public void removeWikitty(WikittyServiceEvent event) {

        // map between id and extensions "name" (not extension ids)
        Map<String, Set<String>> idAndExtensions = event.getIdExtensions();
        if (idAndExtensions != null) {

            boolean mustBeRefresh = false;
            for (String wikittyId : event.getIds()) {
                Set<String> wikittyExtensions = idAndExtensions.get(wikittyId);
                if (wikittyExtensions.contains(Sending.EXT_SENDING)) {

                    if (log.isDebugEnabled()) {
                        log.debug("Receive wikitty service remove event : " + event);
                    }
                    Session restoredSession = VradiService.getVradiDataService().getSessionBySending(wikittyId);
                    if (restoredSession.equals(session)) {
                        mustBeRefresh = true;
                    }
                }
            }
            if (mustBeRefresh) {
                refresh();
            }
        }
    }

    @Override
    public void clearWikitty(WikittyServiceEvent event) {
    }

    @Override
    public void putExtension(WikittyServiceEvent event) {
    }

    @Override
    public void removeExtension(WikittyServiceEvent event) {
    }

    @Override
    public void clearExtension(WikittyServiceEvent event) {
    }
}
