/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.admin.helpers.AdminBeanConstant;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.text.DateFormat;
import java.util.*;
import java.util.Date;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.HidorButton;
import jaxx.runtime.swing.ListSelectorUI;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.SwingUtil.getStringValue;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminClientUI extends com.jurismarches.vradi.ui.admin.AdminContentUI<Client> implements jaxx.runtime.JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_IN_GROUP = "inGroup";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CLIENT_ADDRESS_TEXT = "clientAddress.text";
    public static final String BINDING_CLIENT_CONTACT_TEXT = "clientContact.text";
    public static final String BINDING_CLIENT_NAME_TEXT = "clientName.text";
    public static final String BINDING_CLIENT_PHONE_TEXT = "clientPhone.text";
    public static final String BINDING_CREATE_BUTTON_ENABLED = "createButton.enabled";
    public static final String BINDING_CREATE_BUTTON_VISIBLE = "createButton.visible";
    public static final String BINDING_TITLE_TEXT = "title.text";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$ADMIN_CONTENT_UI0_ENABLED = "$AdminContentUI0.enabled";
    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";
    private static final String BINDING_$JBUTTON0_VISIBLE = "$JButton0.visible";
    private static final String BINDING_$JBUTTON1_ENABLED = "$JButton1.enabled";
    private static final String BINDING_$JBUTTON1_VISIBLE = "$JButton1.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.content.AdminClientUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table adminClientForm;
    protected com.jurismarches.vradi.entities.Client bean;
    protected javax.swing.JTextField clientAddress;
    protected javax.swing.JTextField clientContact;
    protected javax.swing.JTextField clientName;
    protected javax.swing.JTextField clientPhone;
    protected javax.swing.JButton createButton;
    protected java.lang.Boolean inGroup;
    protected javax.swing.JLabel title;
    protected jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.entities.Client > validator;
    protected java.util.List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private AdminClientUI $AdminContentUI0 = this;
    private javax.swing.JPanel $JPanel0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JButton $JButton1;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JButton $JButton2;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JLabel $JLabel3;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
        errorTable.registerValidator(validator);
    }
    
    @Override
    protected void postLoadBean() {
    
        createButton.setEnabled(!isInCreation());
    
        VradiTreeNode parentNode = getHelper().getParentCategoryNode(getHelper().getSelectedNode(), AdminBeanConstant.GROUP.getCategoryName());
        setInGroup(parentNode != null);
    }
    
    @Override
    public void save() {
    
        Client client = getHandler().saveClient(this, getHelper(), bean, null);
    
        //FIXME JC 25/08/2010 bean is the same (because of cache ?) so no property change fired. Set bean to null before to force fire.
        setBean(null);
        setBean(client);
    
    }
    
    @Override
    protected void clearUI() {
        title.setText(updateTitle(""));
        clientName.setText("");
        clientAddress.setText("");
        clientPhone.setText("");
        clientContact.setText("");
    }
    
    protected String updateTitle(String name) {
       return _("vradi.adminClient.title", getStringValue(name));
    }
    
    protected void openAddressInBrowser() {
        UIHelper.openAddressInBrowser(bean.getAddress());
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminClientUI() {
        super();
        $initialize();
    }

    public AdminClientUI(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidation implementation --------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.entities.Client > getValidator() {
        return validator;
    }

    @Override
    public jaxx.runtime.validator.swing.SwingValidator<?> getValidator(String validatorId) {
        return (jaxx.runtime.validator.swing.SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public java.util.List<String> getValidatorIds() {
        return validatorIds;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getHandler().createUser(this, getHelper().getClientSelected());
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        getHandler().delete(this, getHelper(), getBean());
    }

    public void doActionPerformed__on__$JButton2(java.awt.event.ActionEvent event) {
        openAddressInBrowser();
    }

    public void doActionPerformed__on__createButton(java.awt.event.ActionEvent event) {
        getHandler().createClient(this);                                 setModified(true);
    }

    public void doKeyReleased__on__clientAddress(java.awt.event.KeyEvent event) {
        getBean().setAddress(clientAddress.getText());
    }

    public void doKeyReleased__on__clientContact(java.awt.event.KeyEvent event) {
        getBean().setContact(clientContact.getText());
    }

    public void doKeyReleased__on__clientName(java.awt.event.KeyEvent event) {
        getBean().setName(clientName.getText());                                                title.setText(updateTitle(getBean().getName()));
    }

    public void doKeyReleased__on__clientPhone(java.awt.event.KeyEvent event) {
        getBean().setPhone(clientPhone.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.swing.Table getAdminClientForm() {
        return adminClientForm;
    }

    public com.jurismarches.vradi.entities.Client getBean() {
        return bean;
    }

    public javax.swing.JTextField getClientAddress() {
        return clientAddress;
    }

    public javax.swing.JTextField getClientContact() {
        return clientContact;
    }

    public javax.swing.JTextField getClientName() {
        return clientName;
    }

    public javax.swing.JTextField getClientPhone() {
        return clientPhone;
    }

    public javax.swing.JButton getCreateButton() {
        return createButton;
    }

    public java.lang.Boolean getInGroup() {
        return inGroup;
    }

    public javax.swing.JLabel getTitle() {
        return title;
    }

    public java.lang.Boolean isInGroup() {
        return inGroup !=null && inGroup;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(com.jurismarches.vradi.entities.Client newValue) {
        com.jurismarches.vradi.entities.Client oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    public void setInGroup(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.inGroup;
        this.inGroup = newValue;
        firePropertyChange(PROPERTY_IN_GROUP, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerValidatorFields() {
        validator.setFieldRepresentation("name", clientName);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JButton get$JButton2() {
        return $JButton2;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminClientForm() {
        if (!allComponentsCreated) {
            return;
        }
        adminClientForm.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add(SwingUtil.boxComponentWithJxLayer(clientName), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add(clientAddress, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add($JButton2, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add(clientPhone, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add($JLabel3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminClientForm.add(clientContact, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(adminClientForm, BorderLayout.NORTH);
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add(title, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        toolbar.add($JPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(jaxx.runtime.validator.swing.ui.ImageValidationUI.class);
    }

    protected void createAdminClientForm() {
        $objectMap.put("adminClientForm", adminClientForm = new jaxx.runtime.swing.Table());
        
        adminClientForm.setName("adminClientForm");
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createClientAddress() {
        $objectMap.put("clientAddress", clientAddress = new javax.swing.JTextField());
        
        clientAddress.setName("clientAddress");
        clientAddress.setColumns(15);
        clientAddress.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__clientAddress"));
    }

    protected void createClientContact() {
        $objectMap.put("clientContact", clientContact = new javax.swing.JTextField());
        
        clientContact.setName("clientContact");
        clientContact.setColumns(15);
        clientContact.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__clientContact"));
    }

    protected void createClientName() {
        $objectMap.put("clientName", clientName = new javax.swing.JTextField());
        
        clientName.setName("clientName");
        clientName.setColumns(15);
        clientName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__clientName"));
    }

    protected void createClientPhone() {
        $objectMap.put("clientPhone", clientPhone = new javax.swing.JTextField());
        
        clientPhone.setName("clientPhone");
        clientPhone.setColumns(15);
        clientPhone.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__clientPhone"));
    }

    protected void createCreateButton() {
        $objectMap.put("createButton", createButton = new javax.swing.JButton());
        
        createButton.setName("createButton");
        createButton.setText(_("vradi.adminClient.createClient"));
        createButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createButton"));
    }

    protected void createInGroup() {
        $objectMap.put("inGroup", inGroup = null);
    }

    protected void createTitle() {
        $objectMap.put("title", title = new javax.swing.JLabel());
        
        title.setName("title");
        if (title.getFont() != null) {
            title.setFont(title.getFont().deriveFont((float) 20));
        }
        if (title.getFont() != null) {
            title.setFont(title.getFont().deriveFont(title.getFont().getStyle() | Font.BOLD));
        }
    }

    @Override
    protected void createToolbar() {
        super.createToolbar();
        toolbar.setName("toolbar");
        ((jaxx.runtime.swing.Table) toolbar).setLayout(new BoxLayout(toolbar, 0));
        ((jaxx.runtime.swing.Table) toolbar).putClientProperty("help", "ui.main.toolbar");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = new jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.entities.Client >(com.jurismarches.vradi.entities.Client.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToValidator();
        addChildrenToToolbar();
        // inline complete setup of $JPanel0
        $JPanel0.add(createButton);
        $JPanel0.add($JButton0);
        $JPanel0.add($JButton1);
        addChildrenToBody();
        addChildrenToAdminClientForm();
        
        // apply 13 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 8 property setters
        createButton.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("client.add"));
        $JButton1.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("client.delete"));
        adminClientForm.setMinimumSize(SwingUtil.newMinDimension());
        $JButton2.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("site"));
        title.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        title.setHorizontalTextPosition(JLabel.LEFT);
        // late initializer
        // register 1 validator(s)
        registerValidatorFields();validatorIds.add("validator");
        getValidator("validator").installUIs();
        getValidator("validator").reloadBean();
        validatorIds = java.util.Collections.unmodifiableList(validatorIds);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$AdminContentUI0", this);
        createBean();
        createInGroup();
        createValidator();
        createTitle();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        createCreateButton();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.adminClient.createUser"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setToolTipText(_("vradi.adminClient.deleteClient"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        createAdminClientForm();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminClient.name"));
        createClientName();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.adminClient.adresse"));
        createClientAddress();
        // inline creation of $JButton2
        $objectMap.put("$JButton2", $JButton2 = new javax.swing.JButton());
        
        $JButton2.setName("$JButton2");
        $JButton2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton2"));
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("vradi.adminClient.tel"));
        createClientPhone();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new javax.swing.JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("vradi.adminClient.contact"));
        createClientContact();
        // inline creation of $AdminContentUI0
        setName("$AdminContentUI0");
        ((jaxx.runtime.swing.Table) $AdminContentUI0.getObjectById("toolbar")).setLayout(new BoxLayout(toolbar, 0));
        
        
        // registers 13 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 13 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$ADMIN_CONTENT_UI0_ENABLED, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                setEnabled(getBean() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(isEnabled() ? bean : null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TITLE_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    title.setText(_(updateTitle(getBean().getName())));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CREATE_BUTTON_ENABLED, true ,"inCreation") {
        
            @Override
            public void processDataBinding() {
                createButton.setEnabled(!isInCreation());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CREATE_BUTTON_VISIBLE, true ,"inGroup") {
        
            @Override
            public void processDataBinding() {
                createButton.setVisible(!isInGroup());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true ,"enabled" ,"inCreation") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setEnabled(isEnabled() && !isInCreation());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_VISIBLE, true ,"inGroup") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setVisible(!isInGroup());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON1_ENABLED, true ,"enabled" ,"inCreation") {
        
            @Override
            public void processDataBinding() {
                $JButton1.setEnabled(isEnabled() && !isInCreation());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON1_VISIBLE, true ,"inGroup") {
        
            @Override
            public void processDataBinding() {
                $JButton1.setVisible(!isInGroup());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CLIENT_NAME_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(clientName, getBean().getName());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CLIENT_ADDRESS_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(clientAddress, getBean().getAddress());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CLIENT_PHONE_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(clientPhone, getBean().getPhone());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CLIENT_CONTACT_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(clientContact, getBean().getContact());
                }
            }
        });
    }

}