/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.admin.*;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.admin.helpers.ClientNavigationTreeHelper;
import com.jurismarches.vradi.ui.admin.helpers.FormTypeNavigationTreeHelper;
import com.jurismarches.vradi.ui.admin.helpers.GroupNavigationTreeHelper;
import com.jurismarches.vradi.ui.admin.helpers.XmlStreamNavigationTreeHelper;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.thesaurus.helpers.ThesaurusTreeTableHelper;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.tree.TreePath;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminPopupUI extends javax.swing.JFrame implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADMIN_TABS_MODEL = "adminTabs.model";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.AdminPopupUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminPopupUI adminPopupUI = this;
    protected com.jurismarches.vradi.ui.admin.content.AdminStatusUI adminStatus;
    protected javax.swing.JTabbedPane adminTabs;
    protected com.jurismarches.vradi.ui.admin.content.AdminThesaurusUI adminThesaurus;
    protected com.jurismarches.vradi.ui.admin.AdminNavUI clientAdminNavUI;
    protected com.jurismarches.vradi.ui.admin.AdminNavUI formAdminNavUI;
    protected com.jurismarches.vradi.ui.admin.AdminNavUI groupAdminNavUI;
    protected com.jurismarches.vradi.ui.admin.AdminNavUI xmlStreamAdminNavUI;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JButton $JButton0;
    private jaxx.runtime.swing.TabInfo $TabInfo0;
    private jaxx.runtime.swing.TabInfo $TabInfo1;
    private jaxx.runtime.swing.TabInfo $TabInfo2;
    private jaxx.runtime.swing.TabInfo $TabInfo3;
    private jaxx.runtime.swing.TabInfo $TabInfo4;
    private jaxx.runtime.swing.TabInfo $TabInfo5;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean contextInitialized;
    private SingleSelectionModel selectionModel;
    private VradiDataProvider dataProvider;
    
    
    public  AdminPopupUI(JAXXContext parentContext, Window parent) {
        super();$initialize();
    
        SwingUtil.initContext(this, parentContext);
        jaxx.runtime.JAXXUtil.assignment(selectionModel = new DefaultSingleSelectionModel() {
            private static final long serialVersionUID = 1L;
    
            @Override
            public void setSelectedIndex(int index) {
                int oldIndex = getSelectedIndex();
                if (oldIndex != -1) {
                    // on verifie que l'onglet en cours n'est pas modifie
                    AdminContentUI<?> content = getCurrentContent();
    
                    // null if is thesaurus selected
                    if (content != null){
                        boolean canContinue = getHandler().answerToSave(content);
                        if (!canContinue) {
                            // l'utilisateur ne veut pas partir au final
                            return;
                        }
                    }
                }
                super.setSelectedIndex(index);
            }
        }, "selectionModel", com.jurismarches.vradi.ui.admin.AdminPopupUI.this);
        jaxx.runtime.JAXXUtil.assignment(contextInitialized = true, "contextInitialized", com.jurismarches.vradi.ui.admin.AdminPopupUI.this);
        this.pack();
    $initialize();
    }
    
    protected AdminThesaurusHandler getThesaurusHandler() {
        return UIHelper.getHandler(this, AdminThesaurusHandler.class);
    }
    
    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    public void close(){
        Component selected = adminTabs.getSelectedComponent();
        AdminHandler handler = getHandler();
    
        // Nothing for thesaurus
        if (selected instanceof AdminThesaurusUI) {
            handler.close(this);
        }
        AdminContentUI currentContent;
    
        // Status ui is not nav ui
        if (selected instanceof AdminStatusUI) {
            currentContent = (AdminStatusUI) selected;
        } else {
            currentContent = getCurrentContent();
    
            // if is thesaurus selected
            if (currentContent == null){
                handler.close(this);
                return;
            }
        }
        boolean canContinue = handler.answerToSave(currentContent);
        if (canContinue) {
            handler.close(this);
        }
    }
    
    public void showTab(int i){
        adminTabs.setSelectedIndex(i);
    }
    
    public AdminContentUI getCurrentContent() {
        Component selected = adminTabs.getSelectedComponent();
        if (selected instanceof AdminNavUI) {
            return ((AdminNavUI)selected).getCurrentContent();
        } else if (selected instanceof AdminStatusUI) {
            return (AdminContentUI) selected;
        }
        return null;
    }
    
    public AdminNavUI getCurrentTab() {
        Component selected = adminTabs.getSelectedComponent();
        if (selected instanceof AdminThesaurusUI ||
            selected instanceof AdminStatusUI) {
            return null;
        }
        return (AdminNavUI) selected;
    }
    
    public AdminStatusUI getStatusTab(){
        return (AdminStatusUI)adminTabs.getComponentAt(4);
    }
    
    public AdminThesaurusUI getTesaurusTab(){
        return (AdminThesaurusUI)adminTabs.getComponentAt(5);
    }
    
    void $afterCompleteSetup() {
        SwingUtil.center(getOwner(), this);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminPopupUI() {
        $initialize();
    }

    public AdminPopupUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        close();
    }

    public void doWindowClosing__on__adminPopupUI(java.awt.event.WindowEvent event) {
        close();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public com.jurismarches.vradi.ui.admin.content.AdminStatusUI getAdminStatus() {
        return adminStatus;
    }

    public javax.swing.JTabbedPane getAdminTabs() {
        return adminTabs;
    }

    public com.jurismarches.vradi.ui.admin.content.AdminThesaurusUI getAdminThesaurus() {
        return adminThesaurus;
    }

    public com.jurismarches.vradi.ui.admin.AdminNavUI getClientAdminNavUI() {
        return clientAdminNavUI;
    }

    public com.jurismarches.vradi.ui.admin.AdminNavUI getFormAdminNavUI() {
        return formAdminNavUI;
    }

    public com.jurismarches.vradi.ui.admin.AdminNavUI getGroupAdminNavUI() {
        return groupAdminNavUI;
    }

    public com.jurismarches.vradi.ui.admin.AdminNavUI getXmlStreamAdminNavUI() {
        return xmlStreamAdminNavUI;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo2() {
        return $TabInfo2;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo3() {
        return $TabInfo3;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo4() {
        return $TabInfo4;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo5() {
        return $TabInfo5;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminPopupUI() {
        if (!allComponentsCreated) {
            return;
        }
        add(adminTabs, BorderLayout.CENTER);
        add($JButton0, BorderLayout.SOUTH);
    }

    protected void addChildrenToAdminTabs() {
        if (!allComponentsCreated) {
            return;
        }
        adminTabs.add(clientAdminNavUI);
        adminTabs.add(groupAdminNavUI);
        adminTabs.add(formAdminNavUI);
        adminTabs.add(xmlStreamAdminNavUI);
        adminTabs.add(adminStatus);
        adminTabs.add(adminThesaurus);
        $TabInfo0.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(adminTabs, 0));
        adminTabs.setTitleAt(0, _("vradi.admin.client"));
        $TabInfo1.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(adminTabs, 1));
        adminTabs.setTitleAt(1, _("vradi.admin.group"));
        $TabInfo2.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(adminTabs, 2));
        adminTabs.setTitleAt(2, _("vradi.admin.form"));
        $TabInfo3.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(adminTabs, 3));
        adminTabs.setTitleAt(3, _("vradi.admin.xmlStream"));
        $TabInfo4.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(adminTabs, 4));
        adminTabs.setTitleAt(4, _("vradi.admin.status"));
        $TabInfo5.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(adminTabs, 5));
        adminTabs.setTitleAt(5, _("vradi.admin.thesaurus"));
    }

    protected void createAdminStatus() {
        $objectMap.put("adminStatus", adminStatus = new com.jurismarches.vradi.ui.admin.content.AdminStatusUI(this));
        
        adminStatus.setName("adminStatus");
        if (((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).getFont() != null) {
            ((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).setFont(((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).getFont().deriveFont((float) 20));
        }
        if (((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).getFont() != null) {
            ((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).setFont(((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).getFont().deriveFont(((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).getFont().getStyle() | Font.BOLD));
        }
    }

    protected void createAdminTabs() {
        $objectMap.put("adminTabs", adminTabs = new javax.swing.JTabbedPane());
        
        adminTabs.setName("adminTabs");
    }

    protected void createAdminThesaurus() {
        $objectMap.put("adminThesaurus", adminThesaurus = new com.jurismarches.vradi.ui.admin.content.AdminThesaurusUI(this, new ThesaurusTreeTableHelper()));
        
        adminThesaurus.setName("adminThesaurus");
    }

    protected void createClientAdminNavUI() {
        $objectMap.put("clientAdminNavUI", clientAdminNavUI = new com.jurismarches.vradi.ui.admin.AdminNavUI(this, new ClientNavigationTreeHelper(dataProvider)));
        
        clientAdminNavUI.setName("clientAdminNavUI");
        clientAdminNavUI.setShowImportExport(true);
    }

    protected void createFormAdminNavUI() {
        $objectMap.put("formAdminNavUI", formAdminNavUI = new com.jurismarches.vradi.ui.admin.AdminNavUI(this, new FormTypeNavigationTreeHelper(dataProvider)));
        
        formAdminNavUI.setName("formAdminNavUI");
    }

    protected void createGroupAdminNavUI() {
        $objectMap.put("groupAdminNavUI", groupAdminNavUI = new com.jurismarches.vradi.ui.admin.AdminNavUI(this, new GroupNavigationTreeHelper(dataProvider)));
        
        groupAdminNavUI.setName("groupAdminNavUI");
        groupAdminNavUI.setShowImportExport(true);
    }

    protected void createXmlStreamAdminNavUI() {
        $objectMap.put("xmlStreamAdminNavUI", xmlStreamAdminNavUI = new com.jurismarches.vradi.ui.admin.AdminNavUI(this, new XmlStreamNavigationTreeHelper(dataProvider)));
        
        xmlStreamAdminNavUI.setName("xmlStreamAdminNavUI");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToAdminPopupUI();
        addChildrenToAdminTabs();
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("close"));
        ((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        ((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).setHorizontalTextPosition(JLabel.LEFT);
        // late initializer
        adminPopupUI.pack();
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("adminPopupUI", this);
        dataProvider = new VradiDataProvider();
        createAdminTabs();
        createClientAdminNavUI();
        createGroupAdminNavUI();
        createFormAdminNavUI();
        createXmlStreamAdminNavUI();
        createAdminStatus();
        createAdminThesaurus();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.action.close"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new jaxx.runtime.swing.TabInfo());
        
        $TabInfo0.setTitle(_("vradi.admin.client"));
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new jaxx.runtime.swing.TabInfo());
        
        $TabInfo1.setTitle(_("vradi.admin.group"));
        // inline creation of $TabInfo2
        $objectMap.put("$TabInfo2", $TabInfo2 = new jaxx.runtime.swing.TabInfo());
        
        $TabInfo2.setTitle(_("vradi.admin.form"));
        // inline creation of $TabInfo3
        $objectMap.put("$TabInfo3", $TabInfo3 = new jaxx.runtime.swing.TabInfo());
        
        $TabInfo3.setTitle(_("vradi.admin.xmlStream"));
        // inline creation of $TabInfo4
        $objectMap.put("$TabInfo4", $TabInfo4 = new jaxx.runtime.swing.TabInfo());
        
        $TabInfo4.setTitle(_("vradi.admin.status"));
        // inline creation of $TabInfo5
        $objectMap.put("$TabInfo5", $TabInfo5 = new jaxx.runtime.swing.TabInfo());
        
        $TabInfo5.setTitle(_("vradi.admin.thesaurus"));
        // inline creation of adminPopupUI
        setName("adminPopupUI");
        adminPopupUI.getContentPane().setLayout(new BorderLayout());
        setTitle(_("vradi.admin.title"));
        adminPopupUI.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__adminPopupUI"));
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ADMIN_TABS_MODEL, true ,"selectionModel") {
        
            @Override
            public void processDataBinding() {
                adminTabs.setModel(selectionModel);
            }
        });
    }

}