/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.models.FormMenu;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import java.util.Locale;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class VradiMainUI extends javax.swing.JFrame implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_MAIN_FRAME_UNDECORATED = "mainFrame.undecorated";
    public static final String BINDING_MENU_FILE_FULLSCREEN_VISIBLE = "menuFileFullscreen.visible";
    public static final String BINDING_MENU_FILE_LANGUAGE_FR_ENABLED = "menuFileLanguageFR.enabled";
    public static final String BINDING_MENU_FILE_LANGUAGE_UK_ENABLED = "menuFileLanguageUK.enabled";
    public static final String BINDING_MENU_FILE_NORMALSCREEN_VISIBLE = "menuFileNormalscreen.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.VradiMainUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel content;
    protected VradiMainUI mainFrame = this;
    protected javax.swing.JMenuBar menu;
    protected javax.swing.JMenu menuAdmin;
    protected javax.swing.JMenuItem menuAdminClient;
    protected javax.swing.JMenuItem menuAdminEmail;
    protected javax.swing.JMenuItem menuAdminForm;
    protected javax.swing.JMenuItem menuAdminGroup;
    protected javax.swing.JMenuItem menuAdminStatus;
    protected javax.swing.JMenuItem menuAdminThesaurus;
    protected javax.swing.JMenuItem menuAdminXmlStream;
    protected javax.swing.JMenu menuEmail;
    protected javax.swing.JMenu menuFile;
    protected javax.swing.JMenuItem menuFileConfiguration;
    protected javax.swing.JMenuItem menuFileExit;
    protected javax.swing.JMenuItem menuFileFullscreen;
    protected javax.swing.JMenu menuFileLanguage;
    protected javax.swing.JMenuItem menuFileLanguageFR;
    protected javax.swing.JMenuItem menuFileLanguageUK;
    protected javax.swing.JMenuItem menuFileNormalscreen;
    protected com.jurismarches.vradi.ui.models.FormMenu menuForm;
    protected javax.swing.JMenu menuHelp;
    protected javax.swing.JMenuItem menuHelpAbout;
    protected javax.swing.JMenuItem menuHelpHelp;
    protected javax.swing.JMenuItem menuHelpSite;
    protected javax.swing.JMenuItem menuShowOfferListUI;
    protected jaxx.runtime.swing.StatusMessagePanel status;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JSeparator $JSeparator0;
    private javax.swing.JSeparator $JSeparator1;
    private javax.swing.JSeparator $JSeparator2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public com.jurismarches.vradi.VradiConfig getConfig() {
        return getContextValue(com.jurismarches.vradi.VradiConfig.class);
    }
    
    public VradiMainUIHandler getHandler() {
        return getContextValue(VradiMainUIHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    public boolean acceptLocale(Locale l, String expected) {
      return l != null && l.toString().equals(expected);
    }
    
    void $afterCompleteSetup() {    
        //getBroker().setHandler(getHandler());
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public VradiMainUI() {
        $initialize();
    }

    public VradiMainUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__menuAdminClient(java.awt.event.ActionEvent event) {
        getHandler().showAdminClient(this);
    }

    public void doActionPerformed__on__menuAdminEmail(java.awt.event.ActionEvent event) {
        getHandler().showEmail(this);
    }

    public void doActionPerformed__on__menuAdminForm(java.awt.event.ActionEvent event) {
        getHandler().showAdminForm(this);
    }

    public void doActionPerformed__on__menuAdminGroup(java.awt.event.ActionEvent event) {
        getHandler().showAdminGroup(this);
    }

    public void doActionPerformed__on__menuAdminStatus(java.awt.event.ActionEvent event) {
        getHandler().showAdminStatus(this);
    }

    public void doActionPerformed__on__menuAdminThesaurus(java.awt.event.ActionEvent event) {
        getHandler().showAdminThesaurus(this);
    }

    public void doActionPerformed__on__menuAdminXmlStream(java.awt.event.ActionEvent event) {
        getHandler().showAdminXmlStream(this);
    }

    public void doActionPerformed__on__menuFileConfiguration(java.awt.event.ActionEvent event) {
        getHandler().showConfig(this);
    }

    public void doActionPerformed__on__menuFileExit(java.awt.event.ActionEvent event) {
        getHandler().close(mainFrame);
    }

    public void doActionPerformed__on__menuFileFullscreen(java.awt.event.ActionEvent event) {
        getHandler().changeScreen(this, true);
    }

    public void doActionPerformed__on__menuFileLanguageFR(java.awt.event.ActionEvent event) {
        getHandler().changeLanguage(this, Locale.FRANCE);
    }

    public void doActionPerformed__on__menuFileLanguageUK(java.awt.event.ActionEvent event) {
        getHandler().changeLanguage(this, Locale.UK);
    }

    public void doActionPerformed__on__menuFileNormalscreen(java.awt.event.ActionEvent event) {
        getHandler().changeScreen(this, false);
    }

    public void doActionPerformed__on__menuHelpAbout(java.awt.event.ActionEvent event) {
        getHandler().showAbout(this);
    }

    public void doActionPerformed__on__menuHelpHelp(java.awt.event.ActionEvent event) {
        getHandler().showHelp(this, null);
    }

    public void doActionPerformed__on__menuHelpSite(java.awt.event.ActionEvent event) {
        getHandler().gotoSite(this);
    }

    public void doActionPerformed__on__menuShowOfferListUI(java.awt.event.ActionEvent event) {
        getHandler().showOfferListUI(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JPanel getContent() {
        return content;
    }

    public javax.swing.JMenuBar getMenu() {
        return menu;
    }

    public javax.swing.JMenu getMenuAdmin() {
        return menuAdmin;
    }

    public javax.swing.JMenuItem getMenuAdminClient() {
        return menuAdminClient;
    }

    public javax.swing.JMenuItem getMenuAdminEmail() {
        return menuAdminEmail;
    }

    public javax.swing.JMenuItem getMenuAdminForm() {
        return menuAdminForm;
    }

    public javax.swing.JMenuItem getMenuAdminGroup() {
        return menuAdminGroup;
    }

    public javax.swing.JMenuItem getMenuAdminStatus() {
        return menuAdminStatus;
    }

    public javax.swing.JMenuItem getMenuAdminThesaurus() {
        return menuAdminThesaurus;
    }

    public javax.swing.JMenuItem getMenuAdminXmlStream() {
        return menuAdminXmlStream;
    }

    public javax.swing.JMenu getMenuEmail() {
        return menuEmail;
    }

    public javax.swing.JMenu getMenuFile() {
        return menuFile;
    }

    public javax.swing.JMenuItem getMenuFileConfiguration() {
        return menuFileConfiguration;
    }

    public javax.swing.JMenuItem getMenuFileExit() {
        return menuFileExit;
    }

    public javax.swing.JMenuItem getMenuFileFullscreen() {
        return menuFileFullscreen;
    }

    public javax.swing.JMenu getMenuFileLanguage() {
        return menuFileLanguage;
    }

    public javax.swing.JMenuItem getMenuFileLanguageFR() {
        return menuFileLanguageFR;
    }

    public javax.swing.JMenuItem getMenuFileLanguageUK() {
        return menuFileLanguageUK;
    }

    public javax.swing.JMenuItem getMenuFileNormalscreen() {
        return menuFileNormalscreen;
    }

    public com.jurismarches.vradi.ui.models.FormMenu getMenuForm() {
        return menuForm;
    }

    public javax.swing.JMenu getMenuHelp() {
        return menuHelp;
    }

    public javax.swing.JMenuItem getMenuHelpAbout() {
        return menuHelpAbout;
    }

    public javax.swing.JMenuItem getMenuHelpHelp() {
        return menuHelpHelp;
    }

    public javax.swing.JMenuItem getMenuHelpSite() {
        return menuHelpSite;
    }

    public javax.swing.JMenuItem getMenuShowOfferListUI() {
        return menuShowOfferListUI;
    }

    public jaxx.runtime.swing.StatusMessagePanel getStatus() {
        return status;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected javax.swing.JSeparator get$JSeparator1() {
        return $JSeparator1;
    }

    protected javax.swing.JSeparator get$JSeparator2() {
        return $JSeparator2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToMainFrame() {
        if (!allComponentsCreated) {
            return;
        }
        add(content);
        add(status, BorderLayout.SOUTH);
        mainFrame.setJMenuBar(menu);
    }

    protected void addChildrenToMenu() {
        if (!allComponentsCreated) {
            return;
        }
        menu.add(menuFile);
        menu.add(menuForm);
        menu.add(menuAdmin);
        menu.add(menuEmail);
        menu.add(menuHelp);
    }

    protected void addChildrenToMenuAdmin() {
        if (!allComponentsCreated) {
            return;
        }
        menuAdmin.add(menuAdminClient);
        menuAdmin.add(menuAdminGroup);
        menuAdmin.add(menuAdminForm);
        menuAdmin.add(menuAdminXmlStream);
        menuAdmin.add(menuAdminStatus);
        menuAdmin.add(menuAdminThesaurus);
    }

    protected void addChildrenToMenuEmail() {
        if (!allComponentsCreated) {
            return;
        }
        menuEmail.add(menuAdminEmail);
    }

    protected void addChildrenToMenuFile() {
        if (!allComponentsCreated) {
            return;
        }
        menuFile.add(menuShowOfferListUI);
        menuFile.add($JSeparator0);
        menuFile.add(menuFileConfiguration);
        menuFile.add(menuFileLanguage);
        menuFile.add($JSeparator1);
        menuFile.add(menuFileFullscreen);
        menuFile.add(menuFileNormalscreen);
        menuFile.add($JSeparator2);
        menuFile.add(menuFileExit);
    }

    protected void addChildrenToMenuFileLanguage() {
        if (!allComponentsCreated) {
            return;
        }
        menuFileLanguage.add(menuFileLanguageFR);
        menuFileLanguage.add(menuFileLanguageUK);
    }

    protected void addChildrenToMenuHelp() {
        if (!allComponentsCreated) {
            return;
        }
        menuHelp.add(menuHelpHelp);
        menuHelp.add(menuHelpSite);
        menuHelp.add(menuHelpAbout);
    }

    protected void createContent() {
        $objectMap.put("content", content = new javax.swing.JPanel());
        
        content.setName("content");
    }

    protected void createMenu() {
        $objectMap.put("menu", menu = new javax.swing.JMenuBar());
        
        menu.setName("menu");
        menu.putClientProperty("help", "ui.main.menu");
    }

    protected void createMenuAdmin() {
        $objectMap.put("menuAdmin", menuAdmin = new javax.swing.JMenu());
        
        menuAdmin.setName("menuAdmin");
        menuAdmin.setText(_("vradi.menu.admin"));
        menuAdmin.setMnemonic(65);
        menuAdmin.putClientProperty("help", "ui.main.menu.file");
    }

    protected void createMenuAdminClient() {
        $objectMap.put("menuAdminClient", menuAdminClient = new javax.swing.JMenuItem());
        
        menuAdminClient.setName("menuAdminClient");
        menuAdminClient.setText(_("vradi.menu.client"));
        menuAdminClient.setMnemonic(67);
        menuAdminClient.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuAdminClient"));
        menuAdminClient.putClientProperty("help", "ui.main.menu.action");
    }

    protected void createMenuAdminEmail() {
        $objectMap.put("menuAdminEmail", menuAdminEmail = new javax.swing.JMenuItem());
        
        menuAdminEmail.setName("menuAdminEmail");
        menuAdminEmail.setText(_("vradi.menu.email.admin"));
        menuAdminEmail.setMnemonic(67);
        menuAdminEmail.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuAdminEmail"));
        menuAdminEmail.putClientProperty("help", "ui.main.menu.action");
    }

    protected void createMenuAdminForm() {
        $objectMap.put("menuAdminForm", menuAdminForm = new javax.swing.JMenuItem());
        
        menuAdminForm.setName("menuAdminForm");
        menuAdminForm.setText(_("vradi.menu.formType"));
        menuAdminForm.setMnemonic(70);
        menuAdminForm.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuAdminForm"));
        menuAdminForm.putClientProperty("help", "ui.main.menu.action");
    }

    protected void createMenuAdminGroup() {
        $objectMap.put("menuAdminGroup", menuAdminGroup = new javax.swing.JMenuItem());
        
        menuAdminGroup.setName("menuAdminGroup");
        menuAdminGroup.setText(_("vradi.menu.group"));
        menuAdminGroup.setMnemonic(71);
        menuAdminGroup.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuAdminGroup"));
        menuAdminGroup.putClientProperty("help", "ui.main.menu.action");
    }

    protected void createMenuAdminStatus() {
        $objectMap.put("menuAdminStatus", menuAdminStatus = new javax.swing.JMenuItem());
        
        menuAdminStatus.setName("menuAdminStatus");
        menuAdminStatus.setText(_("vradi.menu.status"));
        menuAdminStatus.setMnemonic(83);
        menuAdminStatus.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuAdminStatus"));
        menuAdminStatus.putClientProperty("help", "ui.main.menu.action");
    }

    protected void createMenuAdminThesaurus() {
        $objectMap.put("menuAdminThesaurus", menuAdminThesaurus = new javax.swing.JMenuItem());
        
        menuAdminThesaurus.setName("menuAdminThesaurus");
        menuAdminThesaurus.setText(_("vradi.menu.thesaurus"));
        menuAdminThesaurus.setMnemonic(84);
        menuAdminThesaurus.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuAdminThesaurus"));
        menuAdminThesaurus.putClientProperty("help", "ui.main.menu.action");
    }

    protected void createMenuAdminXmlStream() {
        $objectMap.put("menuAdminXmlStream", menuAdminXmlStream = new javax.swing.JMenuItem());
        
        menuAdminXmlStream.setName("menuAdminXmlStream");
        menuAdminXmlStream.setText(_("vradi.menu.xmlStream"));
        menuAdminXmlStream.setMnemonic(88);
        menuAdminXmlStream.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuAdminXmlStream"));
        menuAdminXmlStream.putClientProperty("help", "ui.main.menu.action");
    }

    protected void createMenuEmail() {
        $objectMap.put("menuEmail", menuEmail = new javax.swing.JMenu());
        
        menuEmail.setName("menuEmail");
        menuEmail.setText(_("vradi.menu.email"));
        menuEmail.setMnemonic(69);
        menuEmail.putClientProperty("help", "ui.main.menu.file");
    }

    protected void createMenuFile() {
        $objectMap.put("menuFile", menuFile = new javax.swing.JMenu());
        
        menuFile.setName("menuFile");
        menuFile.setText(_("vradi.menu.file"));
        menuFile.setMnemonic(70);
        menuFile.putClientProperty("help", "ui.main.menu.file");
    }

    protected void createMenuFileConfiguration() {
        $objectMap.put("menuFileConfiguration", menuFileConfiguration = new javax.swing.JMenuItem());
        
        menuFileConfiguration.setName("menuFileConfiguration");
        menuFileConfiguration.setText(_("vradi.action.configuration"));
        menuFileConfiguration.setMnemonic(67);
        menuFileConfiguration.setToolTipText(_("vradi.action.configuration.tip"));
        menuFileConfiguration.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileConfiguration"));
        menuFileConfiguration.putClientProperty("help", "ui.main.menu.file.configuration");
    }

    protected void createMenuFileExit() {
        $objectMap.put("menuFileExit", menuFileExit = new javax.swing.JMenuItem());
        
        menuFileExit.setName("menuFileExit");
        menuFileExit.setText(_("vradi.action.exit"));
        menuFileExit.setMnemonic(88);
        menuFileExit.setToolTipText(_("vradi.action.exit.tip"));
        menuFileExit.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileExit"));
        menuFileExit.putClientProperty("help", "ui.main.menu.file.exit");
    }

    protected void createMenuFileFullscreen() {
        $objectMap.put("menuFileFullscreen", menuFileFullscreen = new javax.swing.JMenuItem());
        
        menuFileFullscreen.setName("menuFileFullscreen");
        menuFileFullscreen.setText(_("vradi.action.fullscreen"));
        menuFileFullscreen.setMnemonic(80);
        menuFileFullscreen.setToolTipText(_("vradi.action.fullscreen.tip"));
        menuFileFullscreen.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileFullscreen"));
        menuFileFullscreen.putClientProperty("help", "ui.main.menu.file.fullscreen");
    }

    protected void createMenuFileLanguage() {
        $objectMap.put("menuFileLanguage", menuFileLanguage = new javax.swing.JMenu());
        
        menuFileLanguage.setName("menuFileLanguage");
        menuFileLanguage.setText(_("vradi.menu.file.locale"));
        menuFileLanguage.setMnemonic(67);
        menuFileLanguage.setToolTipText(_("vradi.menu.file.locale"));
        menuFileLanguage.putClientProperty("help", "ui.main.menu.file.locale");
    }

    protected void createMenuFileLanguageFR() {
        $objectMap.put("menuFileLanguageFR", menuFileLanguageFR = new javax.swing.JMenuItem());
        
        menuFileLanguageFR.setName("menuFileLanguageFR");
        menuFileLanguageFR.setText(_("vradi.action.locale.fr"));
        menuFileLanguageFR.setToolTipText(_("vradi.action.locale.fr.tip"));
        menuFileLanguageFR.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileLanguageFR"));
        menuFileLanguageFR.putClientProperty("help", "ui.main.menu.file.locale.fr");
    }

    protected void createMenuFileLanguageUK() {
        $objectMap.put("menuFileLanguageUK", menuFileLanguageUK = new javax.swing.JMenuItem());
        
        menuFileLanguageUK.setName("menuFileLanguageUK");
        menuFileLanguageUK.setText(_("vradi.action.locale.uk"));
        menuFileLanguageUK.setMnemonic(85);
        menuFileLanguageUK.setToolTipText(_("vradi.action.locale.uk.tip"));
        menuFileLanguageUK.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileLanguageUK"));
        menuFileLanguageUK.putClientProperty("help", "ui.main.menu.file.locale.uk");
    }

    protected void createMenuFileNormalscreen() {
        $objectMap.put("menuFileNormalscreen", menuFileNormalscreen = new javax.swing.JMenuItem());
        
        menuFileNormalscreen.setName("menuFileNormalscreen");
        menuFileNormalscreen.setText(_("vradi.action.normalscreen"));
        menuFileNormalscreen.setMnemonic(78);
        menuFileNormalscreen.setToolTipText(_("vradi.action.normalscreen.tip"));
        menuFileNormalscreen.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileNormalscreen"));
        menuFileNormalscreen.putClientProperty("help", "ui.main.menu.file.leave-fullscreen");
    }

    protected void createMenuForm() {
        $objectMap.put("menuForm", menuForm = new com.jurismarches.vradi.ui.models.FormMenu(getHandler()));
        
        menuForm.setName("menuForm");
        menuForm.setText(_("vradi.menu.form"));
        menuForm.setMnemonic(77);
        menuForm.putClientProperty("help", "ui.main.menu.form");
    }

    protected void createMenuHelp() {
        $objectMap.put("menuHelp", menuHelp = new javax.swing.JMenu());
        
        menuHelp.setName("menuHelp");
        menuHelp.setText(_("vradi.menu.help"));
        menuHelp.setMnemonic(101);
        menuHelp.putClientProperty("help", "ui.main.menu.help");
    }

    protected void createMenuHelpAbout() {
        $objectMap.put("menuHelpAbout", menuHelpAbout = new javax.swing.JMenuItem());
        
        menuHelpAbout.setName("menuHelpAbout");
        menuHelpAbout.setText(_("vradi.action.about"));
        menuHelpAbout.setMnemonic(65);
        menuHelpAbout.setToolTipText(_("vradi.action.about.tip"));
        menuHelpAbout.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpAbout"));
        menuHelpAbout.putClientProperty("help", "ui.main.menu.help.about");
    }

    protected void createMenuHelpHelp() {
        $objectMap.put("menuHelpHelp", menuHelpHelp = new javax.swing.JMenuItem());
        
        menuHelpHelp.setName("menuHelpHelp");
        menuHelpHelp.setText(_("vradi.action.help"));
        menuHelpHelp.setMnemonic(101);
        menuHelpHelp.setToolTipText(_("vradi.action.help.tip"));
        menuHelpHelp.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpHelp"));
        menuHelpHelp.putClientProperty("help", "ui.main.menu.help.help");
    }

    protected void createMenuHelpSite() {
        $objectMap.put("menuHelpSite", menuHelpSite = new javax.swing.JMenuItem());
        
        menuHelpSite.setName("menuHelpSite");
        menuHelpSite.setText(_("vradi.action.site"));
        menuHelpSite.setMnemonic(115);
        menuHelpSite.setToolTipText(_("vradi.action.site.tip"));
        menuHelpSite.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpSite"));
        menuHelpSite.putClientProperty("help", "ui.main.menu.help.site");
    }

    protected void createMenuShowOfferListUI() {
        $objectMap.put("menuShowOfferListUI", menuShowOfferListUI = new javax.swing.JMenuItem());
        
        menuShowOfferListUI.setName("menuShowOfferListUI");
        menuShowOfferListUI.setText(_("vradi.menu.file.offerList"));
        menuShowOfferListUI.setMnemonic(79);
        menuShowOfferListUI.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuShowOfferListUI"));
        menuShowOfferListUI.putClientProperty("help", "ui.main.menu.file.offerList");
    }

    protected void createStatus() {
        $objectMap.put("status", status = new jaxx.runtime.swing.StatusMessagePanel());
        
        status.setName("status");
        status.putClientProperty("help", "ui.main.statusBar");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToMainFrame();
        addChildrenToMenu();
        addChildrenToMenuFile();
        addChildrenToMenuFileLanguage();
        addChildrenToMenuAdmin();
        addChildrenToMenuEmail();
        addChildrenToMenuHelp();
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 10 property setters
        menuFileConfiguration.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("config"));
        menuFileLanguage.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("translate"));
        menuFileLanguageFR.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("i18n-fr"));
        menuFileLanguageUK.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("i18n-uk"));
        menuFileFullscreen.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("fullscreen"));
        menuFileNormalscreen.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("leave-fullscreen"));
        menuFileExit.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("exit"));
        menuHelpHelp.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("help"));
        menuHelpSite.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("site"));
        menuHelpAbout.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("about"));
        // late initializer
        mainFrame.pack();
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("mainFrame", this);
        createMenu();
        createMenuFile();
        createMenuShowOfferListUI();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new javax.swing.JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createMenuFileConfiguration();
        createMenuFileLanguage();
        createMenuFileLanguageFR();
        createMenuFileLanguageUK();
        // inline creation of $JSeparator1
        $objectMap.put("$JSeparator1", $JSeparator1 = new javax.swing.JSeparator());
        
        $JSeparator1.setName("$JSeparator1");
        createMenuFileFullscreen();
        createMenuFileNormalscreen();
        // inline creation of $JSeparator2
        $objectMap.put("$JSeparator2", $JSeparator2 = new javax.swing.JSeparator());
        
        $JSeparator2.setName("$JSeparator2");
        createMenuFileExit();
        createMenuForm();
        createMenuAdmin();
        createMenuAdminClient();
        createMenuAdminGroup();
        createMenuAdminForm();
        createMenuAdminXmlStream();
        createMenuAdminStatus();
        createMenuAdminThesaurus();
        createMenuEmail();
        createMenuAdminEmail();
        createMenuHelp();
        createMenuHelpHelp();
        createMenuHelpSite();
        createMenuHelpAbout();
        createContent();
        createStatus();
        // inline creation of mainFrame
        setName("mainFrame");
        setTitle(_("vradi.title.welcome"));
        setDefaultCloseOperation(0);
        
        // registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MAIN_FRAME_UNDECORATED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("fullScreen", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    setUndecorated(getConfig().isFullScreen());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("fullScreen", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_FILE_LANGUAGE_FR_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("locale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    menuFileLanguageFR.setEnabled(!acceptLocale(getConfig().getLocale(), "fr_FR"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("locale", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_FILE_LANGUAGE_UK_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("locale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    menuFileLanguageUK.setEnabled(!acceptLocale(getConfig().getLocale(), "en_GB"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("locale", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MENU_FILE_FULLSCREEN_VISIBLE, true ,"undecorated") {
        
            @Override
            public void processDataBinding() {
                menuFileFullscreen.setVisible(!isUndecorated());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MENU_FILE_NORMALSCREEN_VISIBLE, true ,"undecorated") {
        
            @Override
            public void processDataBinding() {
                menuFileNormalscreen.setVisible(isUndecorated());
            }
        });
    }

}