/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: VradiAction.java 1715 2010-10-27 19:21:28Z tchemit $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.4.0/vradi-swing/src/main/java/com/jurismarches/vradi/VradiAction.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

@jaxx.runtime.context.DefaultApplicationContext.AutoLoad
public class VradiAction {

    /**
     * to use log facility, just put in your code: log.info(\"...\");
     */
    static private Log log = LogFactory.getLog(VradiAction.class);
    /**
     * La configuration de l'application.
     */
    protected VradiConfig config;

    public VradiAction() {
    }

    public VradiAction(VradiConfig config) {
        this.config = config;
    }

    public void configure() {
        disableMainUI();
        VradiContext context = VradiContext.get();
//        VradiMainUIHandler handler = context.getContextValue(VradiMainUIHandler.class);
//        handler.showConfig(context);
    }

    public void help() {
        disableMainUI();

        log.debug(I18n._("vradi.message.help.usage", getConfig().getVersion()));
        log.debug("Options (set with --option <key> <value>:");
        for (VradiConfig.Option o : VradiConfig.Option.values()) {
            log.debug("\t" + o.key + "(" + o.defaultValue + "):" + o.description);
        }

        log.debug("Actions:");
        for (VradiConfig.Action a : VradiConfig.Action.values()) {
            log.debug("\t" + java.util.Arrays.toString(a.aliases) + "(" + a.action + "):" + a.description);
        }
        System.exit(0);
    }
//
//    public void helpUI() {
//        VradiContext context = VradiContext.get();
////        VradiMainUIHandler handler = context.getContextValue(VradiMainUIHandler.class);
//        VradiHelpBroker helpBroker = context.getContextValue(VradiHelpBroker.class);
//
//        log.debug("no mainUI, open in autonome frame");
//        // ouvrir dans une fenetre dedie
//        JHelp ui = new JHelp(helpBroker.getHelpset());
//        JDialog frame = new JDialog((Frame) null, true);
//        frame.setTitle(_("vradi.help.top.title"));
//        frame.setSize(1024, 800);
//        frame.add(ui);
//        frame.setVisible(true);
//
//        disableMainUI();
//
//        System.exit(0);
//    }

    /**
     * Désactiver la possiblite de lancer l'ui principale.
     */
    public void disableMainUI() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        getConfig().setDisplayMainUI(false);
    }

    protected VradiConfig getConfig() {
        if (config == null) {
            VradiContext context = VradiContext.get();
            config = context.getContextValue(VradiConfig.class);
        }
        return config;
    }
}
