/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: ThesaurusCartographyTreeTableModel.java 1636 2010-10-18 08:28:02Z sletellier $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.3.2/vradi-swing/src/main/java/com/jurismarches/vradi/ui/offer/thesaurus/models/ThesaurusCartographyTreeTableModel.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.offer.thesaurus.models;

import static org.nuiton.i18n.I18n._;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

import com.jurismarches.vradi.ui.helpers.VradiComparators;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.treetable.AbstractTreeTableModel;
import org.nuiton.wikitty.WikittyTreeNode;

import com.jurismarches.vradi.beans.QueryParameters;
import com.jurismarches.vradi.entities.RootThesaurus;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.services.VradiService;

/**
 * Ce model est incrémental est fait des requetes seulement quand les noeuds
 * sont déplié et nom tout au chargement de la page.
 * 
 * TODO peut etre a revoir, il est basé sur un simple TreeTableModel
 * avec un cache local.
 *
 * @author chatellier
 * @version $Revision: 1636 $ $Date: 2010-10-18 10:28:02 +0200 (lun., 18 oct. 2010) $
 * @since 14 avr. 2010 14:40:00
 */
public class ThesaurusCartographyTreeTableModel extends AbstractTreeTableModel {

    private static final Log log = LogFactory.getLog(ThesaurusCartographyTreeTableModel.class);

    protected SortedMap<String, List<RootThesaurus>> rootThesaurusCache = new TreeMap<String, List<RootThesaurus>>();
    //protected SortedMap<String, ThesaurusCartography> formCountCache = new TreeMap<String, ThesaurusCartography>();

    protected Map<Thesaurus, Integer> formCountCache = new HashMap<Thesaurus, Integer>();
    protected SortedMap<String, List<Thesaurus>> thesaurusCache = new TreeMap<String, List<Thesaurus>>();

    protected QueryParameters queryParameters;

    public ThesaurusCartographyTreeTableModel(QueryParameters queryParameters) {
        super("1");
        this.queryParameters = queryParameters;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int column) {
        String columnName = null;
        if (column == 0) {
            columnName = _("vradi.thesaurus.name");
        } else if (column == 1) {
            columnName = _("vradi.thesaurus.nbforms");
        } else if (column == 2) {
            columnName = _("vradi.thesaurus.tags");
        }
        return columnName;
    }

    @Override
    public Object getValueAt(Object node, int column) {
        
        Object result = null;

        if (node instanceof RootThesaurus) {
            RootThesaurus treeNode = (RootThesaurus) node;
 
            if (column == 0) {
                result = treeNode.getName();
            }
        }
        else if (node instanceof Thesaurus) {
            Thesaurus treeNode = (Thesaurus) node;

            if (column == 0) {
                result = treeNode;

            } else if (column == 1) {
                //result = formCountCache.get(treeNode.getWikittyId()).getResultCount();
                result = formCountCache.get(treeNode);
            } else if (column == 2) {
                Set<String> tags = treeNode.getTags();
                result = StringUtils.join(tags, ',');
            }
        }
        return result;
    }

    @Override
    public Object getChild(Object parent, int index) {
        
        Object result = null;

        try {
            if (parent == getRoot()) {
                result = rootThesaurusCache.get("root").get(index);
            }
            else {
                // TreeNode marche pour Thesaurus et RootThesaurus
                WikittyTreeNode thesaurus = (WikittyTreeNode)parent;
                //result = formCountCache.get(thesaurus.getWikittyId()).getThesaurus().get(index);
                result = thesaurusCache.get(thesaurus.getWikittyId()).get(index);
            }
        } catch (Exception ex) {
            if  (log.isErrorEnabled()) {
                log.error("Can't get children thesaurus", ex);
            }
        }
        return result;
    }

    @Override
    public int getChildCount(Object parent) {

        int result = 0;

        try {
            if (parent == getRoot()) {
                if (rootThesaurusCache.get("root") == null) {
                    List<RootThesaurus> rootThesauruses =
                            new ArrayList<RootThesaurus>(VradiService.getVradiDataService().getRootThesaurus());

                    // Sort
                    Collections.sort(rootThesauruses, VradiComparators.ROOT_THESAURUS_COMPARATOR);

                    rootThesaurusCache.put("root", rootThesauruses);
                }
                result = rootThesaurusCache.get("root").size();
            }
            else {
                // TreeNode marche pour Thesaurus et RootThesaurus
                WikittyTreeNode thesaurus = (WikittyTreeNode)parent;
                
                if (thesaurusCache.get(thesaurus.getWikittyId()) == null) {
                    Map<Thesaurus, Integer> results =
                            VradiService.getVradiDataService().getChildrenCartography(thesaurus.getWikittyId(),
                            queryParameters);
                    formCountCache.putAll(results);

                    List<Thesaurus> children = new ArrayList<Thesaurus>(results.keySet());

                    // Sort
                    Collections.sort(children, VradiComparators.THESAURUS_COMPARATOR);

                    thesaurusCache.put(thesaurus.getWikittyId(), children);
                }
                result = thesaurusCache.get(thesaurus.getWikittyId()).size();
            }
        } catch (Exception ex) {
            if  (log.isErrorEnabled()) {
                log.error("Can't get children thesaurus", ex);
            }
        }

        return result;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        int result = -1;

        return result;
    }

    public class CartographieTreeCellRenderer extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value,
                boolean selected, boolean expanded, boolean leaf, int row,
                boolean hasFocus) {

            String toolTip = null;

            if (value instanceof WikittyTreeNode) {
                WikittyTreeNode node = (WikittyTreeNode) value;
                value = node.getName();

                // FIXME nombre de formulaire a remonter à configurer
                // FIXME c'est lent, ca ramme
                // FIXME le tooltip ne fonctionne pas
                /*try {
                    FormPagedResult pagedResult = new FormPagedResult();
                    pagedResult.setNbFormsToShow(10);
                    pagedResult = VradiService.getVradiDataService().findForms(queryParameters, pagedResult);
                    //List<Form> forms = formCountCache.get(node.getWikittyId()).getForms();
                    //toolTip = ToolTipHelper.getToolTip(forms);
                    toolTip = ToolTipHelper.getToolTip(pagedResult.getFormsToShow());
                }
                catch (Exception ex) {
                    
                }*/
            }

            JComponent component = (JComponent) super.getTreeCellRendererComponent(
                    tree, value, selected, expanded, leaf, row, hasFocus);
            component.setToolTipText(toolTip);

            return component;
        }
    }

    public QueryParameters getQueryParameters() {
        return queryParameters;
    }

    public void setQueryParameters(QueryParameters queryParameters) {
        this.queryParameters = queryParameters;
    }

}
