/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.popups;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.helpers.ThesaurusTreeTableHelper;
import com.jurismarches.vradi.ui.admin.popups.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.renderers.ThesaurusHighlighter;
import com.jurismarches.vradi.ui.tree.VradiTreeTableNode;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.JAXXTree;
import jaxx.runtime.swing.JAXXTree.JAXXTreeModel;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.decorator.*;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class ThesaurusPathChooserUI extends javax.swing.JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_SAVED = "saved";
    public static final String PROPERTY_SELECTED = "selected";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_SELECT_ENABLED = "select.enabled";
    public static final String BINDING_THESAURUS_TREE_TABLE_MODEL = "thesaurus.treeTableModel";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.popups.ThesaurusPathChooserUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JButton cancel;
    protected java.lang.Boolean saved;
    protected javax.swing.JButton select;
    protected java.lang.Boolean selected;
    protected org.jdesktop.swingx.JXTreeTable thesaurus;
    protected ThesaurusPathChooserUI thesaurusPathChooserUI = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected ThesaurusTreeTableHelper helper;
    
    
    public  ThesaurusPathChooserUI(jaxx.runtime.JAXXContext parentContext, ThesaurusTreeTableHelper helper) {
        jaxx.runtime.SwingUtil.initContext(this, parentContext);
        this.helper = helper;
    $initialize();
    }
    
    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    protected ThesaurusTreeTableHelper getHelper() {
        return helper;
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
        thesaurus.putClientProperty("JTree.lineStyle", "Angled");
    
        TreeSelectionListener listener = new TreeSelectionListener(){
    
            @Override
            public void valueChanged(TreeSelectionEvent e) {
    
                // Get selcted node
                VradiTreeTableNode selectedNode = helper.getSelectedNode();
    
                // Set as selected
                setSelected(selectedNode != null);
            }
        };
    
        // Register tree table
        helper.setUI(thesaurus, true, false, listener);
        
        UIHelper.addThesaurusExpandOnClickListener(thesaurus);
    
        // Render
        thesaurus.setTreeCellRenderer(new ThesaurusHighlighter(ThesaurusHighlighter.HighlighterType.MOVE));
    }
        
    protected void close(){
        setVisible(false);
        dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ThesaurusPathChooserUI() {
        $initialize();
    }

    public ThesaurusPathChooserUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(java.awt.event.ActionEvent event) {
        close();
    }

    public void doActionPerformed__on__select(java.awt.event.ActionEvent event) {
        setSaved(true);close();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JButton getCancel() {
        return cancel;
    }

    public java.lang.Boolean getSaved() {
        return saved;
    }

    public javax.swing.JButton getSelect() {
        return select;
    }

    public java.lang.Boolean getSelected() {
        return selected;
    }

    public org.jdesktop.swingx.JXTreeTable getThesaurus() {
        return thesaurus;
    }

    public java.lang.Boolean isSaved() {
        return saved !=null && saved;
    }

    public java.lang.Boolean isSelected() {
        return selected !=null && selected;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setSaved(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.saved;
        this.saved = newValue;
        firePropertyChange(PROPERTY_SAVED, oldValue, newValue);
    }

    public void setSelected(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.selected;
        this.selected = newValue;
        firePropertyChange(PROPERTY_SELECTED, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToThesaurusPathChooserUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0, BorderLayout.CENTER);
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new javax.swing.JButton());
        
        cancel.setName("cancel");
        cancel.setText(_("vradi.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createSaved() {
        $objectMap.put("saved", saved = false);
    }

    protected void createSelect() {
        $objectMap.put("select", select = new javax.swing.JButton());
        
        select.setName("select");
        select.setText(_("vradi.common.select"));
        select.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__select"));
    }

    protected void createSelected() {
        $objectMap.put("selected", selected = false);
    }

    protected void createThesaurus() {
        $objectMap.put("thesaurus", thesaurus = new org.jdesktop.swingx.JXTreeTable());
        
        thesaurus.setName("thesaurus");
        if (thesaurus.getFont() != null) {
            thesaurus.setFont(thesaurus.getFont().deriveFont((float) 11));
        }
        thesaurus.setRootVisible(false);
        thesaurus.setShowsRootHandles(true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToThesaurusPathChooserUI();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.7, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(cancel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(select, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(thesaurus);
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 4 property setters
        thesaurus.setHighlighters(new ThesaurusHighlighter(ThesaurusHighlighter.HighlighterType.MOVE));
        cancel.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("cancel"));
        select.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("select"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("thesaurusPathChooserUI", this);
        createSelected();
        createSaved();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminThesaurus.selectAsk"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createThesaurus();
        createCancel();
        createSelect();
        // inline creation of thesaurusPathChooserUI
        setName("thesaurusPathChooserUI");
        SwingUtil.setComponentHeight(thesaurusPathChooserUI,600);
        thesaurusPathChooserUI.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        setTitle(_("vradi.adminThesaurus.select"));
        SwingUtil.setComponentWidth(thesaurusPathChooserUI,800);
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_THESAURUS_TREE_TABLE_MODEL, true ,"helper") {
        
            @Override
            public void processDataBinding() {
                if (helper != null) {
                    thesaurus.setTreeTableModel(helper.createTreeModel());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SELECT_ENABLED, true ,"selected") {
        
            @Override
            public void processDataBinding() {
                select.setEnabled(isSelected());
            }
        });
    }

}