package com.jurismarches.vradi.ui.tree.loadors;

import com.jurismarches.vradi.services.VradiDataService;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import jaxx.runtime.swing.nav.NavDataProvider;
import jaxx.runtime.swing.nav.tree.NavTreeNodeChildLoador;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.WikittyProxy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/**
 * @author sletellier <letellier@codelutin.com>
 */
public abstract class AbstractVradiNodeLoadors<B extends BusinessEntity> extends NavTreeNodeChildLoador<String, B, VradiTreeNode> {

    protected AbstractVradiNodeLoadors(Class<B> beanType) {
        super(beanType);
    }

    public WikittyProxy getProxy(NavDataProvider dataProvider) {
        return ((VradiDataProvider) dataProvider).getWikittyProxy();
    }

    public VradiDataService getDataService(NavDataProvider dataProvider) {
        return ((VradiDataProvider) dataProvider).getVradiDataService();
    }
    
    public VradiTreeNode createVradiNode(String id) {

        return new VradiTreeNode(
                getBeanType(),
                id,
                null,
                null);
    }

    public VradiTreeNode createVradiNode(String id, NavTreeNodeChildLoador<?, ?, VradiTreeNode> childLoador) {

        return new VradiTreeNode(
                getBeanType(),
                id,
                null,
                childLoador);
    }

    protected List<String> extractIds(List<B> entities) {
        List<String> ids = new ArrayList<String>();
        if (entities == null) {
            return ids;
        }
        for (BusinessEntity e : entities) {
            if (e != null) {
                ids.add(e.getWikittyId());   
            }
        }
        return ids;
    }
}
