package com.jurismarches.vradi.ui.tree;

import jaxx.runtime.swing.nav.tree.NavTreeNode;
import jaxx.runtime.swing.nav.tree.NavTreeNodeChildLoador;

/**
 * Vradi node use to fill vradi tree.
 * <p/>
 * User: sletellier
 */
public class VradiTreeNode extends NavTreeNode<VradiTreeNode> {

    private static final long serialVersionUID = 1L;

    public VradiTreeNode(String id) {
        super(id);
    }

    public VradiTreeNode(Class<?> internalClass,
                            String id,
                            String context,
                            NavTreeNodeChildLoador<?, ?, VradiTreeNode> loador) {
        super(internalClass, id, context, loador);
    }

    @Override
    @SuppressWarnings({"unchecked"})
    public VradiTreeNode getContainerNode() {
        if (isRoot()) {
            // si on arrive sur le root, quelque chose ne va pas,
            // on bloque par null, a defaut de declancher une exception
            return this;
        }
        
        // cas final : sur un noeud de donnee + classe interne de donnee
        return super.getContainerNode();
    }
}