package com.jurismarches.vradi.ui.offer.thesaurus.loadors;

import com.jurismarches.vradi.entities.RootThesaurus;
import com.jurismarches.vradi.ui.helpers.ThesaurusDataHelper;
import com.jurismarches.vradi.ui.helpers.VradiComparators;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import com.jurismarches.vradi.entities.Thesaurus;
import jaxx.runtime.swing.nav.NavDataProvider;
import jaxx.runtime.swing.nav.NavHelper;
import jaxx.runtime.swing.nav.tree.NavTreeNodeChildLoador;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.BusinessEntity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * @author letellier
 */
public class ThesaurusNodeLoadors extends NavTreeNodeChildLoador<String, Thesaurus, VradiTreeNode> {

    /** Logger */
    static private final Log log =
            LogFactory.getLog(ThesaurusNodeLoadors.class);

    public ThesaurusNodeLoadors() {
        super(Thesaurus.class);
    }

    @Override
    public List<String> getData(Class<?> parentClass, String parentId, NavDataProvider dataProvider) throws Exception {

        // If parent is root
        if (RootThesaurus.class.equals(parentClass)) {
            List<Thesaurus> thesauruses = ThesaurusDataHelper.getChildrenOfRootThesaurus(parentId);

            Collections.sort(thesauruses,  VradiComparators.THESAURUS_COMPARATOR);
            return extractIds(thesauruses);
        }

        // Return children
        List<Thesaurus> childrenOfThesaurus = ThesaurusDataHelper.getChildrenOfThesaurus(parentId);
        
        Collections.sort(childrenOfThesaurus,  VradiComparators.THESAURUS_COMPARATOR);

        return extractIds(childrenOfThesaurus);
    }

    @Override
    public VradiTreeNode createNode(String id, NavDataProvider dataProvider) {

        if (log.isDebugEnabled()) {
            log.debug("[Thesaurus loador] creating thesaurus " + id);
        }

        return new VradiTreeNode(
                    getBeanType(),
                    id,
                    null,
                    NavHelper.getChildLoador(ThesaurusNodeLoadors.class)
            );
    }

    public List<String> extractIds(List<? extends BusinessEntity> entities) {
        List<String> ids = new ArrayList<String>();
        for (BusinessEntity e : entities) {
            ids.add(e.getWikittyId());
        }
        return ids;
    }
}