package com.jurismarches.vradi.ui.email.loadors;

import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.helpers.VradiComparators;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import jaxx.runtime.swing.nav.NavDataProvider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/**
 * @author sletellier <letellier@codelutin.com>
 */
public class EmailFormNodeLoadors extends AbstractEmailNodeLoador<Form> {

    public EmailFormNodeLoadors() {
        super(Form.class);
    }

    @Override
    public List<String> getData(Class<?> parentClass, String parentId, NavDataProvider dataProvider) throws Exception {

        // Get sending of session
        List<Sending> sendings = getSendingList(dataProvider, parentId);

        // Extract clients ids
        List<String> formIds = new ArrayList<String>();
        for (Sending sending : sendings) {
            Set<String> formsIds = sending.getForm();
            if (formsIds != null) {
                formIds.addAll(formsIds);
            }
        }

        // Sort
        List<Form> formSorted = VradiService.getWikittyProxy().restore(Form.class, formIds);
        Collections.sort(formSorted,  VradiComparators.FORM_COMPARATOR);

        // Return forms
        return extractIds(formSorted);
    }

    @Override
    public VradiTreeNode createNode(String id, NavDataProvider dataProvider) {
        return createVradiNode(id);
    }
}
