package com.jurismarches.vradi.ui.email.helpers;

import com.jurismarches.vradi.entities.QueryMaker;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.Session;
import com.jurismarches.vradi.services.VradiService;
import org.nuiton.wikitty.WikittyProxy;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/**
 * @author sletellier <letellier@codelutin.com>
 */
public class EmailDataHelper {

    protected static WikittyProxy getProxy() {
        return VradiService.getWikittyProxy();
    }

    public static Sending getSending(Session session, QueryMaker queryMaker) {
        String id = queryMaker.getWikittyId();
        return getSending(session, id);
    }

    public static Sending getSending(Session session, String id) {
        Set<String> sendingIdsSet = session.getSending();
        if (sendingIdsSet == null) {
            return null;
        }
        List<String> sendingIds = new ArrayList<String>(sendingIdsSet);
        List<Sending> sendings = getProxy().restore(Sending.class, sendingIds);
        for (Sending sending : sendings) {
            if (id.equals(sending.getUser()) ||
                id.equals(sending.getGroup())) {

                return sending;
            }
        }
        return null;
    }

    public static int getNbFormToSend(Session session, QueryMaker bean) {
        Sending sending = getSending(session, bean);
        Set<String> formIds = sending.getForm();
        return formIds == null ? 0 : formIds.size();
    }

    public static int getNbFormToSend(Session session) {
        Set<String> sendingIdsSet = session.getSending();
        if (sendingIdsSet == null) {
            return 0;
        }
        int result = 0;
        List<String> sendingIds = new ArrayList<String>(sendingIdsSet);
        List<Sending> sendings = getProxy().restore(Sending.class, sendingIds);
        for (Sending sending : sendings) {
            Set<String> formsIds = sending.getForm();
            result = (formsIds == null ? 0 : formsIds.size()) + result;
        }
        return result;
    }
}
