package com.jurismarches.vradi.ui.email;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.email.*;
import com.jurismarches.vradi.ui.email.renderers.SendingRenderer;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.renderers.EntityRenderer;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceEvent;
import org.nuiton.wikitty.WikittyServiceListener;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class QueryMakerViewUI<E extends QueryMaker> extends javax.swing.JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_BEAN_LIST = "beanList";
    public static final String PROPERTY_CLAZZ = "clazz";
    public static final String PROPERTY_SESSION = "session";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1UPW8TQRAdX+LPQBKIiBIRJAORgijO9I5CUJAVIwcEVlCEG9Z3q3jN3e1mdy8+p0D8BH4C9DRIdFSIgpqCBvEXEKKgRcyePy4xFyVX3MfuvLdv3szcu5+QVRKud0kU2TIMNPOp/eDe3t6jdpc6+j5VjmRCcwmDK2OB1YIZd7yuNNxsNQy8MoRXtrgveECDY+hqA0pK9z2qOpRqDddOIhylKs3xdjUSoRyxjkWlsb75/ct67b56awFEAtXlMJXyWagkk+kGWMzVcBlPOiQVjwT7KEOyYB/1XjRrWx5R6iHx6QG8hHwDcoJIJNNw4/wpxxwxPhIa5g9CKvs75AWVTxnt7dY13HG4b3dDyZRPpNOhyj6UxGV2yGzqE+bZjycgQsR8OQ15RZViPNCwdgoJamKa4WdzEJlgs45Hjo40zJlEbZO8HUtNIqbblCD16lnUNS79BFUwqAZT6NJsTB1qzMEsJDGziQsGrCcaUPWwBjGkST1sQy536wZZFFjgqydCsXXspHWS2mZakJUhLmtYav3fbU9wa9BnSxN9Zgjj3b+LC98+/vhQGzXXFJ59JTX02Gxg0YXkgkpjDHo76CzjQGWHiGoLimqYEe6upAgbJYzi8LxLiYHbRHWQIpv//unz4vOvU2DVoORx4taIia9DUXckusA9NxJ3N2NFF3oFvM8bbRpyHunz0FRl3SWalNsscNHmjQhNWEkxYaykXfzyZ6H5fnNkRAaFLZ8anpiRfQY5FngsoPGcDUcoda5mhKKhy5NRSRuejHmWxLCLyvF9NS3TAs6oSyWVJmItCs3jVizcvN2OeZbPwVNEN3vbzOUS/xHrg1TKROMfoh1qunE68T8InVFhVgUAAA==";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.email.QueryMakerViewUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected com.jurismarches.vradi.entities.Form bean;
    protected java.util.List< Form > beanList;
    protected java.lang.Class< E > clazz;
    protected jaxx.runtime.swing.ListSelectorUI< E > queryMakerForm;
    protected QueryMakerViewUI queryMakerViewUI = this;
    protected com.jurismarches.vradi.entities.Session session;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
    
        // Add completion
        AutoCompleteDecorator.decorate(queryMakerForm.getCombo(), EntityRenderer.getInstance());
    
        JButton addButton = queryMakerForm.getAdd();
    
        // Add own
        addButton.addActionListener(new ActionListener(){
    
            @Override
            public void actionPerformed(ActionEvent e) {
                if (getBean() != null) {
                    getHandler().addQueryMaker(QueryMakerViewUI.this, session, getBean(), (E)queryMakerForm.getCombo().getSelectedItem());
                } else {
                    getHandler().addQueryMaker(QueryMakerViewUI.this, session, getBeanList(), (E)queryMakerForm.getCombo().getSelectedItem());
                }
            }
        });
    
        JButton removeButton = queryMakerForm.getRemove();
        
        // Add own
        removeButton.addActionListener(new ActionListener(){
    
            @Override
            public void actionPerformed(ActionEvent e) {
    
                if (getBean() != null) {
                    getHandler().removeQueryMaker(QueryMakerViewUI.this, session, getBean(), clazz, queryMakerForm.getList().getSelectedValues());
                } else {
                    getHandler().removeQueryMaker(QueryMakerViewUI.this, session, getBeanList(), clazz, queryMakerForm.getList().getSelectedValues());
                }
            }
        });
    
    
        if (!isEmailUI()) {
            return;
        }
    
        // Remove default listener
        addButton.removeActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", queryMakerForm, "doActionPerformed__on__add"));
    
        // Remove default listener
        removeButton.removeActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", queryMakerForm, "doActionPerformed__on__remove"));
    
    
        // register each tree on wikitty service
        VradiService.getWikittyService().addWikittyServiceListener(new WikittyServiceListener(){
    
            @Override
            public void putWikitty(WikittyServiceEvent event) {
                 applyChange(event);
            }
    
            @Override
            public void removeWikitty(WikittyServiceEvent event) {
                 applyChange(event);
            }
    
            @Override
            public void clearWikitty(WikittyServiceEvent event) {
                 applyChange(event);
            }
    
            @Override
            public void putExtension(WikittyServiceEvent event) {
            }
    
            @Override
            public void removeExtension(WikittyServiceEvent event) {
            }
    
            @Override
            public void clearExtension(WikittyServiceEvent event) {
            }
    
            protected void applyChange(WikittyServiceEvent event) {
    
                // map between id and extensions "name" (not extension ids)
                Map<String, Set<String>> idAndExtensions = event.getIdExtensions();
                for (String wikittyId : event.getIds()) {
                    Set<String> wikittyExtensions = idAndExtensions.get(wikittyId);
    
                    // Session
                    if (wikittyExtensions.contains(Session.EXT_SESSION) ||
                            wikittyExtensions.contains(Sending.EXT_SENDING)) {
    
                        Session sessionRestored = VradiService.getWikittyProxy().restore(Session.class, session.getWikittyId());
                        updateSession(sessionRestored);
                    }
                }
            }
        }, WikittyService.ServiceListenerType.ALL);
    }
    
    public void init(java.util.List<E> toCombo, java.util.List<E> toList) {
         queryMakerForm.init(toCombo, toList);
    }
    
    protected void updateSession(Session sessionRestored) {
        getParentContainer(FormViewUI.class).updateSession(sessionRestored);
    }
    
    protected boolean isEmailUI() {
        return getParentContainer(FormViewUI.class) != null;
    }
    
    protected EmailHandler getHandler() {
        return UIHelper.getHandler(this, EmailHandler.class);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public QueryMakerViewUI() {
        $initialize();
    }

    public QueryMakerViewUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public com.jurismarches.vradi.entities.Form getBean() {
        return bean;
    }

    public java.util.List< Form > getBeanList() {
        return beanList;
    }

    public java.lang.Class< E > getClazz() {
        return clazz;
    }

    public jaxx.runtime.swing.ListSelectorUI< E > getQueryMakerForm() {
        return queryMakerForm;
    }

    public com.jurismarches.vradi.entities.Session getSession() {
        return session;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(com.jurismarches.vradi.entities.Form newValue) {
        com.jurismarches.vradi.entities.Form oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    public void setBeanList(java.util.List< Form > newValue) {
        java.util.List< Form > oldValue = this.beanList;
        this.beanList = newValue;
        firePropertyChange(PROPERTY_BEAN_LIST, oldValue, newValue);
    }

    public void setClazz(java.lang.Class< E > newValue) {
        java.lang.Class< E > oldValue = this.clazz;
        this.clazz = newValue;
        firePropertyChange(PROPERTY_CLAZZ, oldValue, newValue);
    }

    public void setSession(com.jurismarches.vradi.entities.Session newValue) {
        com.jurismarches.vradi.entities.Session oldValue = this.session;
        this.session = newValue;
        firePropertyChange(PROPERTY_SESSION, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToQueryMakerViewUI() {
        if (!allComponentsCreated) {
            return;
        }
        add(queryMakerForm, BorderLayout.CENTER);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createBeanList() {
        $objectMap.put("beanList", beanList = null);
    }

    protected void createClazz() {
        $objectMap.put("clazz", clazz = null);
    }

    protected void createQueryMakerForm() {
        $objectMap.put("queryMakerForm", queryMakerForm = new jaxx.runtime.swing.ListSelectorUI< E >());
        
        queryMakerForm.setName("queryMakerForm");
        queryMakerForm.setShowHidor(false);
    }

    protected void createSession() {
        $objectMap.put("session", session = null);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToQueryMakerViewUI();
        
        // apply 2 property setters
        queryMakerForm.setRenderer(new EntityRenderer());
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("queryMakerViewUI", this);
        createSession();
        createClazz();
        createBean();
        createBeanList();
        createQueryMakerForm();
        // inline creation of queryMakerViewUI
        setName("queryMakerViewUI");
        setLayout(new BorderLayout());
        
        $completeSetup();
    }

}