package com.jurismarches.vradi.ui.admin.loadors;

import com.jurismarches.vradi.entities.RootThesaurus;
import com.jurismarches.vradi.ui.helpers.ThesaurusDataHelper;
import com.jurismarches.vradi.ui.helpers.VradiComparators;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.ui.tree.VradiTreeTableNode;
import com.jurismarches.vradi.ui.offer.thesaurus.loadors.ThesaurusNodeLoadors;
import jaxx.runtime.swing.nav.NavDataProvider;
import jaxx.runtime.swing.nav.NavHelper;
import jaxx.runtime.swing.nav.treetable.NavTreeTableNodeChildLoador;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.BusinessEntity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * @author letellier
 */
public class ThesaurusTreeTableNodeLoadors extends NavTreeTableNodeChildLoador<String, Thesaurus, VradiTreeTableNode> {

    /** Logger */
    static private final Log log =
            LogFactory.getLog(ThesaurusNodeLoadors.class);

    public ThesaurusTreeTableNodeLoadors() {
        super(Thesaurus.class);
    }

    @Override
    public List<String> getData(Class<?> parentClass, String parentId, NavDataProvider dataProvider) throws Exception {

        // If parent is root
        if (RootThesaurus.class.equals(parentClass)) {
            List<Thesaurus> thesauruses = ThesaurusDataHelper.getChildrenOfRootThesaurus(parentId);

            if (log.isDebugEnabled()) {
                RootThesaurus root = ThesaurusDataHelper.restoreRootThesaurus(parentId);
                for (Thesaurus thesaurus : thesauruses) {
                    log.debug("Children of root thesaurus " + root.getName() + " find : " + thesaurus.getName());
                }
            }
            Collections.sort(thesauruses,  VradiComparators.THESAURUS_COMPARATOR);
            return extractIds(thesauruses);
        }

        // Return children
        List<Thesaurus> childrenOfThesaurus = ThesaurusDataHelper.getChildrenOfThesaurus(parentId);
        if (log.isDebugEnabled()) {
            for (Thesaurus thesaurus : childrenOfThesaurus) {
                Thesaurus parent = ThesaurusDataHelper.restoreThesaurus(parentId);
                log.debug("Children of thesaurus " + parent.getName() + " found : " + thesaurus.getName());
            }
        }
        Collections.sort(childrenOfThesaurus,  VradiComparators.THESAURUS_COMPARATOR);
        
        return extractIds(childrenOfThesaurus);
    }

    @Override
    public VradiTreeTableNode createNode(String id, NavDataProvider dataProvider) {

        return new VradiTreeTableNode(
                    getBeanType(),
                    id,
                    null,
                    NavHelper.getChildLoador(ThesaurusTreeTableNodeLoadors.class)
            );
    }

    public List<String> extractIds(List<? extends BusinessEntity> entities) {
        List<String> ids = new ArrayList<String>();
        for (BusinessEntity e : entities) {
            if (e != null) {
                ids.add(e.getWikittyId());
            }
        }
        return ids;
    }
}