package com.jurismarches.vradi.ui.admin.loadors;

import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.services.VradiDataService;
import com.jurismarches.vradi.ui.helpers.VradiComparators;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;

import java.util.Collections;
import java.util.List;

import com.jurismarches.vradi.ui.tree.loadors.AbstractVradiNodeLoadors;
import jaxx.runtime.swing.nav.NavDataProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author letellier
 */
public class StreamNodeLoadors extends AbstractVradiNodeLoadors<XmlStream> {

    /** serialVersionUID. */
    private static final long serialVersionUID = -7828183287422107044L;

    /** Logger */
    static private final Log log = LogFactory.getLog(StreamNodeLoadors.class);

    public StreamNodeLoadors() {
        super(XmlStream.class);
    }

    @Override
    public List<String> getData(Class<?> parentClass, String parentId, NavDataProvider dataProvider) throws Exception {
        // FIXME EC20100628 : only get id here (wikitty entities not needed)
        VradiDataService dataService = getDataService(dataProvider);
        
        List<XmlStream> streamList = dataService.findAllXmlStreams();
        Collections.sort(streamList, VradiComparators.XML_STREAM_COMPARATOR);

        return extractIds(streamList);
    }

    @Override
    public VradiTreeNode createNode(String id, NavDataProvider dataProvider) {
        return createVradiNode(id);
    }
}