package com.jurismarches.vradi.ui.admin.loadors;

import java.util.Collections;
import java.util.List;

import com.jurismarches.vradi.ui.helpers.VradiComparators;
import com.jurismarches.vradi.ui.tree.loadors.AbstractVradiNodeLoadors;
import jaxx.runtime.swing.nav.NavDataProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.services.VradiDataService;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;

/**
 * @author letellier
 */
public class ClientUsersNodeLoadors extends AbstractVradiNodeLoadors<User> {

    /** serialVersionUID. */
    private static final long serialVersionUID = 6834221183179682758L;

    /** Logger */
    static private final Log log = LogFactory.getLog(ClientUsersNodeLoadors.class);

    public ClientUsersNodeLoadors() {
        super(User.class);
    }

    @Override
    public List<String> getData(Class<?> parentClass, String parentId, NavDataProvider dataProvider) throws Exception {

        if (parentId == null) {
            return null;
        }

        VradiDataService dataService = getDataService(dataProvider);
        List<User> users = dataService.findClientUsers(parentId);

        // Return users of clients
        Collections.sort(users, VradiComparators.USER_COMPARATOR);
        return extractIds(users);
    }

    @Override
    public VradiTreeNode createNode(String id, NavDataProvider dataProvider) {
        return createVradiNode(id);
    }
}