/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.util;

import com.franciaflex.faxtomail.persistence.entities.HasLabel;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.i18n.I18n;

public abstract class CheckBoxListCellRenderer<HL extends HasLabel>
implements ListCellRenderer<Object>,
Serializable {
    private static final Border SAFE_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    private static final Border DEFAULT_NO_FOCUS_BORDER;
    protected static Border noFocusBorder;
    protected CheckBoxListCellRendererLabel label = new CheckBoxListCellRendererLabel();
    protected CheckBoxListCellRendererCheckBox checkbox = new CheckBoxListCellRendererCheckBox();

    public CheckBoxListCellRenderer() {
        this.label.setText("");
        this.label.setName("List.cellRenderer");
        this.checkbox.setName("List.cellRenderer");
    }

    private Border getNoFocusBorder() {
        Border border = UIManager.getBorder("List.cellNoFocusBorder");
        if (System.getSecurityManager() != null) {
            if (border != null) {
                return border;
            }
            return SAFE_NO_FOCUS_BORDER;
        }
        if (border != null && (noFocusBorder == null || noFocusBorder == DEFAULT_NO_FOCUS_BORDER)) {
            return border;
        }
        return noFocusBorder;
    }

    protected abstract boolean isCheckBoxSelected(Object var1);

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String decorate = "";
        JComponent component = this.label;
        final String noneLabel = I18n.t((String)"faxtomail.common.none.label", (Object[])new Object[0]);
        if (value == null || HasLabel.class.isAssignableFrom(value.getClass())) {
            decorate = value != null ? ((HasLabel)value).getLabel() : noneLabel;
            this.checkbox.setSelected(this.isCheckBoxSelected(value));
            this.checkbox.setText(decorate);
            component = this.checkbox;
        } else {
            if (value != null && List.class.isAssignableFrom(value.getClass())) {
                List etats = (List)value;
                List e = Lists.transform((List)etats, (Function)new Function<HL, String>(){

                    public String apply(HL input) {
                        return input != null ? input.getLabel() : noneLabel;
                    }
                });
                decorate = StringUtils.join((Iterable)e, (String)" ou ");
                this.label.setText(decorate);
            }
            Color bg = null;
            Color fg = null;
            JList.DropLocation dropLocation = list.getDropLocation();
            if (dropLocation != null && !dropLocation.isInsert() && dropLocation.getIndex() == index) {
                bg = UIManager.getColor("List.dropCellBackground");
                fg = UIManager.getColor("List.dropCellForeground");
                isSelected = true;
            }
            if (isSelected) {
                component.setBackground(bg == null ? list.getSelectionBackground() : bg);
                component.setForeground(fg == null ? list.getSelectionForeground() : fg);
            } else {
                component.setBackground(list.getBackground());
                component.setForeground(list.getForeground());
            }
        }
        component.setComponentOrientation(list.getComponentOrientation());
        component.setEnabled(list.isEnabled());
        component.setFont(list.getFont());
        Border border = null;
        if (cellHasFocus) {
            if (isSelected) {
                border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("List.focusCellHighlightBorder");
            }
        } else {
            border = this.getNoFocusBorder();
        }
        component.setBorder(border);
        return component;
    }

    static {
        noFocusBorder = DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    }

    public static class UIResource
    extends DefaultListCellRenderer
    implements javax.swing.plaf.UIResource {
    }

    protected class CheckBoxListCellRendererCheckBox
    extends JCheckBox {
        protected CheckBoxListCellRendererCheckBox() {
        }

        @Override
        public boolean isOpaque() {
            Color back = this.getBackground();
            Container p = this.getParent();
            if (p != null) {
                p = p.getParent();
            }
            boolean colorMatch = back != null && p != null && back.equals(p.getBackground()) && p.isOpaque();
            return !colorMatch && super.isOpaque();
        }

        @Override
        public void validate() {
        }

        @Override
        public void invalidate() {
        }

        @Override
        public void repaint() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void repaint(long tm, int x, int y, int width, int height) {
        }

        @Override
        public void repaint(Rectangle r) {
        }

        @Override
        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            if (propertyName == "text" || (propertyName == "font" || propertyName == "foreground") && oldValue != newValue && this.getClientProperty("html") != null) {
                super.firePropertyChange(propertyName, oldValue, newValue);
            }
        }

        @Override
        public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, char oldValue, char newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, short oldValue, short newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, long oldValue, long newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, float oldValue, float newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, double oldValue, double newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }

    protected class CheckBoxListCellRendererLabel
    extends JLabel {
        protected CheckBoxListCellRendererLabel() {
        }

        @Override
        public boolean isOpaque() {
            Color back = this.getBackground();
            Container p = this.getParent();
            if (p != null) {
                p = p.getParent();
            }
            boolean colorMatch = back != null && p != null && back.equals(p.getBackground()) && p.isOpaque();
            return !colorMatch && super.isOpaque();
        }

        @Override
        public void validate() {
        }

        @Override
        public void invalidate() {
        }

        @Override
        public void repaint() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void repaint(long tm, int x, int y, int width, int height) {
        }

        @Override
        public void repaint(Rectangle r) {
        }

        @Override
        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            if (propertyName == "text" || (propertyName == "font" || propertyName == "foreground") && oldValue != newValue && this.getClientProperty("html") != null) {
                super.firePropertyChange(propertyName, oldValue, newValue);
            }
        }

        @Override
        public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, char oldValue, char newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, short oldValue, short newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, long oldValue, long newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, float oldValue, float newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, double oldValue, double newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }
}

