/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.metadata;

import java.io.Serializable;
import java.util.Date;
import org.nuiton.topia.persistence.TopiaEntity;

public class ColumnMeta
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected Class<?> type;

    protected static ColumnMeta newMeta(String name, Class<?> type) {
        return new ColumnMeta(name, type);
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getTypeSimpleName() {
        return this.type.getSimpleName();
    }

    public String getColumnType() {
        String result = "string";
        if (Boolean.TYPE.equals(this.type)) {
            result = "boolean";
        } else if (Date.class.equals(this.type)) {
            result = "date";
        }
        return result;
    }

    public boolean isFK() {
        return TopiaEntity.class.isAssignableFrom(this.type);
    }

    public boolean isDate() {
        return Date.class.isAssignableFrom(this.type);
    }

    public boolean isBoolean() {
        return Boolean.TYPE.equals(this.type);
    }

    public boolean isNumber() {
        return !this.isBoolean() && (this.type.isPrimitive() || Number.class.isAssignableFrom(this.type));
    }

    protected ColumnMeta(String name, Class<?> type) {
        this.name = name;
        this.type = type;
    }
}

