/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.print;

import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.persistence.entities.AttachmentFile;
import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.services.FaxToMailServiceContext;
import com.franciaflex.faxtomail.services.service.EmailService;
import com.franciaflex.faxtomail.ui.swing.actions.PrintOnDefaultPrinterAction;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.print.AttachmentToPrintChooserUI;
import com.franciaflex.faxtomail.ui.swing.content.print.AttachmentToPrintChooserUIModel;
import com.franciaflex.faxtomail.ui.swing.util.AbstractFaxToMailUIHandler;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.application.swing.action.AbstractApplicationAction;
import org.nuiton.jaxx.application.swing.util.Cancelable;

public class AttachmentToPrintChooserUIHandler
extends AbstractFaxToMailUIHandler<AttachmentToPrintChooserUIModel, AttachmentToPrintChooserUI>
implements Cancelable {
    private static final Log log = LogFactory.getLog(AttachmentToPrintChooserUIHandler.class);

    public void afterInit(AttachmentToPrintChooserUI attachmentToPrintChooserUI) {
        this.initUI(attachmentToPrintChooserUI);
        AttachmentToPrintChooserUIModel model = (AttachmentToPrintChooserUIModel)((Object)this.getModel());
        DemandeUIModel demand = model.getDemand();
        FaxToMailServiceContext serviceContext = this.getContext().newServiceContext();
        EmailService emailService = serviceContext.getEmailService();
        Email email = ((AttachmentToPrintChooserUIModel)((Object)this.getModel())).getDemand().toEntity();
        final AttachmentFile demandDetailAttachment = emailService.getEmailDetailAsAttachment(email);
        JCheckBox checkBox = new JCheckBox(demandDetailAttachment.getFilename(), true);
        ((AttachmentToPrintChooserUI)this.ui).getAttachmentPanel().add(checkBox);
        ((AttachmentToPrintChooserUIModel)((Object)this.getModel())).addAttachmentToPrint(demandDetailAttachment);
        checkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                log.info((Object)("state changed " + e.getStateChange()));
                if (e.getStateChange() == 1) {
                    ((AttachmentToPrintChooserUIModel)((Object)AttachmentToPrintChooserUIHandler.this.getModel())).addAttachmentToPrint(demandDetailAttachment);
                } else {
                    ((AttachmentToPrintChooserUIModel)((Object)AttachmentToPrintChooserUIHandler.this.getModel())).removeAttachmentToPrint(demandDetailAttachment);
                }
            }
        });
        for (Attachment attachment : demand.getAttachment()) {
            if (attachment.getOriginalFile() == null) {
                FaxToMailUIUtil.forceAttachmentFileLoading(this.getContext(), attachment);
            }
            this.createCheckBox(attachment.getOriginalFile());
            AttachmentFile file = attachment.getEditedFile();
            if (file == null) continue;
            this.createCheckBox(file);
        }
    }

    protected void createCheckBox(final AttachmentFile attachmentFile) {
        if (attachmentFile == null) {
            return;
        }
        String attachmentName = attachmentFile.getFilename();
        boolean printable = FaxToMailUIUtil.isFileTypeEditable(attachmentName);
        JCheckBox checkBox = new JCheckBox(attachmentName, printable);
        checkBox.setEnabled(printable);
        ((AttachmentToPrintChooserUI)this.ui).getAttachmentPanel().add(checkBox);
        if (printable) {
            ((AttachmentToPrintChooserUIModel)((Object)this.getModel())).addAttachmentToPrint(attachmentFile);
            checkBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    log.info((Object)("state changed " + e.getStateChange()));
                    if (e.getStateChange() == 1) {
                        ((AttachmentToPrintChooserUIModel)((Object)AttachmentToPrintChooserUIHandler.this.getModel())).addAttachmentToPrint(attachmentFile);
                    } else {
                        ((AttachmentToPrintChooserUIModel)((Object)AttachmentToPrintChooserUIHandler.this.getModel())).removeAttachmentToPrint(attachmentFile);
                    }
                }
            });
        }
    }

    public void onCloseUI() {
    }

    public SwingValidator<AttachmentToPrintChooserUIModel> getValidator() {
        return null;
    }

    public void cancel() {
        this.closeFrame();
    }

    protected JComponent getComponentToFocus() {
        return ((AttachmentToPrintChooserUI)this.ui).getAttachmentPanel();
    }

    @Override
    public Component getTopestUI() {
        return (Component)this.getUI();
    }

    public void print() {
        HashMultimap attachmentToPrints = HashMultimap.create();
        attachmentToPrints.putAll((Object)((AttachmentToPrintChooserUIModel)((Object)this.getModel())).getDemand(), ((AttachmentToPrintChooserUIModel)((Object)this.getModel())).getAttachmentsToPrint());
        PrintOnDefaultPrinterAction action = new PrintOnDefaultPrinterAction(this, (Multimap)attachmentToPrints, false, false){

            @Override
            public void postSuccessAction() {
                super.postSuccessAction();
                AttachmentToPrintChooserUIHandler.this.closeFrame();
            }
        };
        this.getContext().getActionEngine().runAction((AbstractApplicationAction)action);
    }
}

