/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.demande.replies;

import com.franciaflex.faxtomail.persistence.entities.Reply;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import jaxx.runtime.SwingUtil;
import org.apache.commons.collections.CollectionUtils;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;

public class RepliesCellRenderer
extends DefaultTableCellRenderer {
    public static final String TEXT_PATTERN = "<html><body>%s</body></html>";
    private static final long serialVersionUID = 1L;
    private final String noneText;
    private final Decorator<Reply> decorator;

    public static RepliesCellRenderer newRender(Decorator<Reply> decorator) {
        return new RepliesCellRenderer(decorator);
    }

    protected RepliesCellRenderer(Decorator<Reply> decorator) {
        this.setHorizontalAlignment(0);
        this.setIcon(SwingUtil.createActionIcon((String)"reply"));
        this.noneText = I18n.n((String)"faxtomail.demandReplies.empty", (Object[])new Object[0]);
        this.decorator = decorator;
    }

    @Override
    protected void setValue(Object value) {
    }

    @Override
    public JComponent getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String toolTipTextValue;
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        List replies = (List)value;
        if (CollectionUtils.isEmpty((Collection)replies)) {
            toolTipTextValue = "<i>" + I18n.t((String)this.noneText, (Object[])new Object[0]) + "</i>";
        } else {
            StringBuilder sb = new StringBuilder();
            for (Reply reply : replies) {
                sb.append("<br/>").append(this.decorator.toString((Object)reply));
            }
            toolTipTextValue = sb.substring(5);
        }
        String textValue = I18n.t((String)"faxtomail.demandRepliesCellRenderer.text", (Object[])new Object[]{replies != null ? replies.size() : 0});
        boolean editable = table.isCellEditable(row, column);
        toolTipTextValue = String.format(TEXT_PATTERN, toolTipTextValue);
        this.setEnabled(editable);
        this.setText(textValue);
        this.setToolTipText(toolTipTextValue);
        return this;
    }
}

