/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.attachment;

import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.content.attachment.AttachmentEditorUI;
import com.franciaflex.faxtomail.ui.swing.content.attachment.AttachmentEditorUIModel;
import com.franciaflex.faxtomail.ui.swing.content.attachment.AttachmentModelAware;
import com.franciaflex.faxtomail.ui.swing.util.AbstractToolbarPopupButton;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.nuiton.i18n.I18n;

public class ButtonAttachment
extends AbstractToolbarPopupButton<AttachmentEditorUI> {
    protected AttachmentModelAware attachmentModelAware;
    protected String textKey;
    private PropertyChangeListener listener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            List attachments = (List)evt.getNewValue();
            ButtonAttachment.this.setText(ButtonAttachment.this.getButtonText(attachments));
            if (ButtonAttachment.this.attachmentModelAware != null) {
                List oldValue = (List)evt.getOldValue();
                Collection toAdd = CollectionUtils.subtract((Iterable)attachments, (Iterable)oldValue);
                ButtonAttachment.this.attachmentModelAware.addAllAttachment(toAdd);
                Collection toRemove = CollectionUtils.subtract((Iterable)oldValue, (Iterable)attachments);
                for (Attachment attachment : toRemove) {
                    ButtonAttachment.this.attachmentModelAware.removeAttachment(attachment);
                }
            }
        }
    };

    public ButtonAttachment(AttachmentModelAware model) {
        this("faxtomail.attachmentEditor.text", model);
    }

    public ButtonAttachment(String textKey, AttachmentModelAware model) {
        this.textKey = textKey;
        this.setToolTipText(I18n.t((String)"faxtomail.attachmentEditor.action.tip", (Object[])new Object[0]));
        this.init(model);
    }

    @Override
    protected String getActionIcon() {
        return "attachment";
    }

    @Override
    protected AttachmentEditorUI createNewPopup() {
        return new AttachmentEditorUI(FaxToMailUIContext.getApplicationContext());
    }

    public String getButtonText(Collection<Attachment> attachments) {
        int attachmentNb = CollectionUtils.size(attachments);
        return I18n.t((String)this.textKey, (Object[])new Object[]{attachmentNb});
    }

    public void init(AttachmentModelAware model) {
        this.attachmentModelAware = model;
        ((AttachmentEditorUI)this.popup).getModel().removePropertyChangeListener("attachment", this.listener);
        ((AttachmentEditorUI)this.popup).getModel().fromEntity(model);
        ((AttachmentEditorUI)this.popup).getModel().addPropertyChangeListener("attachment", this.listener);
        this.setText(this.getButtonText(model != null ? model.getAttachment() : null));
    }

    public AttachmentEditorUIModel getBean() {
        return ((AttachmentEditorUI)this.popup).getModel();
    }

    public void setEditable(boolean editable) {
        ((AttachmentEditorUI)this.popup).getModel().setEditable(editable);
    }
}

