/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.actions;

import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.persistence.entities.Range;
import com.franciaflex.faxtomail.persistence.entities.RangeRow;
import com.franciaflex.faxtomail.ui.swing.actions.AbstractFaxToMailAction;
import com.franciaflex.faxtomail.ui.swing.content.demande.QuantitiesByRangeUI;
import com.franciaflex.faxtomail.ui.swing.content.demande.QuantitiesByRangeUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.demande.QuantitiesByRangeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.demande.RangeRowModel;
import java.awt.Dimension;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ComputeQuantitiesByRangeAction
extends AbstractFaxToMailAction<QuantitiesByRangeUIModel, QuantitiesByRangeUI, QuantitiesByRangeUIHandler> {
    private static final Log log = LogFactory.getLog(ComputeQuantitiesByRangeAction.class);

    public ComputeQuantitiesByRangeAction(QuantitiesByRangeUIHandler handler) {
        super(handler, false);
        this.setActionDescription(I18n.t((String)"faxtomail.action.computeQuantitiesByRange.tip", (Object[])new Object[0]));
    }

    @Override
    public void doAction() throws Exception {
        HashMap<Range, RangeRowModel> quantitiesByRange = new HashMap<Range, RangeRowModel>();
        MailFolder folder = ((QuantitiesByRangeUIModel)this.getModel()).getRootFolder();
        List emails = this.getContext().getEmailService().getEmailForFolderAndSubfolders(folder);
        for (Email email : emails) {
            Collection rangeRows = email.getRangeRow();
            if (rangeRows == null) continue;
            for (RangeRow rangeRow : rangeRows) {
                Integer quotationQuantity;
                Integer savQuantity;
                Range range = rangeRow.getRange();
                RangeRowModel row = (RangeRowModel)((Object)quantitiesByRange.get(range));
                if (row == null) {
                    row = new RangeRowModel();
                    row.fromEntity(rangeRow);
                    quantitiesByRange.put(range, row);
                    continue;
                }
                Integer productQuantity = rangeRow.getProductQuantity();
                if (productQuantity != null) {
                    row.setProductQuantity(row.getProductQuantity() + productQuantity);
                }
                if ((savQuantity = rangeRow.getSavQuantity()) != null) {
                    row.setSavQuantity(row.getSavQuantity() + savQuantity);
                }
                if ((quotationQuantity = rangeRow.getQuotationQuantity()) == null) continue;
                row.setQuotationQuantity(row.getQuotationQuantity() + quotationQuantity);
            }
        }
        ((QuantitiesByRangeUIModel)this.getModel()).setRangeRows(quantitiesByRange.values());
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        ((QuantitiesByRangeUIHandler)this.handler).openDialog(this.getUI(), I18n.t((String)"faxtomail.quantitiesByRange.title", (Object[])new Object[0]), new Dimension(350, 300));
    }
}

