/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing;

import com.franciaflex.faxtomail.FaxToMailConfiguration;
import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.actions.StartAction;
import com.franciaflex.faxtomail.ui.swing.content.MainUI;
import com.franciaflex.faxtomail.ui.swing.content.MainUIHandler;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailExceptionHandler;
import java.awt.Color;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.BorderUIResource;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.application.swing.AbstractApplicationUIHandler;
import org.nuiton.jaxx.application.swing.action.AbstractApplicationAction;

public class RunFaxToMail {
    private static final Log log = LogFactory.getLog(RunFaxToMail.class);
    public static final int NORMAL_EXIT_CODE = 0;
    public static final int UPATE_EXIT_CODE = 88;

    public static void main(String ... args) {
        FaxToMailUIContext context;
        FaxToMailConfiguration config;
        block6: {
            if (log.isInfoEnabled()) {
                log.info((Object)("Starting FaxToMail with arguments: " + Arrays.toString(args)));
            }
            config = new FaxToMailConfiguration("faxToMail.properties", args);
            context = FaxToMailUIContext.newContext(config);
            Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)((Object)new FaxToMailExceptionHandler(context.getErrorHelper())));
            context.init();
            try {
                SwingUtil.initNimbusLoookAndFeel();
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block6;
                log.warn((Object)"Failed to init nimbus look and feel", (Throwable)e);
            }
        }
        boolean reload = false;
        if (config.isFullLaunchMode() && log.isInfoEnabled()) {
            log.info((Object)"Full launch mode, try to update.");
        }
        if (!reload) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Will start FaxToMail...");
            }
            RunFaxToMail.startFaxToMail(context, true);
        }
    }

    public static void startFaxToMail(FaxToMailUIContext context, boolean openContext) {
        if (openContext) {
            context.open();
        }
        UIManager.put("Table.focusCellHighlightBorder", new BorderUIResource.LineBorderUIResource(Color.BLACK));
        final MainUI mainUI = new MainUI(context);
        context.addMessageNotifier(mainUI.getHandler());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                mainUI.setVisible(true);
            }
        });
        StartAction uiAction = (StartAction)context.getActionFactory().createLogicAction((AbstractApplicationUIHandler)mainUI.getHandler(), StartAction.class);
        context.getActionEngine().runAction((AbstractApplicationAction)uiAction);
    }

    public static void closeFaxToMail(MainUIHandler handler, Integer exitCode) {
        FaxToMailUIContext context;
        block3: {
            context = handler.getContext();
            handler.onCloseUI();
            try {
                context.getSwingSession().save();
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"error while saving the swing session", (Throwable)e);
            }
        }
        context.close();
        if (exitCode != null) {
            System.exit(exitCode);
        }
    }
}

