/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.services.service;

import com.franciaflex.faxtomail.persistence.entities.Client;
import com.franciaflex.faxtomail.persistence.entities.ClientTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.DemandType;
import com.franciaflex.faxtomail.persistence.entities.DemandTypeImpl;
import com.franciaflex.faxtomail.persistence.entities.DemandTypeTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.EmailAccount;
import com.franciaflex.faxtomail.persistence.entities.EmailAccountTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.EtatAttente;
import com.franciaflex.faxtomail.persistence.entities.EtatAttenteImpl;
import com.franciaflex.faxtomail.persistence.entities.EtatAttenteTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.MailFilter;
import com.franciaflex.faxtomail.persistence.entities.MailFilterTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.persistence.entities.Priority;
import com.franciaflex.faxtomail.persistence.entities.PriorityTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.Range;
import com.franciaflex.faxtomail.persistence.entities.RangeTopiaDao;
import com.franciaflex.faxtomail.services.FaxToMailServiceSupport;
import com.franciaflex.faxtomail.services.service.imports.ClientImportModel;
import com.franciaflex.faxtomail.services.service.imports.DemandTypeImportModel;
import com.franciaflex.faxtomail.services.service.imports.EmailAccountImportModel;
import com.franciaflex.faxtomail.services.service.imports.EmailFilterImportModel;
import com.franciaflex.faxtomail.services.service.imports.EtatAttenteImportModel;
import com.franciaflex.faxtomail.services.service.imports.PriorityImportModel;
import com.franciaflex.faxtomail.services.service.imports.RangeImportModel;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Import;
import org.nuiton.csv.ImportModel;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.jaxx.application.ApplicationTechnicalException;
import org.nuiton.topia.persistence.TopiaEntities;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class ReferentielService
extends FaxToMailServiceSupport {
    private static final Log log = LogFactory.getLog(ReferentielService.class);

    public List<DemandType> getAllDemandType() {
        DemandTypeTopiaDao dao = this.getPersistenceContext().getDemandTypeDao();
        return new ArrayList<DemandType>(dao.findAll());
    }

    public List<Priority> getAllPriority() {
        PriorityTopiaDao dao = this.getPersistenceContext().getPriorityDao();
        return new ArrayList<Priority>(dao.findAll());
    }

    public List<Range> getAllRange() {
        RangeTopiaDao dao = this.getPersistenceContext().getRangeDao();
        return new ArrayList<Range>(dao.findAll());
    }

    public List<EtatAttente> getAllEtatAttente() {
        EtatAttenteTopiaDao dao = this.getPersistenceContext().getEtatAttenteDao();
        return new ArrayList<EtatAttente>(dao.findAll());
    }

    public Map<String, Long> getEtatAttentesUsage() {
        EtatAttenteTopiaDao dao = this.getPersistenceContext().getEtatAttenteDao();
        Map result = dao.getEtatAttenteCountByFolder();
        return result;
    }

    public void saveEtatAttente(Collection<EtatAttente> etatAttentes) {
        Binder binderEtatAttente = BinderFactory.newBinder(EtatAttente.class);
        EtatAttenteTopiaDao etatAttenteDAO = this.getPersistenceContext().getEtatAttenteDao();
        List<EtatAttente> allEtatAttente = this.getAllEtatAttente();
        HashMap allEtatAttenteIndex = new HashMap(Maps.uniqueIndex(allEtatAttente, (Function)TopiaEntities.getTopiaIdFunction()));
        for (EtatAttente etatAttente : etatAttentes) {
            Object currentEtatAttente = StringUtils.isBlank((CharSequence)etatAttente.getTopiaId()) || etatAttente.getTopiaId().startsWith("new_") ? new EtatAttenteImpl() : (EtatAttente)allEtatAttenteIndex.remove(etatAttente.getTopiaId());
            binderEtatAttente.copyExcluding((Object)etatAttente, currentEtatAttente, new String[]{"topiaId", "topiaCreateDate", "topiaVersion"});
            if (currentEtatAttente.isPersisted()) {
                etatAttenteDAO.update((TopiaEntity)currentEtatAttente);
                continue;
            }
            etatAttenteDAO.create((TopiaEntity)currentEtatAttente);
        }
        etatAttenteDAO.deleteAll(allEtatAttenteIndex.values());
        this.getPersistenceContext().commit();
    }

    public void saveDemandTypes(List<DemandType> demandTypes) {
        Binder binderDemandType = BinderFactory.newBinder(DemandType.class);
        DemandTypeTopiaDao demandTypeDAO = this.getPersistenceContext().getDemandTypeDao();
        List<DemandType> allDemandType = this.getAllDemandType();
        HashMap allDemandTypeIndex = new HashMap(Maps.uniqueIndex(allDemandType, (Function)TopiaEntities.getTopiaIdFunction()));
        for (DemandType demandType : demandTypes) {
            Object currentDemandType = StringUtils.isBlank((CharSequence)demandType.getTopiaId()) || demandType.getTopiaId().startsWith("new_") ? new DemandTypeImpl() : (DemandType)allDemandTypeIndex.remove(demandType.getTopiaId());
            binderDemandType.copyExcluding((Object)demandType, currentDemandType, new String[]{"topiaId", "topiaCreateDate", "topiaVersion"});
            if (currentDemandType.isPersisted()) {
                demandTypeDAO.update((TopiaEntity)currentDemandType);
                continue;
            }
            demandTypeDAO.create((TopiaEntity)currentDemandType);
        }
        this.getPersistenceContext().commit();
    }

    public List<Client> getAllClients() {
        ClientTopiaDao dao = this.getPersistenceContext().getClientDao();
        return new ArrayList<Client>(dao.findAll());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Client> importClients(InputStream inputStream) {
        ArrayList<Client> result = new ArrayList<Client>();
        ClientTopiaDao dao = this.getPersistenceContext().getClientDao();
        ClientImportModel clientImportModel = new ClientImportModel(';');
        try {
            Import importer = Import.newImport((ImportModel)clientImportModel, (InputStream)inputStream);
            try {
                for (Client client : importer) {
                    result.add((Client)dao.create((TopiaEntity)client));
                }
                this.getPersistenceContext().commit();
            }
            finally {
                IOUtils.closeQuietly((Closeable)importer);
            }
        }
        catch (ImportRuntimeException e) {
            String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new ApplicationTechnicalException(message, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return result;
    }

    public List<EmailAccount> importEmailAccounts(InputStream inputStream) {
        ArrayList<EmailAccount> result = new ArrayList<EmailAccount>();
        EmailAccountTopiaDao dao = this.getPersistenceContext().getEmailAccountDao();
        EmailAccountImportModel emailAccountImportModel = new EmailAccountImportModel(';');
        try (Import importer = Import.newImport((ImportModel)emailAccountImportModel, (InputStream)inputStream);){
            for (EmailAccount emailAccount : importer) {
                result.add((EmailAccount)dao.create((TopiaEntity)emailAccount));
            }
            this.getPersistenceContext().commit();
        }
        catch (ImportRuntimeException e) {
            String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new ApplicationTechnicalException(message, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return result;
    }

    public List<MailFilter> importEmailFilters(InputStream inputStream, Map<String, MailFolder> foldersByName) {
        ArrayList<MailFilter> result = new ArrayList<MailFilter>();
        MailFilterTopiaDao dao = this.getPersistenceContext().getMailFilterDao();
        EmailFilterImportModel emailFilterImportModel = new EmailFilterImportModel(';', foldersByName);
        try (Import importer = Import.newImport((ImportModel)emailFilterImportModel, (InputStream)inputStream);){
            for (MailFilter emailFilter : importer) {
                result.add((MailFilter)dao.create((TopiaEntity)emailFilter));
            }
            this.getPersistenceContext().commit();
        }
        catch (ImportRuntimeException e) {
            String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new ApplicationTechnicalException(message, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return result;
    }

    public List<EtatAttente> importEtatAttentes(InputStream inputStream) {
        ArrayList<EtatAttente> result = new ArrayList<EtatAttente>();
        EtatAttenteTopiaDao etatAttenteTopiaDao = this.getPersistenceContext().getEtatAttenteDao();
        EtatAttenteImportModel importModel = new EtatAttenteImportModel(';');
        try (Import importer = Import.newImport((ImportModel)importModel, (InputStream)inputStream);){
            for (EtatAttente etatAttente : importer) {
                EtatAttente currentEtatAttente = (EtatAttente)etatAttenteTopiaDao.forLabelEquals(etatAttente.getLabel()).findAnyOrNull();
                if (currentEtatAttente == null) {
                    currentEtatAttente = (EtatAttente)etatAttenteTopiaDao.create((TopiaEntity)etatAttente);
                }
                result.add(currentEtatAttente);
            }
            this.getPersistenceContext().commit();
        }
        catch (ImportRuntimeException e) {
            String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new ApplicationTechnicalException(message, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return result;
    }

    public List<Priority> importPriorities(InputStream inputStream) {
        ArrayList<Priority> result = new ArrayList<Priority>();
        PriorityTopiaDao priorityTopiaDao = this.getPersistenceContext().getPriorityDao();
        PriorityImportModel importModel = new PriorityImportModel(';');
        try (Import importer = Import.newImport((ImportModel)importModel, (InputStream)inputStream);){
            for (Priority priority : importer) {
                Priority currentPriority = (Priority)priorityTopiaDao.forLabelEquals(priority.getLabel()).findAnyOrNull();
                if (currentPriority == null) {
                    currentPriority = (Priority)priorityTopiaDao.create((TopiaEntity)priority);
                }
                result.add(currentPriority);
            }
            this.getPersistenceContext().commit();
        }
        catch (ImportRuntimeException e) {
            String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new ApplicationTechnicalException(message, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return result;
    }

    public List<Range> importRanges(InputStream inputStream) {
        ArrayList<Range> result = new ArrayList<Range>();
        RangeTopiaDao rangeTopiaDao = this.getPersistenceContext().getRangeDao();
        RangeImportModel importModel = new RangeImportModel(';');
        try (Import importer = Import.newImport((ImportModel)importModel, (InputStream)inputStream);){
            for (Range range : importer) {
                Range currentRange = (Range)rangeTopiaDao.forLabelEquals(range.getLabel()).findAnyOrNull();
                if (currentRange == null) {
                    currentRange = (Range)rangeTopiaDao.create((TopiaEntity)range);
                }
                result.add(currentRange);
            }
            this.getPersistenceContext().commit();
        }
        catch (ImportRuntimeException e) {
            String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new ApplicationTechnicalException(message, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return result;
    }

    public List<DemandType> importDemandTypes(InputStream inputStream) {
        ArrayList<DemandType> result = new ArrayList<DemandType>();
        DemandTypeTopiaDao demandTypeTopiaDao = this.getPersistenceContext().getDemandTypeDao();
        DemandTypeImportModel importModel = new DemandTypeImportModel(';');
        try (Import importer = Import.newImport((ImportModel)importModel, (InputStream)inputStream);){
            for (DemandType demandType : importer) {
                DemandType currentDemandType = (DemandType)demandTypeTopiaDao.forLabelEquals(demandType.getLabel()).findAnyOrNull();
                if (currentDemandType == null) {
                    currentDemandType = (DemandType)demandTypeTopiaDao.create((TopiaEntity)demandType);
                }
                result.add(currentDemandType);
            }
            this.getPersistenceContext().commit();
        }
        catch (ImportRuntimeException e) {
            String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new ApplicationTechnicalException(message, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return result;
    }
}

