/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.pdfeditor;

import com.franciaflex.faxtomail.persistence.entities.AttachmentFile;
import com.franciaflex.faxtomail.ui.swing.content.pdfeditor.PDFEditorCrossUI;
import com.franciaflex.faxtomail.ui.swing.content.pdfeditor.PDFEditorHighlighterUI;
import com.franciaflex.faxtomail.ui.swing.content.pdfeditor.PDFEditorLineUI;
import com.franciaflex.faxtomail.ui.swing.content.pdfeditor.PDFEditorNoteUI;
import com.franciaflex.faxtomail.ui.swing.content.pdfeditor.PDFEditorUI;
import com.franciaflex.faxtomail.ui.swing.content.pdfeditor.PDFEditorUIModel;
import com.franciaflex.faxtomail.ui.swing.util.AbstractFaxToMailUIHandler;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import com.franciaflex.faxtomail.ui.swing.util.JImagePanel;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.pdf.PdfWriter;
import com.sun.media.jai.codec.ByteArraySeekableStream;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFPage;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Date;
import java.util.List;
import javax.media.jai.PlanarImage;
import javax.swing.JComponent;
import javax.swing.JPanel;
import jaxx.runtime.swing.ComponentMover;
import jaxx.runtime.swing.ComponentResizer;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class PDFEditorUIHandler
extends AbstractFaxToMailUIHandler<PDFEditorUIModel, PDFEditorUI> {
    private static final Log log = LogFactory.getLog(PDFEditorUIHandler.class);
    protected ComponentMover cm = new ComponentMover();
    protected ComponentResizer cr = new ComponentResizer();
    protected PDFFile pdf;

    public void afterInit(PDFEditorUI pdfEditorUI) {
        this.initUI(pdfEditorUI);
        this.cm.setDragInsets(this.cr.getDragInsets());
        this.cm.setEdgeInsets(new Insets(0, 0, 0, 0));
        final PDFEditorUIModel model = (PDFEditorUIModel)((Object)this.getModel());
        ((PDFEditorUI)this.ui).getContainer().addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                Component child = e.getChild();
                PDFEditorUIModel.Page currentPage = model.getCurrentPage();
                if (child.getClass().isAssignableFrom(PDFEditorNoteUI.class)) {
                    currentPage.addNote((PDFEditorNoteUI)child);
                } else if (child.getClass().isAssignableFrom(PDFEditorCrossUI.class)) {
                    currentPage.addCross((PDFEditorCrossUI)child);
                } else if (child.getClass().isAssignableFrom(PDFEditorLineUI.class)) {
                    currentPage.addLine((PDFEditorLineUI)child);
                } else if (child.getClass().isAssignableFrom(PDFEditorHighlighterUI.class)) {
                    currentPage.addHighlighter((PDFEditorHighlighterUI)child);
                }
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                Component child = e.getChild();
                PDFEditorUIModel.Page currentPage = model.getCurrentPage();
                if (child.getClass().isAssignableFrom(PDFEditorNoteUI.class)) {
                    currentPage.removeNote((PDFEditorNoteUI)child);
                } else if (child.getClass().isAssignableFrom(PDFEditorCrossUI.class)) {
                    currentPage.removeCross((PDFEditorCrossUI)child);
                } else if (child.getClass().isAssignableFrom(PDFEditorLineUI.class)) {
                    currentPage.removeLine((PDFEditorLineUI)child);
                } else if (child.getClass().isAssignableFrom(PDFEditorHighlighterUI.class)) {
                    currentPage.removeHighlighter((PDFEditorHighlighterUI)child);
                }
            }
        });
        model.addPropertyChangeListener("currentPageIndex", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Integer pageNb = (Integer)evt.getNewValue();
                Integer prevPageNb = (Integer)evt.getOldValue();
                PDFEditorUIHandler.this.updatePageNumber(pageNb, prevPageNb);
            }
        });
        model.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PDFEditorUIModel model;
                AttachmentFile attachmentFile;
                if (("originalFile".equals(evt.getPropertyName()) || "editedFile".equals(evt.getPropertyName())) && (attachmentFile = (model = (PDFEditorUIModel)((Object)evt.getSource())).getNotNullFile()) != null) {
                    File file = attachmentFile.getFile();
                    if (!FaxToMailUIUtil.isFileAPDF(attachmentFile)) {
                        try {
                            file = PDFEditorUIHandler.this.convertFileToPdf(file);
                        }
                        catch (IOException e) {
                            if (log.isErrorEnabled()) {
                                log.error((Object)"", (Throwable)e);
                            }
                            PDFEditorUIHandler.this.getContext().getErrorHelper().showErrorDialog(I18n.t((String)"faxtomail.pdfEditor.convertToPdf.error", (Object[])new Object[0]));
                        }
                        catch (DocumentException e) {
                            if (log.isErrorEnabled()) {
                                log.error((Object)"", (Throwable)e);
                            }
                            PDFEditorUIHandler.this.getContext().getErrorHelper().showErrorDialog(I18n.t((String)"faxtomail.pdfEditor.convertToPdf.error", (Object[])new Object[0]));
                        }
                    }
                    if (FaxToMailUIUtil.isFileAPDF(attachmentFile)) {
                        try {
                            RandomAccessFile raf = new RandomAccessFile(file, "r");
                            FileChannel channel = raf.getChannel();
                            MappedByteBuffer buf = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
                            PDFEditorUIHandler.this.pdf = new PDFFile((ByteBuffer)buf);
                            model.setPageNumber(PDFEditorUIHandler.this.pdf.getNumPages());
                            model.setCurrentPageIndex(1);
                        }
                        catch (IOException e) {
                            if (log.isErrorEnabled()) {
                                log.error((Object)"", (Throwable)e);
                            }
                            PDFEditorUIHandler.this.getContext().getErrorHelper().showErrorDialog(I18n.t((String)"faxtomail.pdfEditor.readPdf.error", (Object[])new Object[0]));
                        }
                    }
                    ((PDFEditorUI)PDFEditorUIHandler.this.getUI()).setCursor(Cursor.getDefaultCursor());
                    model.firePropertyChanged("currentPageIndex", null, 1);
                }
            }
        });
        model.addPropertyChangeListener("zoom", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PDFEditorUIHandler.this.displayPage(model.getCurrentPageIndex(), ((Float)evt.getOldValue()).floatValue(), model.getRotation());
            }
        });
        model.addPropertyChangeListener("rotation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PDFEditorUIHandler.this.displayPage(model.getCurrentPageIndex(), model.getZoom(), (Integer)evt.getOldValue());
            }
        });
    }

    protected JComponent getComponentToFocus() {
        return null;
    }

    public SwingValidator<PDFEditorUIModel> getValidator() {
        return null;
    }

    public void onCloseUI() {
    }

    public void addNote() {
        PDFEditorNoteUI note = new PDFEditorNoteUI();
        String title = this.decorate(new Date()) + " - " + this.getContext().getCurrentUser().getTrigraph();
        note.setTitle(title);
        this.addPanel(note);
    }

    public void addCross() {
        PDFEditorCrossUI cross = new PDFEditorCrossUI();
        this.addPanel(cross);
        this.cr.registerComponent(new Component[]{cross});
    }

    public void addLine() {
        PDFEditorLineUI line = new PDFEditorLineUI();
        this.addPanel(line);
        this.cr.registerComponent("horizontal", new Component[]{line});
    }

    public void addHighlighter() {
        PDFEditorHighlighterUI highlighter = new PDFEditorHighlighterUI();
        this.addPanel(highlighter);
        this.cr.registerComponent(new Component[]{highlighter});
    }

    protected void addPanel(JPanel panel) {
        JPanel container = ((PDFEditorUI)this.ui).getContainer();
        container.add((Component)panel, 0);
        Insets insets = container.getInsets();
        Dimension size = panel.getPreferredSize();
        Rectangle rect = container.getVisibleRect();
        panel.setBounds(rect.x + insets.left, rect.y + insets.top, size.width, size.height);
        container.updateUI();
        this.cm.registerComponent(new Component[]{panel});
    }

    protected void updatePageNumber(Integer pageNb, Integer prevPageNb) {
        if (this.pdf != null && pageNb != null) {
            if (prevPageNb != null) {
                PDFEditorUIModel.Page p = ((PDFEditorUIModel)((Object)this.getModel())).getPage(prevPageNb);
                for (JPanel jPanel : p.getNotes()) {
                    jPanel.setVisible(false);
                }
                for (JPanel jPanel : p.getCrosses()) {
                    jPanel.setVisible(false);
                }
            }
            this.displayPage(pageNb, ((PDFEditorUIModel)((Object)this.getModel())).getZoom(), ((PDFEditorUIModel)((Object)this.getModel())).getRotation());
        }
    }

    protected void displayPage(int pageNb, float previousZoom, int previousRotation) {
        PDFPage page = this.pdf.getPage(pageNb);
        Rectangle2D bBox = page.getBBox();
        Rectangle rect = new Rectangle(0, 0, (int)bBox.getWidth(), (int)bBox.getHeight());
        float zoom = ((PDFEditorUIModel)((Object)this.getModel())).getZoom();
        int rotation = ((PDFEditorUIModel)((Object)this.getModel())).getRotation();
        int width = (int)(zoom * (float)rect.width);
        int height = (int)(zoom * (float)rect.height);
        Image image = page.getImage(width, height, (Rectangle2D)rect, null, true, true);
        JPanel container = ((PDFEditorUI)this.getUI()).getContainer();
        Dimension containerSize = new Dimension(rotation % 180 == 0 ? width : height, rotation % 180 == 0 ? height : width);
        container.setPreferredSize(containerSize);
        container.setMinimumSize(containerSize);
        container.setMaximumSize(containerSize);
        container.setSize(containerSize);
        JImagePanel documentPanel = ((PDFEditorUI)this.ui).getDocumentPanel();
        documentPanel.setRotation(rotation);
        documentPanel.setImage(image);
        Insets insets = container.getInsets();
        rect = container.getBounds();
        float zoomRatio = zoom / previousZoom;
        int rotationDiff = rotation - previousRotation;
        PDFEditorUIModel.Page p = ((PDFEditorUIModel)((Object)this.getModel())).getPage(pageNb);
        for (PDFEditorNoteUI panel : p.getNotes()) {
            int y;
            int x;
            panel.setVisible(true);
            panel.setZoom(Float.valueOf(zoom));
            Rectangle bounds = panel.getBounds();
            if (rotationDiff == 0) {
                x = bounds.x;
                y = bounds.y;
            } else if (rotationDiff == 90 || rotationDiff == -270) {
                x = rect.width - bounds.height / 2 - bounds.width / 2 - bounds.y;
                y = bounds.x + bounds.width / 2 - bounds.height / 2;
            } else {
                x = bounds.y + bounds.height / 2 - bounds.width / 2;
                y = rect.height - bounds.height / 2 - bounds.width / 2 - bounds.x;
            }
            panel.setBounds((int)(zoomRatio * (float)x) + insets.left, (int)(zoomRatio * (float)y) + insets.top, (int)(zoomRatio * (float)bounds.width), (int)(zoomRatio * (float)bounds.height));
        }
        boolean orientation180 = Math.abs(rotationDiff) % 180 == 0;
        for (PDFEditorCrossUI panel : p.getCrosses()) {
            int y;
            int x;
            int newHeight;
            panel.setVisible(true);
            Rectangle bounds = panel.getBounds();
            int newWidth = orientation180 ? bounds.width : bounds.height;
            int n = newHeight = orientation180 ? bounds.height : bounds.width;
            if (rotationDiff == 0) {
                x = bounds.x;
                y = bounds.y;
            } else if (rotationDiff == 90 || rotationDiff == -270) {
                x = rect.width - newWidth - bounds.y;
                y = bounds.x;
            } else {
                x = bounds.y;
                y = rect.height - newHeight - bounds.x;
            }
            panel.setBounds((int)(zoomRatio * (float)x) + insets.left, (int)(zoomRatio * (float)y) + insets.top, (int)(zoomRatio * (float)newWidth), (int)(zoomRatio * (float)newHeight));
        }
        List<PDFEditorLineUI> lines = p.getLines();
        this.cr.deregisterComponent((Component[])lines.toArray(new PDFEditorLineUI[lines.size()]));
        for (PDFEditorLineUI panel : lines) {
            int y;
            int x;
            int newHeight;
            panel.setVisible(true);
            Rectangle bounds = panel.getBounds();
            boolean horizontal = panel.isHorizontal();
            panel.setHorizontal(orientation180 ? horizontal : !horizontal);
            int newWidth = orientation180 ? bounds.width : bounds.height;
            int n = newHeight = orientation180 ? bounds.height : bounds.width;
            if (rotationDiff == 0) {
                x = bounds.x;
                y = bounds.y;
            } else if (rotationDiff == 90 || rotationDiff == -270) {
                x = rect.width - newWidth - bounds.y;
                y = bounds.x;
            } else {
                x = bounds.y;
                y = rect.height - newHeight - bounds.x;
            }
            panel.setBounds((int)(zoomRatio * (float)x) + insets.left, (int)(zoomRatio * (float)y) + insets.top, (int)(zoomRatio * (float)newWidth), (int)(zoomRatio * (float)newHeight));
            this.cr.registerComponent(panel.isHorizontal() != false ? "horizontal" : "vertical", new Component[]{panel});
        }
        for (PDFEditorHighlighterUI panel : p.getHighlighters()) {
            int y;
            int x;
            int newHeight;
            panel.setVisible(true);
            Rectangle bounds = panel.getBounds();
            int newWidth = orientation180 ? bounds.width : bounds.height;
            int n = newHeight = orientation180 ? bounds.height : bounds.width;
            if (rotationDiff == 0) {
                x = bounds.x;
                y = bounds.y;
            } else if (rotationDiff == 90 || rotationDiff == -270) {
                x = rect.width - newWidth - bounds.y;
                y = bounds.x;
            } else {
                x = bounds.y;
                y = rect.height - newHeight - bounds.x;
            }
            panel.setBounds((int)(zoomRatio * (float)x) + insets.left, (int)(zoomRatio * (float)y) + insets.top, (int)(zoomRatio * (float)newWidth), (int)(zoomRatio * (float)newHeight));
        }
        container.updateUI();
    }

    public File convertFileToPdf(File file) throws IOException, DocumentException {
        AttachmentFile attachmentFile = ((PDFEditorUIModel)((Object)this.getModel())).getNotNullFile();
        File target = File.createTempFile("faxtomail-", ".tmp");
        target.deleteOnExit();
        Document document = new Document();
        FileOutputStream fos = new FileOutputStream(target);
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)fos);
        writer.open();
        document.setPageSize(PageSize.A4);
        document.open();
        if (FaxToMailUIUtil.isFileATxt(attachmentFile)) {
            FileReader fr = new FileReader(file);
            BufferedReader br = new BufferedReader(fr);
            StringBuilder text = new StringBuilder();
            while (br.readLine() != null) {
                text.append(br.readLine()).append("\n");
            }
            document.add((Element)new Paragraph(text.toString()));
        } else if (FaxToMailUIUtil.isFileATif(attachmentFile)) {
            FileInputStream fis = new FileInputStream(file);
            FileChannel channel = fis.getChannel();
            ByteBuffer buffer = ByteBuffer.allocate((int)channel.size());
            channel.read(buffer);
            ByteArraySeekableStream stream = new ByteArraySeekableStream(buffer.array());
            String[] names = ImageCodec.getDecoderNames((SeekableStream)stream);
            ImageDecoder tifImageDecoder = ImageCodec.createImageDecoder((String)names[0], (SeekableStream)stream, null);
            for (int i = 0; i < tifImageDecoder.getNumPages(); ++i) {
                RenderedImage renderedImage = tifImageDecoder.decodeAsRenderedImage(i);
                BufferedImage awtImage = PlanarImage.wrapRenderedImage((RenderedImage)renderedImage).getAsBufferedImage();
                document.newPage();
                com.itextpdf.text.Image image = com.itextpdf.text.Image.getInstance((PdfWriter)writer, (Image)awtImage, (float)1.0f);
                image.scaleToFit(PageSize.A4.getWidth() - document.leftMargin() - document.rightMargin(), PageSize.A4.getHeight() - document.topMargin() - document.bottomMargin());
                document.add((Element)image);
            }
        } else {
            URL resource = file.toURI().toURL();
            com.itextpdf.text.Image image = com.itextpdf.text.Image.getInstance((URL)resource);
            float scaler = (document.getPageSize().getWidth() - document.leftMargin() - document.rightMargin()) / image.getWidth() * 100.0f;
            image.scalePercent(scaler);
            document.add((Element)image);
        }
        document.close();
        writer.close();
        AttachmentFile attachmentFileNew = this.getContext().getEmailService().getAttachmentFileFromStream((InputStream)new FileInputStream(target));
        attachmentFileNew.setFilename(attachmentFile.getFilename() + ".pdf");
        ((PDFEditorUIModel)((Object)this.getModel())).setEditedFile(attachmentFileNew);
        return target;
    }

    public void zoomOut() {
        PDFEditorUIModel model = (PDFEditorUIModel)((Object)this.getModel());
        float zoom = model.getZoom();
        model.setZoom(zoom - 0.25f);
    }

    public void zoomIn() {
        PDFEditorUIModel model = (PDFEditorUIModel)((Object)this.getModel());
        float zoom = model.getZoom();
        model.setZoom(zoom + 0.25f);
    }

    public void rotateClockwise() {
        int rotation = ((PDFEditorUIModel)((Object)this.getModel())).getRotation();
        ((PDFEditorUIModel)((Object)this.getModel())).setRotation((360 + rotation + 90) % 360);
    }

    public void rotateAntiClockwise() {
        int rotation = ((PDFEditorUIModel)((Object)this.getModel())).getRotation();
        ((PDFEditorUIModel)((Object)this.getModel())).setRotation((360 + rotation - 90) % 360);
    }

    public void print() {
        FaxToMailUIUtil.print(((PDFEditorUIModel)((Object)this.getModel())).getEditedFile(), false);
    }
}

