/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.demande.demandgroup;

import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.content.MainUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandesUI;
import com.franciaflex.faxtomail.ui.swing.content.demande.demandgroup.DemandGroupItem;
import com.franciaflex.faxtomail.ui.swing.content.demande.demandgroup.DemandGroupUI;
import com.franciaflex.faxtomail.ui.swing.util.AbstractToolbarPopupHandler;
import com.google.common.collect.Iterables;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.ApplicationUI;

public class DemandGroupUIHandler
extends AbstractToolbarPopupHandler<DemandeUIModel, DemandGroupUI> {
    private static final Log log = LogFactory.getLog(DemandGroupUIHandler.class);

    public void beforeInit(DemandGroupUI ui) {
        super.beforeInit((ApplicationUI)ui);
        DemandeUIModel currentEmail = this.getContext().getCurrentEmail();
        ((DemandGroupUI)this.ui).setContextValue(currentEmail);
    }

    @Override
    public void afterInit(DemandGroupUI ui) {
        super.afterInit(ui);
        this.initTable(ui.getDemandGroup());
        ((DemandeUIModel)this.getModel()).addPropertyChangeListener("groupedDemandes", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AbstractTableModel tableModel = (AbstractTableModel)((DemandGroupUI)DemandGroupUIHandler.this.getUI()).getDemandGroup().getModel();
                tableModel.fireTableDataChanged();
            }
        });
    }

    protected void initTable(JXTable table) {
        AbstractTableModel demandGroupTableModel = new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return ((DemandeUIModel)DemandGroupUIHandler.this.getModel()).sizeGroupedDemandes() + 1;
            }

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                if (rowIndex == 0) {
                    return DemandGroupUIHandler.this.getModel();
                }
                return Iterables.get(((DemandeUIModel)DemandGroupUIHandler.this.getModel()).getGroupedDemandes(), (int)(rowIndex - 1));
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return true;
            }
        };
        demandGroupTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                ((DemandGroupUI)DemandGroupUIHandler.this.getUI()).pack();
            }
        });
        DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
        TableColumn column = new TableColumn();
        column.setCellRenderer(new DemandGroupItemRenderer());
        column.setCellEditor(new DemandGroupItemEditor());
        columnModel.addColumn(column);
        table.setModel((TableModel)demandGroupTableModel);
        table.setColumnModel((TableColumnModel)columnModel);
        table.addHighlighter(HighlighterFactory.createAlternateStriping());
    }

    public void onCloseUI() {
    }

    public SwingValidator<DemandeUIModel> getValidator() {
        return null;
    }

    protected JComponent getComponentToFocus() {
        return null;
    }

    public void openDemande(DemandeUIModel demande) {
        this.closeEditor();
        FaxToMailUIContext context = this.getContext();
        demande.setCloseable(true);
        FaxToMailUser takenBy = demande.getTakenBy();
        FaxToMailUser currentUser = this.getContext().getCurrentUser();
        if (demande.getArchiveDate() != null) {
            demande.setEditable(false);
        } else if (takenBy != null && !currentUser.equals(takenBy)) {
            String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n.t((String)"faxtomail.alert.alreadyTakenBy.message", (Object[])new Object[]{this.decorate((Serializable)takenBy)}), I18n.t((String)"faxtomail.alert.alreadyTakenBy.help", (Object[])new Object[0]));
            int result = JOptionPane.showConfirmDialog(this.getTopestUI(), htmlMessage, I18n.t((String)"faxtomail.alert.alreadyTakenBy.title", (Object[])new Object[0]), 1, 3);
            switch (result) {
                case 2: {
                    return;
                }
                case 1: {
                    demande.setEditable(false);
                    break;
                }
                case 0: {
                    Email email = this.getContext().getEmailService().takeEmail(demande.getTopiaId(), currentUser);
                    demande.fromEntity(email);
                    demande.setEditable(true);
                }
            }
        }
        MainUIHandler mainUIHandler = context.getMainUI().getHandler();
        DemandesUI parentContainer = (DemandesUI)mainUIHandler.getCurrentBody();
        parentContainer.getModel().addDemand(demande);
    }

    protected class DemandGroupItemEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        protected DemandGroupItem demandGroupItem;

        public DemandGroupItemEditor() {
            this.demandGroupItem = new DemandGroupItem(DemandGroupUIHandler.this);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            DemandeUIModel demand = (DemandeUIModel)value;
            this.demandGroupItem.setDemande(demand);
            return this.demandGroupItem;
        }

        @Override
        public Object getCellEditorValue() {
            return this.demandGroupItem.getDemande();
        }

        @Override
        public boolean stopCellEditing() {
            return super.stopCellEditing();
        }

        @Override
        protected void fireEditingStopped() {
            super.fireEditingStopped();
        }
    }

    protected class DemandGroupItemRenderer
    extends DemandGroupItem
    implements TableCellRenderer {
        public DemandGroupItemRenderer() {
            super(DemandGroupUIHandler.this);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            DemandeUIModel demand = (DemandeUIModel)value;
            this.setDemande(demand);
            return this;
        }
    }
}

