/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.actions;

import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.ui.swing.actions.AbstractFaxToMailAction;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeListUI;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeListUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeListUIModel;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.nuiton.i18n.I18n;

public class LoadFolderEmailsAction
extends AbstractFaxToMailAction<DemandeListUIModel, DemandeListUI, DemandeListUIHandler> {
    private static final Log log = LogFactory.getLog(LoadFolderEmailsAction.class);

    public LoadFolderEmailsAction(DemandeListUIHandler handler) {
        super(handler, false);
    }

    public boolean prepareAction() throws Exception {
        DemandeListUIModel model = (DemandeListUIModel)this.getModel();
        MailFolder folder = model.getSelectedFolder();
        JXTable dataTable = ((DemandeListUI)this.getUI()).getDataTable();
        this.setActionDescription(I18n.t((String)"faxtomail.action.loadFolderEmails.tip", (Object[])new Object[]{folder.getName()}));
        this.getContext().getSwingSession().updateState();
        String columns = ((DemandeListUIHandler)this.handler).populateColumnModel(dataTable, false);
        dataTable.setName("dataTable" + columns);
        this.getContext().getSwingSession().add((Component)dataTable, true);
        return true;
    }

    @Override
    public void doAction() throws Exception {
        DemandeListUIHandler handler = (DemandeListUIHandler)this.getHandler();
        DemandeListUIModel model = (DemandeListUIModel)this.getModel();
        MailFolder folder = model.getSelectedFolder();
        List emails = this.getContext().getEmailService().getEmailForFolder(folder);
        log.info((Object)(emails.size() + " emails in folder " + folder.getName()));
        ArrayList<DemandeUIModel> demands = new ArrayList<DemandeUIModel>();
        for (Email email : emails) {
            DemandeUIModel demand = new DemandeUIModel();
            demand.fromEntity(email, false);
            demand.setValid(handler.isDemandeValid(demand));
            demands.add(demand);
        }
        model.setEmails(demands);
    }
}

