/*
 * Decompiled with CFR 0.152.
 */
package org.sharengo.wikitty.hbase.test;

import java.io.FileInputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseClusterTestCase;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;

public class StandAloneServer
extends HBaseClusterTestCase {
    public static final String DataIhmProperty = "standalone.ihm";
    protected Log log = LogFactory.getLog(StandAloneServer.class);
    private static String[] tables = new String[]{"wikitty", "extension"};
    private static String[] families = new String[]{"admin", "data"};

    public StandAloneServer(Properties props) {
        super(1, StandAloneServer.isProp(props, "standalone.startDfs", true));
        this.setName("StandaloneServer");
        this.conf.set("hbase.regionserver.info.port", "-1");
        this.conf.set("hbase.master.info.port", "-1");
        this.conf.set("hbase.regionserver.safemode", "off");
        this.conf.set("test.build.data", System.getProperty("test.build.data"));
    }

    private static boolean isProp(Properties props, String key, boolean _default) {
        String value = (String)props.get(key);
        if (value == null) {
            return _default;
        }
        return "true".equals(value.toLowerCase());
    }

    public void startup() throws Exception {
        this.setUp();
        this.checkTables();
    }

    private void checkTables() throws Exception {
        HBaseAdmin hBaseAdmin = new HBaseAdmin(this.conf);
        for (String tableName : tables) {
            if (hBaseAdmin.tableExists(tableName)) continue;
            this.log.info((Object)("Create table " + tableName + " ..."));
            HTableDescriptor hTableDescriptor = new HTableDescriptor(tableName);
            for (String family : families) {
                hTableDescriptor.addFamily(new HColumnDescriptor(family));
            }
            hBaseAdmin.createTable(hTableDescriptor);
        }
    }

    public void shutdown() throws Exception {
        this.tearDown();
    }

    public HBaseConfiguration getConfiguration() {
        return this.conf;
    }

    public static void main(String[] args) throws Exception {
        Properties props = new Properties();
        if (args.length > 0) {
            String filename = args[0];
            props.load(new FileInputStream(filename));
        }
        final StandAloneServer sas = new StandAloneServer(props);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    sas.shutdown();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        sas.startup();
        new HTable(sas.getConfiguration(), HConstants.META_TABLE_NAME);
        sas.log.info((Object)"Server started ...");
    }
}

